/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure;

import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.io.office.ExcelReader;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.io.office.model.reader.StringValueReader;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import com.suncode.cuf.plannedtask.administration.structure.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureImporter;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureValidator;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.GroupMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.OrgUnitMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.PositionMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.UserMappings;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.logging.LoggerLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOrgStructure {
    private static final Logger taskLog = LoggerFactory.getLogger((String)"ScheduledTask");
    public static final String APPEND = "APPEND";
    public static final String STANDARD = "STANDARD";
    public static final String OVERRIDE = "OVERRIDE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="importStructure", description="importStructure", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path, @TaskParam(name="read_mode", description="read_mode_desc") String mode) throws Exception {
        ContextLogger.set(taskLog, LoggerLevel.INFO);
        try {
            List<SheetDefinition> sheetDefinitions = this.readSheetDefinitions(path);
            StructureData data = new StructureData(sheetDefinitions);
            StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
            validator.validateStructure(data, mode);
            StructureImporter importer = new StructureImporter();
            importer.importStructure(data, this.resolveMode(mode));
        }
        finally {
            ContextLogger.clear();
        }
    }

    private List<SheetDefinition> readSheetDefinitions(String path) throws FileNotFoundException {
        ExcelReader reader = new ExcelReader();
        List<ImportSheetDefinition> sheetDefinitions = this.buildDefinitions();
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            taskLog.error("Brak pliku lub praw do odczytu. Prosz\u0119 sprawdzi\u0107 czy podany plik istnieje na serwerze, gdzie zainstalowany jest system lub prawa dost\u0119pu do pliku: " + path);
        }
        return reader.read(sheetDefinitions, new FileInputStream(path));
    }

    private ImportSheetDefinition getSheetDefinitionForStructure(String name, StructureMappings structureMappings) {
        ImportSheetDefinition sheet = new ImportSheetDefinition(name, structureMappings);
        HashMap<String, ValueReader> valueReaders = new HashMap<String, ValueReader>();
        for (String key : structureMappings.getReverseColumnMappings().keySet()) {
            valueReaders.put(key, new StringValueReader());
        }
        sheet.setValueReaders(valueReaders);
        return sheet;
    }

    private List<ImportSheetDefinition> buildDefinitions() {
        ArrayList<ImportSheetDefinition> definitions = new ArrayList<ImportSheetDefinition>();
        definitions.add(this.getSheetDefinitionForStructure("U\u017cytkownicy", UserMappings.getInstance()));
        definitions.add(this.getSheetDefinitionForStructure("Grupy", GroupMappings.getInstance()));
        definitions.add(this.getSheetDefinitionForStructure("Stanowiska", PositionMappings.getInstance()));
        definitions.add(this.getSheetDefinitionForStructure("Jednostki organizacyjne", OrgUnitMappings.getInstance()));
        return definitions;
    }

    private ImportStructureMode resolveMode(String mode) {
        if (mode.equalsIgnoreCase(APPEND)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureAppendMode");
        }
        if (mode.equalsIgnoreCase(STANDARD)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureStandardMode");
        }
        if (mode.equalsIgnoreCase(OVERRIDE)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureOverrideMode");
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany tryb importu: " + mode);
    }
}

