/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper.internal;

import com.suncode.cuf.administartion.structure.RoleHelper;
import com.suncode.cuf.plannedtask.administration.helper.ImportStructureMode;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component(value="importStructureOverrideMode")
@Scope(value="prototype")
public class OverrideMode
implements ImportStructureMode {
    private static final Logger log = LoggerFactory.getLogger(OverrideMode.class);
    @Autowired
    private StructureService structureService;
    @Autowired
    protected UserService userService;
    @Autowired
    private RoleService rs;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    protected OrganizationalUnitFinder ouFinder;
    @Autowired
    protected PositionFinder positionFinder;
    @Autowired
    private RoleHelper roleHelper;
    @Autowired
    private UserGroupFinder groupFinder;
    private Set<String> userNames = new HashSet<String>();
    private Set<String> positionSymbols = new HashSet<String>();
    private Set<String> ouSymbols = new HashSet<String>();
    private Set<String> groupNames = new HashSet<String>();

    @Override
    public User buildUser(Map<String, String> row, int i, List<Map<String, String>> structure) throws UserNotFoundException, GroupNotFoundException, UserAlreadyExistException, GroupAlreadyExistException {
        List<UserGroup> groups = this.initGroups(row);
        String userName = row.get("userName");
        User user = this.userFinder.findByUserName(userName, false, new String[0]);
        if (user != null) {
            this.setUserData(user, row);
            user = this.updateUser(user, row, groups);
            this.changePassword(user, row.get("password"));
        } else {
            user = new User(userName, this.getPassword(row.get("password")));
            this.setUserData(user, row);
            user = this.createUser(user, groups);
        }
        List<Position> positions = this.buildPositions(user, i, structure);
        this.assignPositionToUser(user, positions);
        return this.userFinder.findByUserName(userName, new String[]{"positions"});
    }

    private String getPassword(String pass) {
        return (String)StringUtils.defaultIfBlank((CharSequence)pass, (CharSequence)"");
    }

    @Override
    public User updateUser(User user, Map<String, String> data, List<UserGroup> groups) throws UserNotFoundException, GroupNotFoundException {
        this.userNames.add(user.getUserName());
        this.userService.updateUser(user);
        this.userService.addUserToGroups(user.getUserName(), this.toNames(groups));
        this.removeUserFromOtherGroups(user.getUserName(), groups);
        return user;
    }

    @Override
    public void removeUnusedElements() throws GroupNotFoundException {
        this.removeUnusedUsers();
        this.removeUnusedGroups();
        this.removeUnusedPositions();
        this.removeUnusedOus();
    }

    private void removeUnusedOus() {
        DetachedCriteria criteria = DetachedCriteria.forClass(OrganizationalUnit.class);
        if (!this.ouSymbols.isEmpty()) {
            criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"symbol", this.ouSymbols)));
        }
        List ous = this.ouFinder.findByCriteria(criteria);
        for (OrganizationalUnit ou : ous) {
            this.structureService.deleteOrganizationalUnit(ou.getSymbol());
        }
    }

    private void removeUnusedPositions() {
        DetachedCriteria criteria = DetachedCriteria.forClass(Position.class);
        if (!this.positionSymbols.isEmpty()) {
            criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"symbol", this.positionSymbols)));
        }
        this.positionFinder.findByCriteria(criteria).forEach(position -> this.structureService.deletePosition(position.getSymbol()));
    }

    private void removeUnusedGroups() throws GroupNotFoundException {
        DetachedCriteria criteria = DetachedCriteria.forClass(UserGroup.class);
        criteria.add((Criterion)Restrictions.ne((String)"name", (Object)"SharkGroup"));
        criteria.add((Criterion)Restrictions.ne((String)"name", (Object)"Administrators"));
        criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"name", this.groupNames)));
        List groups = this.groupFinder.findByCriteria(criteria);
        for (UserGroup userGroup : groups) {
            this.userService.deleteGroup(userGroup.getName());
        }
    }

    private void removeUnusedUsers() {
        DetachedCriteria criteria = DetachedCriteria.forClass(User.class);
        criteria.add((Criterion)Restrictions.ne((String)"userName", (Object)"admin"));
        criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"userName", this.userNames)));
        this.userFinder.findByCriteria(criteria).forEach(user -> this.deleteUserIfPossible((User)user));
    }

    private void deleteUserIfPossible(User user) {
        String userName = user.getUserName();
        try {
            if (user.isActive().booleanValue()) {
                this.userService.deactivateUser(userName);
                log.debug("Deaktywacja uzytkownika: " + userName);
            }
            this.userService.deleteUser(userName);
            log.debug("Usuniecie uzytkownika: " + userName);
        }
        catch (Exception e) {
            log.warn("Nie mo\u017cna usun\u0105\u0107 u\u017cytkownika: " + userName + ", gdy\u017c posiada on zale\u017cno\u015bci w systemie. U\u017cytkownik pozosta\u0142 zdezaktywowany.");
        }
    }

    void removeUserFromOtherGroups(String userName, List<UserGroup> groups) {
        User user = this.userFinder.findByUserName(userName, new String[]{"groups"});
        ArrayList<String> toRemove = new ArrayList<String>();
        for (UserGroup actual : user.getGroups()) {
            boolean remove = true;
            for (UserGroup ug : groups) {
                if (!actual.getName().equals(ug.getName())) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            toRemove.add(actual.getName());
        }
        this.userService.removeUserFromGroups(userName, toRemove);
    }

    @Override
    public User createUser(User user, List<UserGroup> groups) throws UserAlreadyExistException, GroupNotFoundException {
        this.userNames.add(user.getUserName());
        log.debug("USERNAME: " + user.getUserName());
        this.userService.createUser(user, groups.get(0).getName());
        if (groups.size() > 1) {
            this.userService.addUserToGroups(user.getUserName(), this.toNames(groups.subList(1, groups.size())));
        }
        return user;
    }

    protected List<String> toNames(List<UserGroup> subList) {
        ArrayList<String> names = new ArrayList<String>();
        for (UserGroup ug : subList) {
            names.add(ug.getName());
        }
        this.groupNames.addAll(names);
        return names;
    }

    @Override
    public Position createPosition(String name, String symbol) {
        this.positionSymbols.add(symbol);
        Position p = new Position(name, symbol);
        this.structureService.createPosition(p);
        return p;
    }

    @Override
    public OrganizationalUnit createOrganizationalUnit(String name, String symbol) {
        this.ouSymbols.add(symbol);
        OrganizationalUnit ou = new OrganizationalUnit(name, symbol);
        this.structureService.createOrganizationalUnit(ou);
        return ou;
    }

    @Override
    public void updatePosition(Position p) {
        this.positionSymbols.add(p.getSymbol());
        this.structureService.updatePosition(p);
    }

    @Override
    @Transactional
    public void assignPositionToUser(User user, List<Position> positions) {
        for (Position position : positions) {
            this.structureService.addPositionToUser(user.getUserName(), position.getId());
        }
    }

    @Override
    public void changePassword(User user, String pass) {
        if (StringUtils.isNotBlank((CharSequence)pass)) {
            this.userService.changeUserPassword(user.getUserName(), pass);
        }
    }

    @Override
    public UserGroup createGroup(String groupName) throws GroupAlreadyExistException {
        this.groupNames.add(groupName);
        UserGroup ug = new UserGroup(groupName);
        this.userService.createGroup(ug);
        return ug;
    }

    @Override
    @Transactional
    public void addRoles(Position p, List<Role> roles) {
        this.rs.detachAllRoles(p.getId());
        for (Role role : roles) {
            this.rs.addRole(p.getId(), role.getId());
        }
    }

    private void setUserData(User user, Map<String, String> data) {
        user.setEmail(data.get("email"));
        user.setFirstName(data.get("firstName"));
        user.setLastName(data.get("lastName"));
        user.setNumber(data.get("number"));
    }

    private List<UserGroup> initGroups(Map<String, String> row) throws GroupAlreadyExistException {
        String[] groups = row.get("groups").split(";");
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        for (String groupName : groups) {
            UserGroup ug = this.userService.getGroup(groupName, new String[0]);
            if (ug == null) {
                ug = this.createGroup(groupName);
            }
            userGroups.add(ug);
        }
        return userGroups;
    }

    private List<Position> buildPositions(User user, int i, List<Map<String, String>> structure) {
        List<Map<String, String>> userPositions = this.getPositionsForUser(user, i, structure);
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Map<String, String> map : userPositions) {
            Position position;
            if (!this.hasPosition(map) || (position = this.initPosition(map)) == null) continue;
            positions.add(position);
        }
        return positions;
    }

    private boolean hasPosition(Map<String, String> map) {
        return !StringUtils.isBlank((CharSequence)map.get("positionSymbol"));
    }

    private Position initPosition(Map<String, String> map) {
        OrganizationalUnit ou = this.buildOu(map);
        Position position = this.buildPosition(map, ou);
        this.setRoles(position, map);
        return position;
    }

    protected Position buildPosition(Map<String, String> map, OrganizationalUnit ou) {
        Position position = this.initPosition(map.get("positionName"), map.get("positionSymbol"));
        Position higherPosition = this.initPosition("", map.get("higherPositionSymbol"));
        position.setHigherPosition(higherPosition);
        position.setOrganizationalUnit(ou);
        this.updatePosition(position);
        return position;
    }

    private void setRoles(Position position, Map<String, String> map) {
        List<Role> roles;
        if (position != null && !(roles = this.getRoles(map.get("roles"))).isEmpty()) {
            this.addRoles(position, roles);
        }
    }

    private List<Role> getRoles(String sRoles) {
        if (StringUtils.isBlank((CharSequence)sRoles)) {
            return new ArrayList<Role>();
        }
        String[] roleIds = sRoles.split(";");
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String roleId : roleIds) {
            Role r = this.roleHelper.getRole(roleId);
            Assert.notNull((Object)r, (String)"Rola nie mo\u017ce by\u0107 pusta");
            roles.add(r);
        }
        return roles;
    }

    protected OrganizationalUnit buildOu(Map<String, String> map) {
        OrganizationalUnit ou = this.initOrganizationalUnit(map.get("organizationalUnitName"), map.get("organizationalUnitSymbol"));
        if (ou != null) {
            Position dp = this.initPosition("", map.get("directorPositionSymbol"));
            OrganizationalUnit hou = this.initOrganizationalUnit("", map.get("higherOrganizationalUnitSymbol"));
            ou.setHigherOrganizationalUnit(hou);
            ou.setDirectorPosition(dp);
            this.structureService.updateOrganizationalUnit(ou);
        }
        return ou;
    }

    private Position initPosition(String name, String symbol) {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return null;
        }
        Position position = this.positionFinder.findBySymbol(symbol, new String[0]);
        if (position == null) {
            position = this.createPosition(name, symbol);
        } else {
            this.positionSymbols.add(symbol);
        }
        return position;
    }

    private OrganizationalUnit initOrganizationalUnit(String name, String symbol) {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return null;
        }
        OrganizationalUnit ou = this.ouFinder.findBySymbol(symbol, new String[0]);
        if (ou == null) {
            ou = this.createOrganizationalUnit(name, symbol);
        } else {
            this.ouSymbols.add(symbol);
        }
        return ou;
    }

    private List<Map<String, String>> getPositionsForUser(User user, int i, List<Map<String, String>> structure) {
        ArrayList<Map<String, String>> userPositions = new ArrayList<Map<String, String>>();
        while (structure.size() > i && structure.get(i).get("userName").equals(user.getUserName())) {
            userPositions.add(structure.get(i));
            ++i;
        }
        return userPositions;
    }
}

