/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.HolidaysFunctions;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.email.MailClient;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CustomEmailSender
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(CustomEmailSender.class);
    private static String sHttpSystemLink;
    private static String sMailServer;
    private static String sSMTPMailServer;
    private static String sSMTPPortNo;
    private static String sSMTPUser;
    private static String sUser;
    private static String sUserPassword;
    private static String sSMTPAuth;
    private static String sEmail;
    private static String sUseSSL;
    private static String sUseSTARTTLS;

    @AdvancedTask(name="sendNewTaskEmail", description="sendNewTaskEmail_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void sendNewTaskEmail(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefIdCES") String sProcessDefId, @TaskParam(name="advancedTask.paramName.taskName", description="advancedTask.paramDesc.taskNameCES") String sTaskDefName, @TaskParam(name="advancedTask.paramName.recipentTypeCES", description="advancedTask.paramDesc.recipentTypeCES") String sRecipentType, @TaskParam(name="advancedTask.paramName.isSuperiorCES", description="advancedTask.paramDesc.isSuperiorCES") String sIsSuperior, @TaskParam(name="advancedTask.paramName.recipentCES", description="advancedTask.paramDesc.recipentCES") String sRecipentValue, @TaskParam(name="advancedTask.paramName.onlyOwnTaskCES", description="advancedTask.paramDesc.onlyOwnTaskCES") String sOnlyOwnTask, @TaskParam(name="advancedTask.paramName.groupSendingCES", description="advancedTask.paramDesc.groupSendingCES") String sGroupSending, @TaskParam(name="advancedTask.paramName.subject", description="advancedTask.paramDesc.subject") String sSubject, @TaskParam(name="advancedTask.paramName.emailTemplateCES", description="advancedTask.paramDesc.emailTemplateCES") String sEmailTemplate) {
        log.info((Object)("sendNewTaskEmail(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ")"));
        this.sendNewTaskEmail(sProcessDefId, sTaskDefName, sRecipentType, sIsSuperior, sRecipentValue, sOnlyOwnTask, sGroupSending, sSubject, sEmailTemplate, "FALSE");
    }

    @AdvancedTask(name="sendNewTaskEmail", description="sendNewTaskEmail_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void sendNewTaskEmail(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefIdCES") String sProcessDefId, @TaskParam(name="advancedTask.paramName.taskName", description="advancedTask.paramDesc.taskNameCES") String sTaskDefName, @TaskParam(name="advancedTask.paramName.recipentTypeCES", description="advancedTask.paramDesc.recipentTypeCES") String sRecipentType, @TaskParam(name="advancedTask.paramName.isSuperiorCES", description="advancedTask.paramDesc.isSuperiorCES") String sIsSuperior, @TaskParam(name="advancedTask.paramName.recipentCES", description="advancedTask.paramDesc.recipentCES") String sRecipentValue, @TaskParam(name="advancedTask.paramName.onlyOwnTaskCES", description="advancedTask.paramDesc.onlyOwnTaskCES") String sOnlyOwnTask, @TaskParam(name="advancedTask.paramName.groupSendingCES", description="advancedTask.paramDesc.groupSendingCES") String sGroupSending, @TaskParam(name="advancedTask.paramName.subject", description="advancedTask.paramDesc.subject") String sSubject, @TaskParam(name="advancedTask.paramName.emailTemplateCES", description="advancedTask.paramDesc.emailTemplateCES") String sEmailTemplate, @TaskParam(name="advancedTask.paramName.skipSendingEmailOnHoliday", description="advancedTask.paramDesc.skipSendingEmailOnHoliday") String sSkipSendingEmailOnHoliday) {
        log.info((Object)("sendNewTaskEmail( sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ", sSkipSendingEmailOnHoliday=" + sSkipSendingEmailOnHoliday + ")"));
        long startTime = new Date().getTime();
        int iHolidaysCheck = -1;
        try {
            CustomEmailSender.readInitialEmailClientSettings();
            if (sSkipSendingEmailOnHoliday != null && sSkipSendingEmailOnHoliday.equalsIgnoreCase("TRUE")) {
                Calendar cal = Calendar.getInstance();
                iHolidaysCheck = HolidaysFunctions.checkHoliday(cal, null);
            }
            if (iHolidaysCheck == -1) {
                List<Map<String, String>> alResults;
                HashMap<String, Vector<Map<String, String>>> alRecipentsNotification;
                boolean bSuperior = false;
                boolean bOnlyOwnTask = false;
                if (sIsSuperior.compareTo("TRUE") == 0) {
                    bSuperior = true;
                }
                if (sOnlyOwnTask.compareTo("TRUE") == 0 || !Tools.isNullOrEmpty((String)sRecipentType) && sRecipentType.compareToIgnoreCase("PERFORMER") == 0) {
                    bOnlyOwnTask = true;
                }
                if ((alRecipentsNotification = CustomEmailSender.getAllRecipentsForEmailSending(sRecipentType, sRecipentValue, bSuperior, bOnlyOwnTask, alResults = CustomEmailSender.getProcessAndTaskInformations(sProcessDefId, sTaskDefName))).size() > 0) {
                    alRecipentsNotification.keySet();
                    for (String sRecipent : alRecipentsNotification.keySet()) {
                        Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sRecipent);
                        String sUserEmail = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(sRecipent);
                        if (!Tools.isNullOrEmpty((String)sUserEmail)) {
                            String sEmailToSend = this.PrapareEmailToSend(vRecipentNotification, sGroupSending, sEmailTemplate, sRecipent);
                            log.info((Object)("Wysylam email do uzytkownika < " + sRecipent + "> na adres:" + sUserEmail));
                            this.SendEmail(sUserEmail, sSubject, sEmailToSend);
                            continue;
                        }
                        log.warn((Object)("Nie mozna wysla\u0107 maila do uzytkownika < " + sRecipent + "> gdy\u017c nie ma on ustawionego adresu email"));
                    }
                }
            } else {
                log.info((Object)"Dzis jest swieto, zgodnie z ustawionym parametrem powiadomienia o nowym zadaniu nie beda wysylane");
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego sendNewTaskEmail: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="sendDeadlineTaskEmail", description="sendDeadlineTaskEmail", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void sendDeadlineTaskEmail(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefIdCES") String sProcessDefId, @TaskParam(name="advancedTask.paramName.taskName", description="advancedTask.paramDesc.taskNameCES") String sTaskDefName, @TaskParam(name="advancedTask.paramName.recipentTypeCES", description="advancedTask.paramDesc.recipentTypeCES") String sRecipentType, @TaskParam(name="advancedTask.paramName.isSuperiorCES", description="advancedTask.paramDesc.isSuperiorCES") String sIsSuperior, @TaskParam(name="advancedTask.paramName.recipentCES", description="advancedTask.paramDesc.recipentCES") String sRecipentValue, @TaskParam(name="advancedTask.paramName.onlyOwnTaskCES", description="advancedTask.paramDesc.onlyOwnTaskCES") String sOnlyOwnTask, @TaskParam(name="advancedTask.paramName.groupSendingCES", description="advancedTask.paramDesc.groupSendingCES") String sGroupSending, @TaskParam(name="advancedTask.paramName.subject", description="advancedTask.paramDesc.subject") String sSubject, @TaskParam(name="advancedTask.paramName.emailTemplateCES", description="advancedTask.paramDesc.emailTemplateCES") String sEmailTemplate) {
        log.info((Object)("sendDeadlineTaskEmail(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ")"));
        this.sendDeadlineTaskEmail(sProcessDefId, sTaskDefName, sRecipentType, sIsSuperior, sRecipentValue, sOnlyOwnTask, sGroupSending, sSubject, sEmailTemplate, "FALSE");
    }

    @AdvancedTask(name="sendDeadlineTaskEmail", description="sendDeadlineTaskEmail", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void sendDeadlineTaskEmail(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefIdCES") String sProcessDefId, @TaskParam(name="advancedTask.paramName.taskName", description="advancedTask.paramDesc.taskNameCES") String sTaskDefName, @TaskParam(name="advancedTask.paramName.recipentTypeCES", description="advancedTask.paramDesc.recipentTypeCES") String sRecipentType, @TaskParam(name="advancedTask.paramName.isSuperiorCES", description="advancedTask.paramDesc.isSuperiorCES") String sIsSuperior, @TaskParam(name="advancedTask.paramName.recipentCES", description="advancedTask.paramDesc.recipentCES") String sRecipentValue, @TaskParam(name="advancedTask.paramName.onlyOwnTaskCES", description="advancedTask.paramDesc.onlyOwnTaskCES") String sOnlyOwnTask, final @TaskParam(name="advancedTask.paramName.groupSendingCES", description="advancedTask.paramDesc.groupSendingCES") String sGroupSending, final @TaskParam(name="advancedTask.paramName.subject", description="advancedTask.paramDesc.subject") String sSubject, final @TaskParam(name="advancedTask.paramName.emailTemplateCES", description="advancedTask.paramDesc.emailTemplateCES") String sEmailTemplate, @TaskParam(name="advancedTask.paramName.skipSendingEmailOnHoliday", description="advancedTask.paramDesc.skipSendingEmailOnHoliday") String sSkipSendingEmailOnHoliday) {
        log.info((Object)("sendDeadlineTaskEmail(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ", sSkipSendingEmailInHoliday=" + sSkipSendingEmailOnHoliday + ")"));
        long startTime = new Date().getTime();
        int iHolidaysCheck = -1;
        try {
            CustomEmailSender.readInitialEmailClientSettings();
            if (sSkipSendingEmailOnHoliday != null && sSkipSendingEmailOnHoliday.equalsIgnoreCase("TRUE")) {
                Calendar cal = Calendar.getInstance();
                iHolidaysCheck = HolidaysFunctions.checkHoliday(cal, null);
            }
            if (iHolidaysCheck == -1) {
                List<Map<String, String>> alResults;
                HashMap<String, Vector<Map<String, String>>> alRecipentsNotification;
                boolean bSuperior = false;
                boolean bOnlyOwnTask = false;
                if (sIsSuperior.compareTo("TRUE") == 0) {
                    bSuperior = true;
                }
                if (sOnlyOwnTask.compareTo("TRUE") == 0 || !Tools.isNullOrEmpty((String)sRecipentType) && sRecipentType.compareToIgnoreCase("PERFORMER") == 0) {
                    bOnlyOwnTask = true;
                }
                if ((alRecipentsNotification = CustomEmailSender.getAllRecipentsForEmailSending(sRecipentType, sRecipentValue, bSuperior, bOnlyOwnTask, alResults = CustomEmailSender.getDeadlineTasksInformations(sProcessDefId, sTaskDefName))).size() > 0) {
                    final SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
                    TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)mgr);
                    alRecipentsNotification.keySet();
                    tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        public void doInTransactionWithoutResult(TransactionStatus status) {
                            for (String sRecipent : alRecipentsNotification.keySet()) {
                                Vector vRecipentNotification = (Vector)alRecipentsNotification.get(sRecipent);
                                UserTransaction sharkTransaction = mgr.getUserTransaction();
                                String userEmail = CustomEmailSender.getUserEmail(sharkTransaction, sRecipent);
                                if (!StringUtils.isBlank((CharSequence)userEmail)) {
                                    String sEmailToSend = CustomEmailSender.this.PrapareEmailToSend(vRecipentNotification, sGroupSending, sEmailTemplate, sRecipent);
                                    log.info((Object)("Wysylam email do uzytkownika < " + sRecipent + "> na adres:" + userEmail));
                                    CustomEmailSender.this.SendEmail(userEmail, sSubject, sEmailToSend);
                                    continue;
                                }
                                log.warn((Object)("Nie mozna wysla\u0107 maila do uzytkownika < " + sRecipent + "> gdy\u017c nie ma on ustawionego adresu email"));
                            }
                        }
                    });
                }
            } else {
                log.info((Object)"Dzis jest swieto, zgodnie z ustawionym parametrem powiadomienia o przekroczeniu deadline'u nie beda wysylane");
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego sendDeadlineTaskEmail: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static void readInitialEmailClientSettings() {
        log.trace((Object)"************ readInitialEmailClientSettings() ************");
        sHttpSystemLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        sMailServer = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_MAILSERVER);
        sSMTPMailServer = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPMAILSERVER);
        sSMTPPortNo = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPPORTNO).toString();
        sSMTPUser = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPUSER);
        sUser = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USER);
        sUserPassword = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USERPASSWORD);
        sSMTPAuth = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPAUTH).toString();
        sEmail = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_EMAIL);
        sUseSSL = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESSL).toString();
        sUseSTARTTLS = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESTARTTLS).toString();
    }

    private static HashMap<String, Vector<Map<String, String>>> getAllRecipentsForEmailSending(String sRecipentType, String sRecipentValue, boolean bSuperior, boolean bOnlyOwnTask, List<Map<String, String>> alTaskResults) {
        log.trace((Object)("************ getAllRecipentsForEmailSending(sRecipentType=" + sRecipentType + ", sRecipentValue=" + sRecipentValue + ", bSuperior=" + String.valueOf(bSuperior) + ", bOnlyOwnTask=" + String.valueOf(bOnlyOwnTask) + ", List<Map<String, String>>) ************"));
        HashMap<String, Vector<Map<String, String>>> alRecipentsNotification = new HashMap<String, Vector<Map<String, String>>>();
        for (Map<String, String> mapResult : alTaskResults) {
            String sPerformer;
            if (bOnlyOwnTask) {
                sPerformer = mapResult.get("resourceid");
                if (bSuperior || !CustomEmailSender.checkPerformerAsRecipent(sPerformer, sRecipentType, sRecipentValue)) continue;
                Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sPerformer);
                if (vRecipentNotification == null) {
                    vRecipentNotification = new Vector();
                }
                vRecipentNotification.add(mapResult);
                alRecipentsNotification.put(sPerformer, vRecipentNotification);
                continue;
            }
            if (!bSuperior) continue;
            sPerformer = mapResult.get("resourceid");
            ArrayList alSuperiors = UsersManagement.getUserSuperior((String)sPerformer);
            for (String sSuperior : alSuperiors) {
                if (!CustomEmailSender.checkPerformerAsRecipent(sSuperior, sRecipentType, sRecipentValue)) continue;
                Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sSuperior);
                if (vRecipentNotification == null) {
                    vRecipentNotification = new Vector();
                }
                vRecipentNotification.add(mapResult);
                alRecipentsNotification.put(sSuperior, vRecipentNotification);
            }
        }
        return alRecipentsNotification;
    }

    private static boolean checkPerformerAsRecipent(String sUserId, String sRecipentType, String sRecipentValue) {
        log.trace((Object)("************ checkPerformerAsRecipent(sUserId=" + sUserId + ", sRecipentType=" + sRecipentType + ", sRecipentValue=" + sRecipentValue + ") ************"));
        boolean bRet = true;
        return bRet;
    }

    private static String getUserEmail(UserTransaction transaction, String recipient) {
        String userEmail;
        try {
            userEmail = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(transaction, recipient);
        }
        catch (Exception e) {
            userEmail = null;
        }
        return userEmail;
    }

    public static List<Map<String, String>> getProcessAndTaskInformations(String sProcessDefId, String sTaskDefName) throws Exception {
        log.trace((Object)("************ getProcessAndTaskInformations(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ") ************"));
        ArrayList<Map<String, String>> alResults = new ArrayList<Map<String, String>>();
        List supportedLocales = I18N.getSupportedLocales().stream().map(Locale::getLanguage).collect(Collectors.toList());
        String sQuery = "SELECT ";
        for (String locale : supportedLocales) {
            sQuery = sQuery + "(SELECT pt.name FROM pm_process_translation pt WHERE pt.processId = processes.id AND pt.language = '" + locale + "' ) processname_" + locale + ", ";
            sQuery = sQuery + "(SELECT at.name FROM pm_activity_translation at WHERE at.packageid = processdefinitions.packageid and at.processdefid = processdefinitions.processdefinitionid and at.activitydefid = activities.activitydefinitionid and at.language = '" + locale + "' ) activityname_" + locale + ", ";
        }
        sQuery = sQuery + "processes.started processstarttime, assignmentstable.activityid activityid,assignmentstable.activityprocessid processid, activities.activated activitystarttime, assignmentstable.resourceid resourceid, processdefinitions.processdefinitionid processdefid  FROM assignmentstable JOIN  activities ON assignmentstable.activityid = activities.id JOIN  processes ON assignmentstable.activityprocessid = processes.id JOIN  processdefinitions ON assignmentstable.activityprocessdefname = processdefinitions.name ";
        I18N oMessage = new I18N();
        LinkedHashMap<String, Type> hmQueryIds = new LinkedHashMap<String, Type>();
        HashMap<String, String> hmWhereCondition = new HashMap<String, String>();
        for (String locale : supportedLocales) {
            hmQueryIds.put("processname_" + locale, (Type)StandardBasicTypes.STRING);
            hmQueryIds.put("activityname_" + locale, (Type)StandardBasicTypes.STRING);
        }
        hmQueryIds.put("processstarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("activityid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("activitystarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("processid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("resourceid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("processdefid", (Type)StandardBasicTypes.STRING);
        StringBuilder sbQuery = new StringBuilder(sQuery);
        boolean isWhereAdd = false;
        if (!Tools.isNullOrEmpty((String)sProcessDefId) && sProcessDefId.compareTo("*") != 0) {
            isWhereAdd = true;
            sbQuery.append("WHERE ");
            sbQuery.append("processdefinitions.processdefinitionid=(:processDefId) ");
            hmWhereCondition.put("processDefId", sProcessDefId);
        }
        if (!Tools.isNullOrEmpty((String)sTaskDefName)) {
            if (!isWhereAdd) {
                sbQuery.append("WHERE ");
            } else {
                sbQuery.append("AND ");
            }
            if (sTaskDefName.indexOf("*") != -1) {
                sbQuery.append("activities.name LIKE(:activityname)");
                sTaskDefName = sTaskDefName.replace("*", "%");
            } else {
                sbQuery.append("activities.name=(:activityname)");
            }
            hmWhereCondition.put("activityname", sTaskDefName);
        }
        sQuery = sbQuery.toString();
        log.debug((Object)("Query:" + sQuery));
        List<Object[]> result = CustomEmailSender.createHibrenateQuery(sQuery, hmQueryIds, hmWhereCondition);
        Set<String> setQueryIds = hmQueryIds.keySet();
        for (Object[] row : result) {
            int i = 0;
            HashMap<String, String> hmRow = new HashMap<String, String>();
            for (String sQueryIdsKeyIterator : setQueryIds) {
                Object column = row[i];
                ++i;
                if (column instanceof Long) {
                    hmRow.put(sQueryIdsKeyIterator, ((Long)column).toString());
                    continue;
                }
                hmRow.put(sQueryIdsKeyIterator, (String)column);
            }
            alResults.add(hmRow);
        }
        return alResults;
    }

    public static List<Map<String, String>> getDeadlineTasksInformations(String sProcessDefId, String sTaskDefName) throws Exception {
        log.trace((Object)("************ getDeadlineTasksInformations(sProcessDefId=, sTaskDefName=" + sTaskDefName + ") ************"));
        ArrayList<Map<String, String>> alResults = new ArrayList<Map<String, String>>();
        List supportedLocales = I18N.getSupportedLocales().stream().map(Locale::getLanguage).collect(Collectors.toList());
        String dbName = HibernateUtil.getDatabaseVendor().name();
        String sQuery = "";
        if (dbName.equalsIgnoreCase("MicrosoftSQLServer")) {
            sQuery = sQuery + "SELECT Round(((((CONVERT(bigint,getdate()) - CONVERT(bigint,CAST('01-01-1970 00:00:00' as datetime))) * 24 * 60 * 60) - (TIMELIMIT/1000))/3600/24),2) deadlinetime, ";
        } else if (dbName.equalsIgnoreCase("PostgreSQL")) {
            sQuery = sQuery + "SELECT Round(((((current_date - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 60 * 60) - (TIMELIMIT/1000))/3600/24),2) deadlinetime, ";
        } else if (dbName.startsWith("Oracle")) {
            sQuery = sQuery + "SELECT Round(((((SYSDATE - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 60 * 60) - (TIMELIMIT/1000))/3600/24),2) deadlinetime, ";
        } else {
            throw new Exception("Database: " + dbName + " is not handled ");
        }
        for (String locale : supportedLocales) {
            sQuery = sQuery + "(SELECT pt.name FROM pm_process_translation pt WHERE pt.processId = processes.id AND pt.language = '" + locale + "' ) processname_" + locale + ", ";
            sQuery = sQuery + "(SELECT at.name FROM pm_activity_translation at WHERE at.packageid = processdefinitions.packageid and at.processdefid = processdefinitions.processdefinitionid and at.activitydefid = activities.activitydefinitionid and at.language = '" + locale + "' ) activityname_" + locale + ", ";
        }
        sQuery = sQuery + "processes.started processstarttime, assignmentstable.activityid activityid,assignmentstable.activityprocessid processid, activities.activated activitystarttime, assignmentstable.resourceid resourceid, processdefinitions.processdefinitionid processdefid  FROM assignmentstable JOIN  activities ON assignmentstable.activityid = activities.id JOIN processes ON assignmentstable.activityprocessid = processes.id JOIN processdefinitions ON assignmentstable.activityprocessdefname = processdefinitions.name JOIN deadlines ON assignmentstable.activity = deadlines.activity ";
        if (dbName.equalsIgnoreCase("MicrosoftSQLServer")) {
            sQuery = sQuery + "WHERE (DATEDIFF(SECOND, '01-01-1970 00:00:00',SYSUTCDATETIME()) - (TIMELIMIT/1000)) > 0";
        } else if (dbName.equalsIgnoreCase("PostgreSQL")) {
            sQuery = sQuery + "WHERE ROUND((extract(epoch from now()))-(TIMELIMIT/1000)) > 0 ";
        } else if (dbName.startsWith("Oracle")) {
            sQuery = sQuery + "WHERE (cast (systimestamp at time zone 'UTC' as date) - date '1970-01-01') * 86400 - (TIMELIMIT/1000) > 0";
        } else {
            throw new Exception("Database: " + dbName + " is not handled ");
        }
        I18N oMessage = new I18N();
        LinkedHashMap<String, Type> hmQueryIds = new LinkedHashMap<String, Type>();
        HashMap<String, String> hmWhereCondition = new HashMap<String, String>();
        for (String locale : supportedLocales) {
            hmQueryIds.put("processname_" + locale, (Type)StandardBasicTypes.STRING);
            hmQueryIds.put("activityname_" + locale, (Type)StandardBasicTypes.STRING);
        }
        hmQueryIds.put("processstarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("activityid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("activitystarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("processid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("resourceid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("processdefid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("deadlinetime", (Type)StandardBasicTypes.DOUBLE);
        StringBuilder sbQuery = new StringBuilder(sQuery);
        boolean isAndAdd = false;
        if (!Tools.isNullOrEmpty((String)sProcessDefId) && sProcessDefId.compareTo("*") != 0) {
            isAndAdd = true;
            sbQuery.append("AND ");
            sbQuery.append("processdefinitions.processdefinitionid=(:processDefId) ");
            hmWhereCondition.put("processDefId", sProcessDefId);
        }
        if (!Tools.isNullOrEmpty((String)sTaskDefName)) {
            if (!isAndAdd) {
                sbQuery.append("AND ");
            } else {
                sbQuery.append("AND ");
            }
            if (sTaskDefName.indexOf("*") != -1) {
                sbQuery.append("activities.name LIKE(:activityname)");
                sTaskDefName = sTaskDefName.replace("*", "%");
            } else {
                sbQuery.append("activities.name=(:activityname)");
            }
            hmWhereCondition.put("activityname", sTaskDefName);
        }
        sQuery = sbQuery.toString();
        log.debug((Object)("Query:" + sQuery));
        List<Object[]> result = CustomEmailSender.createHibrenateQuery(sQuery, hmQueryIds, hmWhereCondition);
        Set<String> setQueryIds = hmQueryIds.keySet();
        for (Object[] row : result) {
            int i = 0;
            HashMap<String, String> hmRow = new HashMap<String, String>();
            for (String sQueryIdsKeyIterator : setQueryIds) {
                Object column = row[i];
                ++i;
                if (column instanceof Long) {
                    hmRow.put(sQueryIdsKeyIterator, ((Long)column).toString());
                    continue;
                }
                if (column instanceof Double) {
                    hmRow.put(sQueryIdsKeyIterator, ((Double)column).toString());
                    continue;
                }
                hmRow.put(sQueryIdsKeyIterator, (String)column);
            }
            alResults.add(hmRow);
        }
        return alResults;
    }

    private String PrapareEmailToSend(Vector<Map<String, String>> vRecipentNotification, String sGroupSending, String sEmailTemplate, String username) {
        log.trace((Object)("************ PrapareEmailToSend(Vector<Map<String, String>>, sGroupSending=" + sGroupSending + ", sEmailTemplate=" + sEmailTemplate + ") ************"));
        String sNewEmailContent = null;
        boolean bGroupSending = false;
        UserSettingsService uss = ServiceFactory.getUserSettingsService();
        if (!Tools.isNullOrEmpty((String)sGroupSending) && sGroupSending.compareToIgnoreCase("TRUE") == 0) {
            bGroupSending = true;
        }
        try {
            String sEmailContent = CustomEmailSender.getEmailContentFromFile(sEmailTemplate);
            Locale userLocale = Optional.ofNullable(uss.getUserLocale(username)).orElse(LocaleContextHolder.getLocale());
            if (bGroupSending) {
                int iStartPos = sEmailContent.indexOf("@@rows@@");
                int iEndPos = sEmailContent.indexOf("@@end_rows@@");
                String sRow = sEmailContent.substring(iStartPos + 8, iEndPos);
                StringBuilder sbNewRow = new StringBuilder();
                for (Map<String, String> mapTaskParams : vRecipentNotification) {
                    sbNewRow.append(CustomEmailSender.PrepareEmailContent(sRow, mapTaskParams, userLocale));
                }
                String sStartPart = sEmailContent.substring(0, iStartPos);
                String sEndPart = sEmailContent.substring(iEndPos + 12);
                sStartPart = CustomEmailSender.PrepareEmailContent(sStartPart, null, userLocale);
                sEndPart = CustomEmailSender.PrepareEmailContent(sEndPart, null, userLocale);
                sNewEmailContent = sStartPart + sbNewRow.toString() + sEndPart;
            } else {
                for (Map<String, String> mapTaskParams : vRecipentNotification) {
                    sNewEmailContent = CustomEmailSender.PrepareEmailContent(sEmailContent, mapTaskParams, userLocale);
                }
            }
            return sNewEmailContent;
        }
        catch (FileNotFoundException e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BaseException e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String PrepareEmailContent(String sRow, Map<String, String> mapTaskParams, Locale userLocale) throws BaseException {
        log.trace((Object)("************ PrepareEmailContent(sRow=" + sRow + ", Map<String, String>) ************"));
        if (mapTaskParams == null) {
            return sRow;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DBManagement.CONST_ONLYDATEFORMAT);
        SimpleDateFormat sdftime = new SimpleDateFormat(DBManagement.CONST_SHORTTIMEFORMAT);
        Date dateActivity = new Date(Long.valueOf(mapTaskParams.get("activitystarttime")));
        String sActivityDate = sdf.format(dateActivity);
        String sActivityTime = sdftime.format(dateActivity);
        Date dateProcess = new Date(Long.valueOf(mapTaskParams.get("processstarttime")));
        String sProcessDate = sdf.format(dateProcess);
        String sProcessTime = sdftime.format(dateProcess);
        sRow = CustomEmailSender.replace(sRow, "(@processtype@)", mapTaskParams.get("processdefid"));
        sRow = CustomEmailSender.replace(sRow, "(@processname@)", CustomEmailSender.getLocalizedProperty(mapTaskParams, "processname", userLocale));
        sRow = CustomEmailSender.replace(sRow, "(@activitystarttime@)", sActivityTime);
        sRow = CustomEmailSender.replace(sRow, "(@activitystartday@)", sActivityDate);
        sRow = CustomEmailSender.replace(sRow, "(@processstartday@)", sProcessDate);
        sRow = CustomEmailSender.replace(sRow, "(@processstarttime@)", sProcessTime);
        sRow = CustomEmailSender.replace(sRow, "(@activityname@)", CustomEmailSender.getLocalizedProperty(mapTaskParams, "activityname", userLocale));
        sRow = CustomEmailSender.replace(sRow, "(@deadlinetime@)", mapTaskParams.get("deadlinetime"));
        sRow = CustomEmailSender.replace(sRow, "(@deadlineTime@)", mapTaskParams.get("deadlinetime"));
        String sLink = sHttpSystemLink + "/ProcesActivity.do?processKey=" + mapTaskParams.get("processid") + "&activityId=" + mapTaskParams.get("activityid");
        sLink = "<A Href=" + sLink + ">" + MessageHelper.getMessage((String)"Przejdz_do_zadania") + "</A>";
        sRow = sRow.replaceAll("(@link@)", sLink);
        WfProcess wfProcess = SharkFunctions.getWfProcess((String)mapTaskParams.get("processid"));
        Map processContext = SharkFunctions.GetProcessContext((WfProcess)wfProcess);
        for (String sVariableName : processContext.keySet()) {
            Object objValue = processContext.get(sVariableName);
            if (objValue != null) {
                String sValue = objValue.toString();
                sRow = sRow.replaceAll("(@" + sVariableName + "@)", sValue);
                if (!Shark.getInstance().getAdminInterface().getUserGroupAdministration().doesUserExist(sValue)) continue;
                String sRealName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(sValue);
                sRow = sRow.replaceAll("(@realusername_" + sVariableName + "@)", sRealName);
                continue;
            }
            sRow = sRow.replaceAll("(@" + sVariableName + "@)", "");
        }
        return sRow;
    }

    private static String replace(String row, String toReplace, String replacement) {
        return replacement == null ? row : row.replaceAll(toReplace, replacement);
    }

    private static String getLocalizedProperty(Map<String, String> map, String property, Locale locale) {
        return map.get(property + "_" + locale.getLanguage());
    }

    private static String getEmailContentFromFile(String sEmailTemplate) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        log.trace((Object)("************ getEmailContentFromFile(sEmailTemplate=" + sEmailTemplate + ") ************"));
        StringBuilder sbEmailContent = new StringBuilder();
        FileInputStream fis = new FileInputStream(sEmailTemplate);
        BufferedInputStream bis = new BufferedInputStream(fis);
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)bis, "UTF8"));
        String sLine = null;
        while ((sLine = d.readLine()) != null) {
            sbEmailContent.append(sLine).append("\n");
        }
        fis.close();
        return sbEmailContent.toString();
    }

    private void SendEmail(String recepient, String sEmailSubcject, String sEmailContent) {
        log.trace((Object)("************ SendEmail(recepient=" + recepient + ", sEmailSubcject=" + sEmailSubcject + ", sEmailContent) ************"));
        Timer timer2 = new Timer();
        final String finalRecepient = recepient;
        final String emailSubcject = sEmailSubcject;
        final String emailContent = sEmailContent;
        timer2.schedule(new TimerTask(){

            @Override
            public void run() {
                block6: {
                    try {
                        log.debug((Object)"******************************SendEmail********************");
                        try {
                            double dRand = Math.random() * 10000.0;
                            MailClient oMailClient = new MailClient(sUser, sSMTPUser, sUserPassword, sMailServer, sSMTPMailServer, sSMTPPortNo, sSMTPAuth, false, sEmail, sUseSSL, sUseSTARTTLS);
                            log.info((Object)("Wysylanie maila z adresu " + sUser + " do uzytkownika:" + finalRecepient));
                            Thread.sleep((long)dRand);
                            if (finalRecepient != null && finalRecepient.compareToIgnoreCase("") != 0) {
                                oMailClient.sendMessage(finalRecepient, emailSubcject, emailContent, true);
                                log.info((Object)("Wyslanie maila z adresu " + sUser + " do uzytkownika:" + finalRecepient + " powiodlo sie."));
                                break block6;
                            }
                            log.warn((Object)"Empty finalRecepient.");
                        }
                        catch (MessagingException e) {
                            taskLog.debug((Object)e.getMessage());
                            log.error((Object)("Exception in SendEmail :" + e.getMessage()), (Throwable)e);
                        }
                        catch (Exception e) {
                            taskLog.debug((Object)e.getMessage());
                            log.error((Object)("Exception in SendEmail :" + e.getMessage()), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        taskLog.debug((Object)e.getMessage());
                        log.error((Object)("Exception in SendEmail :" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }, 5000L);
    }

    private static List<Object[]> createHibrenateQuery(String sQuery, LinkedHashMap<String, Type> hmQueryIds, HashMap<String, String> hmWhereCondition) throws Exception {
        Session session = HibernateUtil.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            SQLQuery sqlQuery = session.createSQLQuery(sQuery);
            Set<String> setWhereCondition = hmWhereCondition.keySet();
            for (String string : setWhereCondition) {
                String sValue = hmWhereCondition.get(string);
                log.debug((Object)("Condition:" + string + " value: " + sValue));
                sqlQuery.setString(string, sValue);
            }
            Set<String> setQueryIds = hmQueryIds.keySet();
            for (String sQueryIdsKey : setQueryIds) {
                sqlQuery.addScalar(sQueryIdsKey, hmQueryIds.get(sQueryIdsKey));
            }
            List list = sqlQuery.list();
            transaction.commit();
            return list;
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (HibernateException he1) {
                log.error((Object)"", (Throwable)he1);
            }
            throw e;
        }
    }
}

