/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf;

import com.google.common.io.ByteStreams;
import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.ColumnGraphicInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.ColumnGraphicPropetries;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.DynamicTablesResolver;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.InvalidTemplateException;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.NoImage;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.TableInfo;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.config.Environment;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.ServiceFactory;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.PDFTextStripper;
import org.docx4j.Docx4J;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.jaxb.Context;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Document;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.springframework.transaction.TransactionStatus;

public class PrepeareDoc {
    public static Logger log = Logger.getLogger(PrepeareDoc.class);
    public static final String TAB_TO_PROC_STR = "TABLE_TO_PROCESS_MARKER";
    public static final String TAB_NOT_TO_PROC_STR = "TABLE_NOT_TO_PROCESS_MARKER";
    public static final String TAB_WOUT_HDS_STRING = "TABLE_WITHOUT_HEADERS_MARKER";
    public static final String VARIABLE_MARKER = "@";
    private static final SecureRandom random = new SecureRandom();

    private static String fitTextToColumn(String txt, int colWidth, String font, int fontSize, boolean isBold, boolean isItalic) {
        log.trace((Object)("***fitTextToColumn(txt=" + txt + ",colWidth=" + colWidth + ",font=" + font + ",fontSize=" + fontSize + ",isBold=" + isBold + ",isItalic=" + isItalic + ")****"));
        AffineTransform af = new AffineTransform();
        FontRenderContext fr = new FontRenderContext(af, true, true);
        int style = 0;
        if (isBold && isItalic) {
            style = 3;
        } else if (isBold) {
            style = 1;
        } else if (isItalic) {
            style = 2;
        }
        Font f = new Font(font, style, fontSize);
        String newTxt = "";
        log.debug((Object)("Szerokosc kolumny: " + (colWidth -= 100)));
        String[] words = txt.split(" ");
        double scale = 25.0;
        scale -= (double)(colWidth / 1000);
        for (int i = 0; i < words.length; ++i) {
            String w = words[i];
            log.debug((Object)("s\u0142owo: " + w));
            double width = f.getStringBounds(w, fr).getWidth() * scale;
            log.debug((Object)("szeroko\u015b\u0107 s\u0142owa: " + width));
            if (width > (double)colWidth) {
                log.debug((Object)"s\u0142owo si\u0119 nie miesci w kolumnie");
                int lines = (int)Math.ceil(width / (double)colWidth);
                log.debug((Object)("S\u0142owo zostanie rozbite na okolo " + lines + " linii"));
                int len = w.length();
                int offset = 0;
                for (int k = 0; k < lines; ++k) {
                    int endLine;
                    String line = w.substring(offset, Math.min(w.length(), len / lines + offset));
                    double lw = f.getStringBounds(line, fr).getWidth() * scale;
                    while (lw > (double)colWidth) {
                        line = line.substring(0, line.length() - 1);
                        lw = f.getStringBounds(line, fr).getWidth() * scale;
                    }
                    do {
                        if (!((lw = f.getStringBounds(line = w.substring(offset, endLine = Math.min(line.length() + 1 + offset, w.length())), fr).getWidth() * scale) > (double)colWidth)) continue;
                        line = line.substring(0, line.length() - 1);
                        break;
                    } while (endLine != w.length());
                    log.debug((Object)("dodaje linie: " + line));
                    newTxt = newTxt + line + "\n";
                    if (k + 1 != lines || (offset += line.length()) >= w.length() || Tools.isNullOrEmpty((String)line)) continue;
                    --k;
                }
                continue;
            }
            if (Tools.isNullOrEmpty((String)w)) continue;
            log.debug((Object)"s\u0142owo miesci sie w kolumnie");
            newTxt = newTxt + w + " ";
        }
        return newTxt;
    }

    public static File prepeareWordDocument(String templatePath, String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tables, String variablesMarker, String processId, List<Boolean> headersAdditionalFlags, List<Boolean> tablesAdditionalFlags) {
        return PrepeareDoc.prepareDocument(templatePath, outputFilePath, mappings, tables, variablesMarker, processId, headersAdditionalFlags, tablesAdditionalFlags, true);
    }

    public static File prepareDocument(String templatePath, String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tablesMaps, String variablesMarker, String processId, List<Boolean> tablesAdditionalFlags, List<Boolean> headersAdditionalFlags, boolean pdf) {
        block43: {
            log.trace((Object)"************************* prepareDocument() ********************");
            try {
                log.debug((Object)"Pobieranie szablonu dla pliku: ".concat(templatePath));
                WordprocessingMLPackage template = WordprocessingMLPackage.load((File)new File(templatePath));
                log.debug((Object)"Pobieranie MainDocumentPart.");
                MainDocumentPart documentPart = template.getMainDocumentPart();
                log.debug((Object)"Preparing header and footer");
                PrepeareDoc.prepareHeaderFooter(template, mappings, variablesMarker);
                log.debug((Object)"Pobieranie JAXBElement - DocumentElement.");
                Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
                log.debug((Object)"Pobieranie wezlow table z dokumentu.");
                List nodes = documentPart.getJAXBNodesViaXPath("//w:tbl", false);
                if (nodes == null) break block43;
                log.debug((Object)"Inicjowanie flag");
                List<Tbl> tables = PrepeareDoc.getTables(nodes);
                ArrayList<Boolean> tablesFlags = new ArrayList<Boolean>();
                ArrayList<Boolean> headersFlags = new ArrayList<Boolean>();
                ArrayList<ColumnGraphicInfo> tablesGraphicColumnInfo = new ArrayList<ColumnGraphicInfo>();
                for (int i = 0; i < tables.size(); ++i) {
                    tablesFlags.add(null);
                    headersFlags.add(null);
                    log.debug((Object)"Pobranie wierszy z tabeli.");
                    List currentTableRows = tables.get(i).getContent();
                    if (currentTableRows != null && currentTableRows.size() > 0) {
                        log.debug((Object)"Pobieranie wierszy z tabeli powiod\u0142o si\u0119, liczba wierszy = ".concat(String.valueOf(currentTableRows.size())));
                        if (currentTableRows.size() >= 2) {
                            log.debug((Object)"Liczba wierszy >= 2.");
                            for (int j = 0; j < 2; ++j) {
                                Tr row = PrepeareDoc.getRow(currentTableRows, j);
                                if (row != null) {
                                    log.debug((Object)"Pobieranie wiersza powiod\u0142o si\u0119.");
                                    log.debug((Object)"Pobieranie warto\u015bci kom\u00f3rek dla wiersza j = ".concat(String.valueOf(j)));
                                    List cells = row.getContent();
                                    if (cells.size() == 1 && cells.get(0) != null) {
                                        log.debug((Object)"Pierwszy wiersz posiada tylko jedn\u0105 kolumn\u0119, mo\u017ce by\u0107 znacznikiem.");
                                        log.debug((Object)"Pobieranie elementu kom\u00f3rki.");
                                        JAXBElement cellElem = (JAXBElement)cells.get(0);
                                        Tc cell = PrepeareDoc.getCell((JAXBElement<Tc>)cellElem);
                                        if (cell != null) {
                                            log.debug((Object)"Pobieranie listy warto\u015bci kom\u00f3rki powiod\u0142o si\u0119.");
                                            List cellValues = cell.getContent();
                                            if (cellValues != null && cellValues.size() > 0 && cellValues.get(0) != null) {
                                                log.debug((Object)"Pobieranie pierwszej warto\u015bci z listy powiod\u0142o si\u0119.");
                                                String cellValue = String.valueOf(cellValues.get(0));
                                                log.debug((Object)"cellValue = ".concat(cellValue));
                                                if (cellValue.compareTo(TAB_TO_PROC_STR) == 0) {
                                                    log.debug((Object)"cellValue to znacznik przetwarzania tabeli.");
                                                    tablesFlags.remove(tablesFlags.size() - 1);
                                                    tablesFlags.add(true);
                                                }
                                                if (cellValue.compareTo(TAB_NOT_TO_PROC_STR) == 0) {
                                                    log.debug((Object)"cellValue to znacznik wy\u0142\u0105czaj\u0105cy domy\u015blne przetwarzanie tabeli.");
                                                    tablesFlags.remove(tablesFlags.size() - 1);
                                                    tablesFlags.add(false);
                                                }
                                                if (cellValue.compareTo(TAB_WOUT_HDS_STRING) != 0) continue;
                                                log.debug((Object)"cellValue to znacznik usuni\u0119cia nag\u0142\u00f3wka.");
                                                headersFlags.remove(headersFlags.size() - 1);
                                                headersFlags.add(false);
                                                continue;
                                            }
                                            log.debug((Object)"B\u0141\u0104D - problem z pobraniem pierwszej warto\u015bci z listy.");
                                            continue;
                                        }
                                        log.debug((Object)"B\u0141\u0104D - Problem z pobraniem warto\u015bci kom\u00f3rki.");
                                        continue;
                                    }
                                    log.debug((Object)"Pierwszy wiersz posiada wi\u0119cej ni\u017c jedn\u0105 kolumn\u0119, nie jest znacznikiem.");
                                    continue;
                                }
                                log.debug((Object)"Problem z pobraniem obiektu Tr dla wiersza.");
                            }
                        } else {
                            log.debug((Object)"Tabela posiada tylko jeden wiersz.");
                        }
                    } else {
                        log.debug((Object)"B\u0141\u0104D - Problem z pobieraniem wierszy tabeli.");
                    }
                    log.debug((Object)"Usuwanie wierszy znacznikowych.");
                    if (tablesFlags.get(i) != null) {
                        log.debug((Object)"Wiersz znacznikowy przetwarzania tabeli - usuni\u0119ty.");
                        currentTableRows.remove(0);
                    }
                    if (headersFlags.get(i) != null && !((Boolean)headersFlags.get(i)).booleanValue()) {
                        log.debug((Object)"Wiersz znacznikowy usuni\u0119cia nag\u0142\u00f3wka tabeli - usuni\u0119ty.");
                        currentTableRows.remove(0);
                    }
                    log.debug((Object)"Usuwanie wierszy znacznikowych powiod\u0142o si\u0119.");
                }
                log.debug((Object)"Inicjowanie dodatkowych flag");
                if (tablesAdditionalFlags == null && headersAdditionalFlags == null) {
                    tablesAdditionalFlags = new ArrayList<Boolean>();
                    headersAdditionalFlags = new ArrayList<Boolean>();
                    DynamicTablesResolver resolver = new DynamicTablesResolver();
                    List<TableInfo> tablesInfo = resolver.getTables(documentPart);
                    for (TableInfo tableInfo : tablesInfo) {
                        tablesAdditionalFlags.add(tableInfo.isDynamic());
                        headersAdditionalFlags.add(!tableInfo.isHeaderless());
                        tablesGraphicColumnInfo.add(tableInfo.getColumnGraphicInfo());
                    }
                }
                log.debug((Object)"Ustawianie flag wszystkich tabel.");
                boolean bTablesToProcessMarkers = true;
                if (tablesAdditionalFlags == null) {
                    log.debug((Object)"whichTables = null.");
                    if (tablesFlags.contains(true) || tablesFlags.contains(false)) {
                        bTablesToProcessMarkers = false;
                    }
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (tablesFlags.get(i) != null) continue;
                        tablesFlags.remove(i);
                        tablesFlags.add(i, bTablesToProcessMarkers);
                    }
                } else {
                    log.debug((Object)"whichTables != null.");
                    log.debug((Object)"Przepisanie warto\u015bci z whichTables do whichTablesTmp.");
                    tablesFlags.clear();
                    tablesFlags.addAll(tablesAdditionalFlags);
                    log.debug((Object)"Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                if (headersAdditionalFlags == null) {
                    log.debug((Object)"whichHeaders = null.");
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (headersFlags.get(i) != null) continue;
                        headersFlags.remove(i);
                        headersFlags.add(i, true);
                    }
                } else {
                    log.debug((Object)"whichHeaders != null.");
                    log.debug((Object)"Przepisanie warto\u015bci z whichHeaders do whichHeadersTmp.");
                    headersFlags.clear();
                    headersFlags.addAll(headersAdditionalFlags);
                    log.debug((Object)"Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                log.debug((Object)"tablesFlags: ");
                log.debug(tablesFlags);
                log.debug((Object)"headersFlags: ");
                log.debug(headersFlags);
                if (tablesFlags.size() == nodes.size() && headersFlags.size() == nodes.size()) {
                    log.debug((Object)"Przygotowanie wartosci do uzpelnienia tabel.");
                    for (int i = 0; i < tables.size(); ++i) {
                        if (((Boolean)tablesFlags.get(i)).booleanValue()) {
                            log.debug((Object)"Ustawianie formatowania wierszy w tabeli.");
                            ArrayList<Map<String, Object>> paragraphsProperties = new ArrayList<Map<String, Object>>();
                            TrPr rowProperties = null;
                            log.debug((Object)"Pobieranie wierszy z tabeli i = ".concat(String.valueOf(i)));
                            List currentTableRows = tables.get(i).getContent();
                            if (currentTableRows != null && currentTableRows.size() > 0) {
                                int whichRow = 0;
                                int defaultRowNo = 1;
                                if (currentTableRows.size() > 1) {
                                    log.debug((Object)"Formatowanie wierszy jest pobierane z drugiego wiersza tabeli (nie z nag\u0142\u00f3wka).");
                                    whichRow = 1;
                                    log.debug((Object)"Pobieranie paragraf\u00f3w tekstowych(kolumn) z wiersza definiujacego formatowanie.");
                                    List paragraphs = documentPart.getJAXBNodesViaXPath("./w:tc/w:p", currentTableRows.get(whichRow), false);
                                    if (paragraphs != null && paragraphs.size() > 0) {
                                        log.debug((Object)"Pobieranie paragraf\u00f3w tekstowych (kolumn) powiodlo sie. Liczba kolumn: ".concat(String.valueOf(paragraphs.size())));
                                        log.debug((Object)"Pobieranie formatowania poszczegolnych kolumn.");
                                        for (int j = 0; j < paragraphs.size(); ++j) {
                                            HashMap<String, PPr> paragraphProperties = new HashMap<String, PPr>();
                                            P pParagraph = (P)paragraphs.get(j);
                                            PPr paragraph_pPr = pParagraph.getPPr();
                                            paragraphProperties.put("pPr", paragraph_pPr);
                                            paragraphsProperties.add(paragraphProperties);
                                        }
                                        log.debug((Object)"Pobieranie formatowania dla poszczegolnych kolumn powiodlo sie.");
                                        log.debug(paragraphsProperties);
                                    }
                                    log.debug((Object)"Pobieranie w\u0142a\u015bciwo\u015bci wiersza z wiersza definiujacego formatowanie.");
                                    rowProperties = ((Tr)currentTableRows.get(whichRow)).getTrPr();
                                }
                                log.debug((Object)"Pobieranie wartosci do uzpelnienia tabeli.");
                                if (!Tools.isNullOrEmpty((String)processId)) {
                                    log.debug((Object)"processId rozne od null i nie jest puste.");
                                    log.debug((Object)"Pobieranie wezlow z wartosciami komorek z tabeli, dla wiersza: ".concat(String.valueOf(i)));
                                    String tableHeaders = "";
                                    Tr row = (Tr)currentTableRows.get(0);
                                    List cellElements = row.getContent();
                                    int columnsCount = 0;
                                    log.debug((Object)"Pobieranie naglowkow.");
                                    for (int j = 0; j < cellElements.size(); ++j) {
                                        Tc cell = null;
                                        try {
                                            JAXBElement cellElement = (JAXBElement)cellElements.get(j);
                                            cell = (Tc)cellElement.getValue();
                                            ++columnsCount;
                                        }
                                        catch (ClassCastException cellElement) {
                                            // empty catch block
                                        }
                                        if (cell == null) continue;
                                        tableHeaders = tableHeaders.concat(String.valueOf(cell.getEGBlockLevelElts().get(0)));
                                    }
                                    log.debug((Object)"Pobieranie naglowkow powiodlo sie.");
                                    log.debug((Object)tableHeaders);
                                    log.debug((Object)"headersFlags dla i = ".concat(String.valueOf(i).concat(" = ").concat(String.valueOf(headersFlags.get(i)))));
                                    if (!((Boolean)headersFlags.get(i)).booleanValue()) {
                                        log.debug((Object)"W tabeli o indeksie ".concat(String.valueOf(i)).concat(" nag\u0142\u00f3wek ma zosta\u0107 usuni\u0119ty."));
                                        defaultRowNo = 0;
                                    }
                                    log.debug((Object)"Usuwanie wiersza z nag\u0142\u00f3wkiem.");
                                    while (currentTableRows.size() > defaultRowNo) {
                                        currentTableRows.remove(currentTableRows.size() - 1);
                                    }
                                    log.debug((Object)"Usuwanie wierszy powiodlo sie.");
                                    String processDefId = PrepeareDoc.getProcessDefId(processId);
                                    tableHeaders = tableHeaders.substring(1, tableHeaders.length() - 1);
                                    log.debug((Object)"Usuniecie nadmiarowych znacznikow zmiennych.");
                                    log.debug((Object)tableHeaders);
                                    tableHeaders = tableHeaders.replace(variablesMarker.concat(variablesMarker), variablesMarker);
                                    log.debug((Object)"Usuniecie nadmiarowych znacznikow zmiennych powiodlo sie.");
                                    log.debug((Object)tableHeaders);
                                    log.debug((Object)"Splitowanie zmiennych.");
                                    String[] splittedTableHeaders = tableHeaders.split(variablesMarker);
                                    log.debug((Object)"Splitowanie zmiennych powiodlo sie.");
                                    log.debug((Object)splittedTableHeaders.toString());
                                    ArrayList<String> tableValues = new ArrayList<String>();
                                    log.debug((Object)"Ustawianie naglowkow.");
                                    try {
                                        ProcessData processData = new ProcessData();
                                        for (int j = 0; j < splittedTableHeaders.length; ++j) {
                                            if (j >= columnsCount) continue;
                                            if (splittedTableHeaders[j].contains("|")) {
                                                String[] tmp = splittedTableHeaders[j].split("\\|");
                                                Object o = mappings.get(tmp[0]);
                                                if (o == null) continue;
                                                tableValues.add(mappings.get(tmp[0]).toString());
                                                mappings.put(splittedTableHeaders[j], tmp[1]);
                                                continue;
                                            }
                                            if (mappings.get(splittedTableHeaders[j]) == null) continue;
                                            tableValues.add(mappings.get(splittedTableHeaders[j]).toString());
                                            mappings.put(splittedTableHeaders[j], ProcessData.getProcessVariableIdNameMap((String)processDefId).get(splittedTableHeaders[j]).toString());
                                        }
                                    }
                                    catch (Exception e) {
                                        log.debug((Object)"B\u0141\u0104D - problem z ustawianiem nag\u0142\u00f3wk\u00f3w.");
                                        log.error((Object)e.getMessage(), (Throwable)e);
                                        throw e;
                                    }
                                    log.debug((Object)"Ustawianie naglowkow powiodlo sie.");
                                    log.debug(mappings);
                                    log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami.");
                                    PrepeareDoc.createTableWithValues(documentPart, tables.get(i), tableValues, paragraphsProperties, rowProperties, (ColumnGraphicInfo)tablesGraphicColumnInfo.get(i), template);
                                    log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                                    continue;
                                }
                                log.debug((Object)"processId = null");
                                log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami.");
                                PrepeareDoc.createTableWithValues(documentPart, i, tables.get(i), tablesMaps.get(i), paragraphsProperties);
                                log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                                continue;
                            }
                            log.error((Object)"B\u0141\u0104D - tabela nr".concat(String.valueOf(i + 1)).concat(" w szablonie ").concat(templatePath).concat(" nie zawiera wierszy."));
                            continue;
                        }
                        log.debug((Object)"Tabela o indeksie: ".concat(String.valueOf(i)).concat(" nie ma byc uzupelniana"));
                    }
                    log.debug((Object)"MarshalToString.");
                    String xml = XmlUtils.marshaltoString((Object)wmlDocumentEl, (boolean)true);
                    log.debug((Object)"MarshalToString powiodlo sie.");
                    log.debug((Object)"Uzupe\u0142nianie zmiennych w szablonie.");
                    String tmp = PrepeareDoc.replaceVariablesInTemplate(xml, mappings, variablesMarker);
                    log.debug((Object)"Uzupelnianie zmiennych w szablonie powiodlo sie.");
                    log.debug((Object)"UnmarshalString");
                    Object obj = XmlUtils.unmarshalString((String)tmp);
                    log.debug((Object)"UnmarshalString powiodlo sie.");
                    log.debug((Object)"Ustawianie elementu JAXB na uzupelniony wartosciami.");
                    documentPart.setJaxbElement((Object)((Document)obj));
                    log.debug((Object)"Ustawianie elementu JAXB powiodlo sie.");
                    return PrepeareDoc.saveFile(template, templatePath, pdf, outputFilePath);
                }
                log.error((Object)"B\u0141\u0104D - liczba tabel do uzupelnienia na liscie tablesFlags lub headersFlags jest r\u00f3\u017cna od liczby tabel w dokumencie");
            }
            catch (InvalidTemplateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.debug((Object)"B\u0141\u0104D - przy pobieraniu w\u0119z\u0142\u00f3w z tabelami (z pliku XML - XPath)");
            }
        }
        return null;
    }

    private static String getProcessDefId(final String processId) throws Exception {
        return (String)new SharkTransactionTemplate().execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

            public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                return Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(transaction, processId);
            }
        });
    }

    private static File saveFile(WordprocessingMLPackage template, String templatePath, boolean pdf, String outputFilePath) throws Docx4JException {
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)template);
        if (!pdf) {
            log.debug((Object)"Zapis to pliku docx.");
            saver.save(outputFilePath);
            return new File(outputFilePath);
        }
        log.debug((Object)"Zapis to pliku tymczasowego docx.");
        String tempDocxFilePath = templatePath.replace(".docx", "_" + String.valueOf(System.currentTimeMillis()) + Math.abs(random.nextInt()) + ".docx");
        saver.save(tempDocxFilePath);
        log.debug((Object)("Zapis do pliku tymczasowego docx powiodl sie: " + tempDocxFilePath));
        File tempdocXFile = new File(tempDocxFilePath);
        log.debug((Object)tempdocXFile.getAbsolutePath());
        if (tempdocXFile.exists()) {
            log.debug((Object)"Wygenerowanie pliku .pdf");
            File tmpFile = PrepeareDoc.doc2PdfWithoutOO(tempDocxFilePath, outputFilePath);
            log.debug((Object)"Wygenerowanie pliku .pdf powiodlo sie: ".concat(outputFilePath));
            log.debug((Object)"Usuniecie uzupelnionego szablonu docx: ".concat(tempDocxFilePath));
            if (!tempdocXFile.delete()) {
                log.error((Object)" - problem z usuni\u0119ciem pliku tymczasowego.");
            }
            return tmpFile;
        }
        log.error((Object)"B\u0141\u0104D - nowy dokument si\u0119 nie utworzy\u0142, nie ma uzupelnionego szablonu .docx: ".concat(tempDocxFilePath));
        return null;
    }

    private static Tc getCell(JAXBElement<Tc> cellElem) {
        Tc cell = null;
        if (cellElem != null) {
            log.debug((Object)"Pobieranie elementu kom\u00f3rki powiod\u0142o si\u0119.");
            log.debug((Object)"Pobieranie listy warto\u015bci kom\u00f3rki.");
            cell = (Tc)cellElem.getValue();
        } else {
            log.debug((Object)"B\u0141\u0104D - Problem z pobraniem elementu kom\u00f3rki.");
        }
        return cell;
    }

    private static Tr getRow(List<Object> currentTableRows, int j) {
        Tr row = null;
        try {
            log.debug((Object)"Pobieranie obiektu Tr dla wiersza j = ".concat(String.valueOf(j)));
            row = (Tr)currentTableRows.get(j);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return row;
    }

    private static List<Tbl> getTables(List<Object> nodes) {
        ArrayList<Tbl> tbls = new ArrayList<Tbl>();
        for (int i = 0; i < nodes.size(); ++i) {
            log.debug((Object)"Pobieranie w\u0119z\u0142a dla i = ".concat(String.valueOf(i)));
            JAXBElement jaxbeTmp = (JAXBElement)nodes.get(i);
            JAXBElement elem = null;
            if (jaxbeTmp != null && jaxbeTmp.getDeclaredType().toString().equalsIgnoreCase("class org.docx4j.wml.Tbl")) {
                log.debug((Object)"Wezel jest tabela.");
                elem = (JAXBElement)nodes.get(i);
            }
            log.debug((Object)"Pobieranie wartosci wezla tabeli.");
            Tbl tbl = (Tbl)elem.getValue();
            tbls.add(tbl);
            log.debug((Object)"Pobieranie wezla tabeli powiodlo sie.");
        }
        return tbls;
    }

    public static void prepareHeaderFooter(WordprocessingMLPackage wordMLPackage, Map<String, Object> mappings, String sVariablesMarker) {
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                HeaderPart hp = (HeaderPart)rp.getPart(r);
                PrepeareDoc.replaceVariablesAndSave(hp, mappings, sVariablesMarker);
                log.debug((Object)"Header replaced correctly");
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            FooterPart fp = (FooterPart)rp.getPart(r);
            PrepeareDoc.replaceVariablesAndSave(fp, mappings, sVariablesMarker);
            log.debug((Object)"Footer replaced correctly");
        }
    }

    private static <E> void replaceVariablesAndSave(JaxbXmlPart<E> part, Map<String, Object> mappings, String sVariablesMarker) {
        if (part == null) {
            return;
        }
        String xmlContent = XmlUtils.marshaltoString((Object)part.getJaxbElement(), (boolean)true);
        String hfPart = PrepeareDoc.replaceVariablesInTemplate(xmlContent, mappings, sVariablesMarker);
        try {
            Object partElement = XmlUtils.unmarshalString((String)hfPart);
            part.setJaxbElement(partElement);
        }
        catch (JAXBException e) {
            log.error((Object)"Setting header/footer failed.", (Throwable)e);
        }
    }

    public static void createTableWithValues(MainDocumentPart mdp, int iTableNr, Tbl table, Map<String, String> mValues, List<Map<String, Object>> lParagraphProperties) {
        int i;
        log.trace((Object)"************************* createTableWithValues() ********************");
        log.debug((Object)"Tworzenie tabeli nr: ".concat(String.valueOf(iTableNr)));
        int iSize = mValues.size();
        log.debug((Object)"mValues.size() = ".concat(String.valueOf(iSize)));
        int iRowsNr = 0;
        ArrayList<String[]> alColumns = new ArrayList<String[]>();
        log.debug((Object)"Przygotowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(mValues.get("t" + String.valueOf(iTableNr + 1) + "c" + String.valueOf(i + 1)).split(";", -1));
        }
        log.debug((Object)"Przygotowanie wartosci tabelarycznych powiodlo sie.");
        log.debug(alColumns);
        iRowsNr = ((String[])alColumns.get(0)).length;
        log.debug((Object)"Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            Tr tr = Context.getWmlObjectFactory().createTr();
            table.getEGContentRowContent().add(tr);
            for (int j = 0; j < iSize; ++j) {
                Tc tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr);
                TblWidth cellWidth = Context.getWmlObjectFactory().createTblWidth();
                tcPr.setTcW(cellWidth);
                cellWidth.setType("dxa");
                cellWidth.setW(BigInteger.valueOf(2L));
                P p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                try {
                    PPr pPr = null;
                    if (lParagraphProperties.size() > j) {
                        pPr = (PPr)lParagraphProperties.get(j).get("pPr");
                    }
                    p.setPPr(pPr);
                    ObjectFactory factory = Context.getWmlObjectFactory();
                    R r = (R)p.getContent().get(0);
                    Text t = (Text)r.getContent().get(0);
                    log.debug((Object)t.getValue());
                    String[] rows = t.getValue().split("\n");
                    int index = 0;
                    p.getContent().remove(r);
                    for (String row : rows) {
                        R run = factory.createR();
                        Text text = factory.createText();
                        text.setValue(row);
                        run.getContent().add(text);
                        p.getContent().add(run);
                        if (pPr != null) {
                            RPr rPr = StyleUtil.apply((ParaRPr)pPr.getRPr(), (RPr)factory.createRPr());
                            run.setRPr(rPr);
                        }
                        if (index < rows.length - 1) {
                            R brRun = factory.createR();
                            brRun.getContent().add(factory.createBr());
                            p.getContent().add(brRun);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                }
                tc.getEGBlockLevelElts().add(p);
            }
        }
        log.debug((Object)"Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template) {
        PrepeareDoc.createTableWithValues(mdp, table, lValues, lParagraphProperties, null, columnGraphicInfo, template);
    }

    /*
     * Unable to fully structure code
     */
    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template) {
        PrepeareDoc.log.trace((Object)"************************* createTableWithValues() ********************");
        for (i = 0; i < lValues.size(); ++i) {
            lValues.set(i, lValues.get(i).replaceAll("@", "Xsuncode-atX"));
        }
        iSize = lValues.size();
        PrepeareDoc.log.debug((Object)"mValues.size() = ".concat(String.valueOf(iSize)));
        iRowsNr = 0;
        alColumns = new ArrayList<String[]>();
        PrepeareDoc.log.debug((Object)"Splitowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(lValues.get(i).split(";", -1));
            tmpLength = ((String[])alColumns.get(i)).length;
            if (tmpLength <= iRowsNr) continue;
            iRowsNr = tmpLength;
        }
        PrepeareDoc.log.debug((Object)"Splitowanie wartosci tabelarycznych powiodlo sie.");
        PrepeareDoc.log.debug(alColumns);
        PrepeareDoc.log.debug((Object)"Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            tr = Context.getWmlObjectFactory().createTr();
            if (rowProperties != null) {
                trPr = (TrPr)XmlUtils.deepCopy((Object)rowProperties, (JAXBContext)mdp.getJAXBContext());
                tr.setTrPr(trPr);
            }
            table.getEGContentRowContent().add(tr);
            for (j = 0; j < iSize; ++j) {
                tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                tcPr = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr);
                cellWidth = Context.getWmlObjectFactory().createTblWidth();
                tcPr.setTcW(cellWidth);
                cellWidth.setType("dxa");
                tgc = (TblGridCol)table.getTblGrid().getGridCol().get(j);
                colWidth = tgc.getW().intValue();
                cellWidth.setW(BigInteger.valueOf(colWidth));
                p = null;
                if (i < ((String[])alColumns.get(j)).length) {
                    txt = ((String[])alColumns.get(j))[i];
                    font = "Times New Roman";
                    isBold = false;
                    isItalic = false;
                    size = 12;
                    ppr = null;
                    if (j < lParagraphProperties.size()) {
                        ppr = (PPr)lParagraphProperties.get(j).get("pPr");
                        try {
                            font = ppr.getRPr().getRFonts().getAscii();
                        }
                        catch (Exception e) {
                            PrepeareDoc.log.debug((Object)"nie mozna wczytac czcionki");
                        }
                        try {
                            isBold = ppr.getRPr().getB().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            isItalic = ppr.getRPr().getI().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            PrepeareDoc.log.debug((Object)ppr.getRPr().getSz().getVal().doubleValue());
                            size = (int)Math.ceil(ppr.getRPr().getSz().getVal().doubleValue() / 2.0);
                        }
                        catch (Exception e) {
                            PrepeareDoc.log.error((Object)e, (Throwable)e);
                        }
                        PrepeareDoc.log.debug((Object)colWidth);
                    }
                    newTxt = PrepeareDoc.fitTextToColumn(txt, colWidth, font, size, isBold, isItalic);
                    try {
                        skip = false;
                        if (!columnGraphicInfo.getGraphicColumn().booleanValue()) {
                            p = mdp.createParagraphOfText(newTxt);
                        } else {
                            gPropertie = columnGraphicInfo.getGraphicProperties(j);
                            if (gPropertie == null) {
                                p = mdp.createParagraphOfText(newTxt);
                            } else {
                                fileID = -1L;
                                try {
                                    fileID = Long.parseLong(txt);
                                    p = PrepeareDoc.addImageToP(template, tgc, gPropertie, fileID);
                                    skip = true;
                                }
                                catch (NumberFormatException nfe) {
                                    PrepeareDoc.log.error((Object)(txt + "\t is not FileID"), (Throwable)nfe);
                                    p = mdp.createParagraphOfText(newTxt);
                                    skip = false;
                                }
                            }
                        }
                        p.setPPr(ppr);
                        if (skip.booleanValue()) ** GOTO lbl127
                        factory = Context.getWmlObjectFactory();
                        r = (R)p.getContent().get(0);
                        t = (Text)r.getContent().get(0);
                        PrepeareDoc.log.debug((Object)t.getValue());
                        rows = t.getValue().split("\n");
                        index = 0;
                        p.getContent().remove(r);
                        for (String row : rows) {
                            run = factory.createR();
                            text = factory.createText();
                            text.setValue(row);
                            run.getContent().add(text);
                            p.getContent().add(run);
                            if (ppr != null) {
                                rPr = StyleUtil.apply((ParaRPr)ppr.getRPr(), (RPr)factory.createRPr());
                                run.setRPr(rPr);
                            }
                            if (index < rows.length - 1) {
                                brRun = factory.createR();
                                brRun.getContent().add(factory.createBr());
                                p.getContent().add(brRun);
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        PrepeareDoc.log.error((Object)e.getMessage(), (Throwable)e);
                        p = mdp.createParagraphOfText(newTxt);
                    }
                } else {
                    p = mdp.createParagraphOfText("");
                }
lbl127:
                // 4 sources

                if (p != null) {
                    if (j < lParagraphProperties.size()) {
                        p.setPPr((PPr)lParagraphProperties.get(j).get("pPr"));
                    }
                    tc.getContent().add(p);
                    continue;
                }
                PrepeareDoc.log.debug((Object)"B\u0141\u0104D - problem z utworzeniem komorki tekstowej.");
            }
        }
        PrepeareDoc.log.debug((Object)"Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    private static P addImageToP(WordprocessingMLPackage template, TblGridCol tgc, ColumnGraphicPropetries gPropertie, Long fileID) throws IOException, Exception {
        P p;
        Integer widthImage = gPropertie.getWidth();
        Integer heigthImage = gPropertie.getHeight();
        if (widthImage < 0 || heigthImage < 0) {
            widthImage = tgc.getW().intValue() - 100;
            p = PrepeareDoc.addDocPrev(fileID, widthImage, null, template);
        } else {
            p = PrepeareDoc.addDocPrev(fileID, widthImage, heigthImage, template);
        }
        return p;
    }

    private static P addDocPrev(Long fileID, Integer width, Integer height, WordprocessingMLPackage template) throws IOException, Exception {
        FileService fileService = ServiceFactory.getFileService();
        WfFile wfFile = fileService.getFile(fileID, new String[0]);
        String extension = "";
        String fileName = "fileID: " + fileID;
        String descriptionFile = "No file in archvie with file id\t+" + fileID;
        if (wfFile == null) {
            log.debug((Object)("No file in archive with fileID:\t" + fileID));
        } else {
            descriptionFile = wfFile.getDescription();
            fileName = wfFile.getFileName();
            extension = FilenameUtils.getExtension((String)wfFile.getFileName());
        }
        BinaryPartAbstractImage imagePart = null;
        try {
            File image = new File(wfFile.getFullPath());
            if (extension.equalsIgnoreCase("PDF")) {
                image = PrepeareDoc.convertPDF2Image(image);
            }
            byte[] fileContent = Files.readAllBytes(image.toPath());
            imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)template, (byte[])fileContent);
            if (extension.equalsIgnoreCase("PDF")) {
                image.delete();
            }
        }
        catch (Exception e) {
            log.debug((Object)("No image preview form :\t" + fileName), (Throwable)e);
            InputStream imageStream = NoImage.getInputStream(extension);
            byte[] fileContent = ByteStreams.toByteArray((InputStream)imageStream);
            imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)template, (byte[])fileContent);
        }
        Inline inline = null;
        if (height == null || height < 0) {
            inline = imagePart.createImageInline(fileName, descriptionFile, 1, 2, width == null || width < 0 ? 20L : (long)width.intValue(), false);
        } else {
            long w = UnitsOfMeasurement.twipToEMU((double)width.intValue());
            long h = UnitsOfMeasurement.twipToEMU((double)height.intValue());
            inline = imagePart.createImageInline(fileName, descriptionFile, 1, 2, w, h, false);
        }
        ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R r = factory.createR();
        p.getContent().add(r);
        Drawing drawing = factory.createDrawing();
        r.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return p;
    }

    private static File convertPDF2Image(File pdf) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(pdf, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        PDFFile pdffile = new PDFFile((ByteBuffer)buf);
        PDFPage page = pdffile.getPage(0);
        int width = (int)page.getBBox().getWidth();
        int height = (int)page.getBBox().getHeight();
        Rectangle rect = new Rectangle(0, 0, width, height);
        int rotation = page.getRotation();
        Rectangle rect1 = rect;
        if (rotation == 90 || rotation == 270) {
            rect1 = new Rectangle(0, 0, rect.height, rect.width);
        }
        BufferedImage img = (BufferedImage)page.getImage(rect.width, rect.height, (Rectangle2D)rect1, null, true, true);
        String tmpDir = Environment.get((String)"java.io.tmpdir");
        File imagePdfFile = new File(tmpDir + "\\" + pdf.getName() + "_" + new Date().getTime() + ".png");
        ImageIO.write((RenderedImage)img, "png", imagePdfFile);
        return imagePdfFile;
    }

    public static String replaceVariablesInTemplate(String template, Map<String, Object> mappings, String variablesMarker) {
        log.trace((Object)"************************* replaceVariablesInTemplate() ********************");
        String newTemplate = template;
        log.debug((Object)"Scalanie wez\u0142\u00f3w tekstowych.");
        newTemplate = PrepeareDoc.mergeVariablesTextNodes(newTemplate, variablesMarker, mappings);
        log.debug((Object)"Scalanie w\u0119z\u0142\u00f3w tesktowych powiod\u0142o si\u0119.");
        log.debug(mappings);
        log.debug((Object)"Dodawnie pelnych nazw uzytkownikow");
        mappings = PrepeareDoc.addFullUserNames(newTemplate, variablesMarker, mappings);
        for (String documentVariableKey : mappings.keySet()) {
            Object value = PrepeareDoc.getDocVariableValue(documentVariableKey, mappings);
            String tmp = PrepeareDoc.parseValue(value);
            tmp = PrepeareDoc.stripNonValidXMLCharacters(tmp);
            tmp = tmp.replace("&", "&amp;");
            tmp = tmp.replace("<", "&lt;");
            if ((tmp = tmp.replace(">", "&gt;")).contains("\r\n")) {
                tmp = tmp.replace("\r\n", "</w:t><w:br/><w:t>");
            }
            newTemplate = newTemplate.replace(variablesMarker + documentVariableKey + variablesMarker, tmp);
        }
        log.debug((Object)"Podstawianie zmiennych powiodlo sie.");
        return newTemplate.replaceAll("Xsuncode-atX", VARIABLE_MARKER);
    }

    private static String stripNonValidXMLCharacters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        value.chars().mapToObj(c -> Character.valueOf((char)c)).filter(PrepeareDoc::isValidXmlChar).forEach(out::append);
        return out.toString();
    }

    private static boolean isValidXmlChar(char current) {
        return current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff';
    }

    private static Map<String, Object> addFullUserNames(String newTemplate, String variablesMarker, Map<String, Object> mappings) {
        log.debug((Object)"Podstawianie zmiennych.");
        int i = 0;
        while (newTemplate.indexOf(variablesMarker + "fullusername#", i) >= 0) {
            i = newTemplate.indexOf(variablesMarker + "fullusername#", i) + 13;
            int varEndIndex = newTemplate.indexOf(variablesMarker, i);
            String variableName = newTemplate.substring(i + 1, varEndIndex);
            if (mappings.get("fullusername#" + variableName) != null) continue;
            String userName = (String)mappings.get(variableName);
            UserService us = ServiceFactory.getUserService();
            User user = us.getUser(userName, new String[0]);
            if (user == null) continue;
            String fullName = user.getFullName();
            mappings.put("fullusername#" + variableName, fullName);
        }
        return mappings;
    }

    private static Object getDocVariableValue(String mappingKey, Map<String, Object> mappings) {
        Object value = mappings.get(mappingKey);
        return value == null ? "" : value;
    }

    private static String parseValue(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(value);
        }
        return value.toString();
    }

    public static String mergeVariablesTextNodes(String sTemplate, String sVariablesMarker, Map<String, Object> variables) {
        log.trace((Object)"************************* mergeVariablesTextNodes(String template, String variablesMarker) ********************");
        log.debug((Object)"Wyszukiwanie i scalanie wezlow, kt\u00f3re zosta\u0142y podzielone.");
        StringBuffer mergedString = new StringBuffer(sTemplate);
        int searchingIndex = 0;
        Map<String, Object> foundTextNode = PrepeareDoc.findNextTextNode(mergedString, sVariablesMarker, searchingIndex);
        while (foundTextNode != null) {
            searchingIndex = PrepeareDoc.clearVariableTextNode(mergedString, foundTextNode, variables);
            foundTextNode = PrepeareDoc.findNextTextNode(mergedString, sVariablesMarker, searchingIndex);
        }
        log.debug((Object)"Wyszukiwanie i scalanie wezlow, kt\u00f3re zosta\u0142y podzielone powiodlo sie.");
        return mergedString.toString();
    }

    private static int clearVariableTextNode(StringBuffer mergedString, Map<String, Object> textNode, Map<String, Object> variables) {
        int searchingIndex;
        int endIndex = (Integer)textNode.get("endIndex");
        String clearedTextNode = PrepeareDoc.clearTextNode(textNode.get("content").toString());
        if (PrepeareDoc.hasAnyVariableKeyOrVariableKeyWithLabel(clearedTextNode, variables)) {
            int startIndex = (Integer)textNode.get("startIndex") + 1;
            mergedString.replace(startIndex, endIndex, clearedTextNode);
            searchingIndex = startIndex + clearedTextNode.length() + 1;
        } else {
            searchingIndex = endIndex;
        }
        return searchingIndex;
    }

    private static Map<String, Object> findNextTextNode(StringBuffer mergedString, String sVariablesMarker, int searchingIndex) {
        int startIndex = mergedString.indexOf(sVariablesMarker, searchingIndex);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = mergedString.indexOf(sVariablesMarker, startIndex + 1);
        if (endIndex == -1) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("content", mergedString.substring(startIndex + 1, endIndex));
        result.put("startIndex", startIndex);
        result.put("endIndex", endIndex);
        return result;
    }

    private static boolean hasAnyVariableKeyOrVariableKeyWithLabel(String textNode, Map<String, Object> variables) {
        if (textNode.startsWith("fullusername#")) {
            textNode = textNode.substring(13);
        }
        for (String key : variables.keySet()) {
            if (!textNode.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static String clearTextNode(String stringToClear) {
        StringBuffer tmp = new StringBuffer(stringToClear);
        boolean isClearingNecessary = true;
        while (isClearingNecessary) {
            int startIndex = tmp.indexOf("<");
            int endIndex = tmp.indexOf(">");
            if (startIndex > -1) {
                tmp.delete(startIndex, endIndex + 1);
                continue;
            }
            isClearingNecessary = false;
        }
        return tmp.toString();
    }

    public static File doc2PdfWithoutOO(String sInputFilePathDocx, String sOutputFilePathPdf) {
        log.trace((Object)"************************* doc2PdfWithout(String sInputFilePathDocx, String sOutputFilePathPdf) ********************");
        try {
            log.debug((Object)"\u0141adowanie WMLPackage z pliku: ".concat(sInputFilePathDocx));
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(sInputFilePathDocx));
            if (wordMLPackage != null) {
                log.debug((Object)"\u0141adowanie WMLPackage powiod\u0142o si\u0119.");
                log.debug((Object)"WMLPackage conversion");
                BestMatchingMapper fontMapper = new BestMatchingMapper();
                try {
                    wordMLPackage.setFontMapper((Mapper)fontMapper);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.debug((Object)"B\u0141\u0104D - problem z mapperem!");
                }
                log.debug((Object)"WMLPackage conversion powiod\u0142o si\u0119.");
                log.debug((Object)"Tworzenie pliku .fo");
                File tmp = new File(sInputFilePathDocx + ".fo");
                log.debug((Object)"Tworzenie pliku .fo powiod\u0142o si\u0119.");
                log.debug((Object)"SetSaveFO pliku .fo");
                FOSettings foSettings = Docx4J.createFOSettings();
                foSettings.setFoDumpFile(tmp);
                foSettings.setWmlPackage((OpcPackage)wordMLPackage);
                log.debug((Object)"SetSaveFO powiod\u0142o si\u0119.");
                File outputFilePdf = new File(sOutputFilePathPdf);
                try {
                    log.debug((Object)"Stworzenie FileOutputStream dla pliku: ".concat(sOutputFilePathPdf));
                    FileOutputStream os = new FileOutputStream(outputFilePdf);
                    try {
                        log.debug((Object)"Ustawienie FileOutputStream.");
                        Docx4J.toFO((FOSettings)foSettings, (OutputStream)os, (int)1);
                        log.debug((Object)"Ustawienie FileOutputStream powiod\u0142o si\u0119.");
                    }
                    catch (Throwable e) {
                        log.error((Object)e.getMessage(), e);
                        log.debug((Object)"B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                    }
                    PrepeareDoc.removeBlankPages(sOutputFilePathPdf);
                    log.debug((Object)("Zapisano do " + sOutputFilePathPdf));
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.debug((Object)"B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                }
                if (!tmp.delete()) {
                    log.debug((Object)"B\u0141\u0104D - problem z usuni\u0119ciem pliku .fo");
                }
                return outputFilePdf;
            }
            log.error((Object)"B\u0141\u0104D - przy tworzeniu PdfConversion");
        }
        catch (Docx4JException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)"B\u0141\u0104D - przy tworzeniu wordMLPackage z pliku .docx");
        }
        return null;
    }

    private static void removeBlankPages(String sFilePathPdf) {
        File input = new File(sFilePathPdf);
        try {
            PDDocument doc = PDDocument.load((File)input);
            List list = doc.getDocumentCatalog().getAllPages();
            PDResources pdResources = ((PDPage)list.get(0)).findResources();
            Map pageImages = pdResources.getXObjects();
            for (int i = list.size(); i > 0; --i) {
                String pageText;
                PDFTextStripper reader = new PDFTextStripper();
                reader.setStartPage(i);
                reader.setEndPage(i);
                PDStream contents = ((PDPage)list.get(i - 1)).getContents();
                PDFStreamParser parser = new PDFStreamParser(contents.getStream());
                parser.parse();
                List tokens = parser.getTokens();
                Boolean isImageOnPage = false;
                if (pageImages != null) {
                    for (String key : pageImages.keySet()) {
                        COSName COSNameKey = COSName.getPDFName((String)key);
                        if (!tokens.contains(COSNameKey)) continue;
                        isImageOnPage = true;
                        break;
                    }
                }
                if ((pageText = reader.getText(doc).replaceAll("\\s+", "")).length() != 0 || isImageOnPage.booleanValue()) break;
                doc.removePage((PDPage)list.get(i - 1));
            }
            doc.save(sFilePathPdf);
            log.debug((Object)"Deleting blank pages completed");
        }
        catch (IOException e) {
            log.debug((Object)"ERROR - problem while deleting blank pages from a PDF file");
        }
        catch (COSVisitorException e) {
            log.debug((Object)"ERROR - problem while deleting blank pages from a PDF file");
        }
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters) {
        return PrepeareDoc.createDocAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters, true);
    }

    public static Long createDocAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters, boolean pdf) {
        log.trace((Object)"************************* Long createDocAndSaveInArchive() ********************");
        Calendar c = Calendar.getInstance();
        Long archivePdfFileId = new Long(-1L);
        File f = null;
        try {
            Object variablesMarker;
            String sVariablesMarker = "";
            log.debug((Object)"Pobieranie znacznika zmiennych - variablesMarker");
            if (mOptionalParameters == null) {
                mOptionalParameters = new HashMap<String, Object>();
            }
            sVariablesMarker = StringUtils.isNotBlank((CharSequence)((String)(variablesMarker = mOptionalParameters.get("variablesMarker")))) ? variablesMarker.toString() : VARIABLE_MARKER;
            log.debug((Object)("Znacznik zmiennych variablesMarker zosta\u0142 ustawiony na : " + sVariablesMarker));
            log.debug((Object)"Ustawianie nazwy pliku wyj\u015bciowego");
            String sOutputFilePath = sInputFilePathOldDocx.replace(".docx", "_" + String.valueOf(c.getTimeInMillis()) + Math.abs(random.nextInt()));
            sOutputFilePath = sOutputFilePath + (pdf ? ".pdf" : ".docx");
            String sProcessId = "";
            if (mOptionalParameters.containsKey("processId")) {
                sProcessId = (String)mOptionalParameters.get("processId");
                log.debug((Object)"ProcessId znajduje si\u0119 w mapie mOptionalParameters.");
                log.debug((Object)sProcessId);
            }
            List lWhichTables = null;
            if (mOptionalParameters.containsKey("whichTables")) {
                lWhichTables = (List)mOptionalParameters.get("whichTables");
                log.debug((Object)"lWhichTables znajduje si\u0119 w mapie mOptionalParameters.");
                log.debug((Object)lWhichTables);
            }
            List lWhichHeaders = null;
            if (mOptionalParameters.containsKey("whichHeaders")) {
                lWhichHeaders = (List)mOptionalParameters.get("whichHeaders");
                log.debug((Object)"lWhichHeaders znajduje si\u0119 w mapie mOptionalParameters.");
                log.debug((Object)lWhichHeaders);
            }
            HashMap<String, Object> mMappingsTmp = new HashMap<String, Object>();
            mMappingsTmp.putAll(hmMappings);
            log.debug(mMappingsTmp);
            log.debug((Object)"Generowanie dokumentu z szablonu .docx");
            f = PrepeareDoc.prepareDocument(sInputFilePathOldDocx, sOutputFilePath, mMappingsTmp, lTables, sVariablesMarker, sProcessId, lWhichTables, lWhichHeaders, pdf);
            log.debug((Object)"Generowanie dokumentu z szablonu .docx powiod\u0142o si\u0119.");
            if (f != null && f.length() > 0L) {
                log.debug((Object)"Dokumentu wygenerowa\u0142 si\u0119.");
                String documentNewVersion = "FALSE";
                if (mOptionalParameters.containsKey("documentNewVersion")) {
                    documentNewVersion = mOptionalParameters.get("documentNewVersion").toString();
                    log.debug((Object)"documentNewVersion znajduje si\u0119 w mapie mOptionalParameters.");
                    log.debug((Object)documentNewVersion);
                }
                String documentDescription = sOutputDocClassName;
                if (mOptionalParameters.containsKey("documentDescription")) {
                    documentDescription = mOptionalParameters.get("documentDescription").toString();
                    log.debug((Object)"documentDescription znajduje si\u0119 w mapie mOptionalParameters.");
                    log.debug((Object)documentDescription);
                }
                String[] asIndices = new String[]{};
                if (mOptionalParameters.containsKey("documentIndices")) {
                    asIndices = (String[])mOptionalParameters.get("documentIndices");
                    log.debug((Object)"documentIndices znajduje si\u0119 w mapie mOptionalParameters.");
                    log.debug((Object)asIndices);
                }
                log.debug((Object)"Pod\u0142\u0105czanie dokumentu do archiwum.");
                archivePdfFileId = new Long(ArchiveServices.AddFileToArchive(sOutputDocClassName, asIndices, f, documentDescription, documentNewVersion, "admin"));
                if (archivePdfFileId >= 0L) {
                    log.debug((Object)"Pod\u0142\u0105czenie dokumentu powiod\u0142o si\u0119. Id = ".concat(String.valueOf(archivePdfFileId)));
                } else {
                    log.error((Object)"Problem z pod\u0142\u0105czeniem dokumentu do archiwum (id < 0)");
                }
                if (!f.delete()) {
                    log.error((Object)"B\u0141\u0104D - Problem z usuni\u0119ciem pliku - mo\u017ce jest otwarty");
                }
            } else {
                log.error((Object)"B\u0141\u0104D - Nie utworzy\u0142 si\u0119 plik .pdf");
                if (f != null) {
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly(f);
            archivePdfFileId = new Long(-1L);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return archivePdfFileId;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, final String sProcessId, Map<String, Object> mOptionalParameters) {
        HashMap<String, String> hmMappings = new HashMap<String, String>();
        Long lDocId = new Long(-1L);
        try {
            if (!Tools.isNullOrEmpty((String)sProcessId)) {
                log.debug((Object)"Dodawanie sProcessId do mapy mOptionalParameters. sProcessId = ".concat(sProcessId));
                if (mOptionalParameters == null) {
                    mOptionalParameters = new HashMap<String, Object>();
                }
                mOptionalParameters.put("processId", sProcessId);
                log.debug((Object)"Pobieranie mapy kontekstowej procesu - GetProcessContextMap.");
                Map mContextMap = (Map)new SharkTransactionTemplate().execute((SharkTransactionCallback)new SharkTransactionCallback<Map<String, Object>>(){

                    public Map<String, Object> doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                        return SharkClientFunctions.getProcessContextMap(transaction, sProcessId);
                    }
                });
                if (mContextMap != null && mContextMap.size() > 0) {
                    for (String key : mContextMap.keySet()) {
                        hmMappings.put(key, String.valueOf(mContextMap.get(key)));
                    }
                    lDocId = PrepeareDoc.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, null, mOptionalParameters);
                } else {
                    log.error((Object)"B\u0141AD - problem z pobieraniem mapy konekstowej procesu - mapa jest r\u00f3wna null lub nie zawiera element\u00f3w.");
                }
            } else {
                log.error((Object)"B\u0141\u0104D - sProcessId jest r\u00f3wne null lub puste.");
            }
        }
        catch (Exception e) {
            lDocId = new Long(-1L);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lDocId;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, Map<String, Object> mMappings, String sProcessId, Map<String, Object> mOptionalParameters) {
        HashMap<String, String> hmMappings = new HashMap<String, String>();
        Long lDocId = new Long(-1L);
        try {
            if (!Tools.isNullOrEmpty((String)sProcessId)) {
                log.debug((Object)"Dodawanie sProcessId do mapy mOptionalParameters. sProcessId = ".concat(sProcessId));
                mOptionalParameters.put("processId", sProcessId);
                for (String key : mMappings.keySet()) {
                    hmMappings.put(key, String.valueOf(mMappings.get(key)));
                }
                lDocId = PrepeareDoc.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, null, mOptionalParameters);
            } else {
                log.error((Object)"B\u0141\u0104D - sProcessId jest r\u00f3wne null lub puste.");
            }
        }
        catch (Exception e) {
            lDocId = new Long(-1L);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lDocId;
    }
}

