/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.ComponentFactory;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.QueryExecutor;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.json.JSONObject;

public class VerifyProcessDocuments
extends HttpServlet {
    public static Logger log = Logger.getLogger(VerifyProcessDocuments.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* VerifyProcessDocuments Servlet ****************************");
        PrintWriter printWriter = null;
        JSONObject jsObj = null;
        GsonCustomUtils gsonCustomUtils = null;
        boolean bSuccess = false;
        String answerMessage = "";
        List conditions = null;
        try {
            String processId = request.getParameter("processId");
            String activityId = request.getParameter("activityId");
            String addHere = request.getParameter("addHere");
            boolean bAddHere = false;
            String addInActivity = request.getParameter("addInActivity");
            boolean bAddInActivity = false;
            String toVerify = request.getParameter("toVerify");
            if (StringUtils.isBlank((CharSequence)processId)) {
                throw new CUFException("Brak identyfikatora procesu.");
            }
            if (StringUtils.isBlank((CharSequence)activityId)) {
                throw new CUFException("Brak identyfikatora zadania.");
            }
            if (StringUtils.isBlank((CharSequence)toVerify)) {
                throw new CUFException("Nie okre\u015blono warunk\u00f3w do sprawdzenia.");
            }
            gsonCustomUtils = new GsonCustomUtils();
            conditions = gsonCustomUtils.getMapDataForExtJsonStore(toVerify);
            log.info((Object)"Pobieranie dokumentow podpietych do procesu");
            if (addHere != null && addHere.equalsIgnoreCase("true")) {
                bAddHere = true;
            } else if (addInActivity != null && addInActivity.equalsIgnoreCase("true")) {
                bAddInActivity = true;
            }
            Activity activity = ServiceFactory.getActivityService().getActivity(processId, activityId, new String[0]);
            List<WfDocument> docs = null;
            if (!bAddHere && bAddInActivity) {
                String activityDefId = activity.getActivityDefinitionId();
                log.debug((Object)("Wyszukuje zadania dodane na etapie: " + activityDefId));
                docs = FinderFactory.getDocumentFinder().getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
                docs = this.filterAddedInStage(docs, processId, activityDefId);
                log.debug((Object)("Znaleziono " + docs.size() + " dokument\u00f3w pod\u0142\u0105czonych na etapie: " + activityDefId));
            } else if (bAddHere) {
                log.debug((Object)("Wyszukuje zadania dodane w zadaniu: " + activityId));
                docs = FinderFactory.getDocumentFinder().getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
                docs = this.filterAddedInActivity(docs, processId, activityId);
                log.debug((Object)("Znaleziono " + docs.size() + " dokument\u00f3w pod\u0142\u0105czonych w zadaniu: " + activityId));
            } else {
                log.debug((Object)("Wyszukuje zadania dodane w procesie: " + processId));
                docs = FinderFactory.getDocumentFinder().getDocumentsFromProcess(processId, new String[]{"documentClass"});
                log.debug((Object)("Znaleziono " + docs.size() + " dokument\u00f3w pod\u0142\u0105czonych do procesu: " + processId));
            }
            DocumentClassService dcs = ServiceFactory.getDocumentClassService();
            for (Map condition : conditions) {
                String docClassName = (String)condition.get("docClassName");
                log.debug((Object)("Szukana klasa dokument\u00f3w: " + docClassName));
                DocumentClass docClassTable = dcs.getDocumentClass(docClassName, new String[0]);
                if (docClassTable == null) continue;
                String noOfDocs = (String)condition.get("noOfDocs");
                int iNoOfDocs = Integer.parseInt(noOfDocs);
                if (iNoOfDocs <= 0) {
                    throw new Exception("Ujemna wartosc noOfDocs dla klasy dokumentow " + docClassName);
                }
                String regex = (String)condition.get("regex");
                String conditionType = (String)condition.get("conditionType");
                boolean bRegexDefined = false;
                if (StringUtils.isNotBlank((CharSequence)regex)) {
                    bRegexDefined = true;
                }
                if (StringUtils.isBlank((CharSequence)conditionType)) {
                    conditionType = "=";
                }
                int iFoundDocs = 0;
                for (WfDocument doc : docs) {
                    String thisFileDocClassName = doc.getFile().getDocumentClass().getName();
                    log.debug((Object)("Id znalezionego pliku: " + doc.getFile().getId()));
                    log.debug((Object)("Klasa znalezionego dokumentu: " + thisFileDocClassName));
                    if (thisFileDocClassName.compareTo(docClassName) == 0) {
                        if (bRegexDefined) {
                            WfFile file = doc.getFile();
                            String fileName = file.getFileName();
                            if (StringUtils.isBlank((CharSequence)fileName)) continue;
                            Pattern pattern = Pattern.compile(regex);
                            Matcher matcher = pattern.matcher(fileName);
                            if (matcher.matches()) {
                                ++iFoundDocs;
                                continue;
                            }
                            log.warn((Object)("Dokument o nazwie " + fileName + " podlaczony do klasy dokumentow o nazwie " + docClassName + " nie spelnia wymogow wyrazenia regualrnego " + regex));
                            continue;
                        }
                        ++iFoundDocs;
                        continue;
                    }
                    log.debug((Object)("Dokument o id: " + doc.getFile().getId() + " nie nale\u017cy do klasy: " + docClassName));
                }
                String CUFException2 = "";
                if (iFoundDocs == 0) {
                    CUFException2 = bRegexDefined ? "Nie pod\u0142\u0105czono \u017cadnego dokumentu spe\u0142niaj\u0105cego wymagania do klasy dokument\u00f3w o nazwie " + docClassName + "." : "Nie pod\u0142\u0105czono \u017cadnego dokumentu do klasy dokument\u00f3w o nazwie " + docClassName + ".";
                }
                if (conditionType.compareTo(">") == 0) {
                    if (iFoundDocs >= iNoOfDocs) {
                        CUFException2 = bRegexDefined ? "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie mniej ni\u017c " + iNoOfDocs + " dokument\u00f3w." : "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie mniej ni\u017c " + iNoOfDocs + " dokument\u00f3w.";
                    }
                } else if (conditionType.compareTo(">=") == 0) {
                    if (iFoundDocs > iNoOfDocs) {
                        CUFException2 = bRegexDefined ? "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie co najwy\u017cej " + iNoOfDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania." : "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie co najwy\u017cej " + iNoOfDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania.";
                    }
                } else if (conditionType.compareTo("<") == 0) {
                    if (iFoundDocs <= iNoOfDocs) {
                        CUFException2 = bRegexDefined ? "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie wi\u0119cej ni\u017c " + iNoOfDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania." : "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie wi\u0119cej ni\u017c " + iNoOfDocs + " dokument\u00f3w.";
                    }
                } else if (conditionType.compareTo("<=") == 0) {
                    if (iFoundDocs < iNoOfDocs) {
                        CUFException2 = bRegexDefined ? "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie co najmniej " + iNoOfDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania." : "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie co najmniej " + iNoOfDocs + " dokument\u00f3w.";
                    }
                } else if (conditionType.compareTo("!=") == 0) {
                    if (iFoundDocs == iNoOfDocs) {
                        CUFException2 = bRegexDefined ? "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie liczby r\u00f3\u017cnej od " + iNoOfDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania." : "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie liczby r\u00f3\u017cnej od " + iNoOfDocs + " dokument\u00f3w.";
                    }
                } else if (iFoundDocs != iNoOfDocs) {
                    CUFException2 = bRegexDefined ? "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie dok\u0142adnie " + iNoOfDocs + " dokument\u00f3w spe\u0142niaj\u0105cych wymagania." : "Do klasy dokument\u00f3w o nazwie " + docClassName + " pod\u0142\u0105czono " + iFoundDocs + " dokument\u00f3w. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie dok\u0142adnie " + iNoOfDocs + " dokument\u00f3w.";
                }
                if (CUFException2.compareTo("") == 0) continue;
                if (bAddHere) {
                    CUFException2 = "W tym zadaniu " + CUFException2.substring(0, 1).toLowerCase() + CUFException2.substring(1, CUFException2.length());
                } else if (bAddInActivity) {
                    String currentActivityName = activity.getName();
                    CUFException2 = "Na etapie " + currentActivityName + " " + CUFException2.substring(0, 1).toLowerCase() + CUFException2.substring(1, CUFException2.length());
                }
                throw new CUFException(CUFException2);
            }
            log.info((Object)"Zweryfikowano pozytywnie dokumenty podlaczone do procesu");
            bSuccess = true;
            answerMessage = "ok";
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d podczas weryfikacji dokument\u00f3w pod\u0142\u0105czonych do procesu.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsObj = new JSONObject();
                jsObj.put("success", bSuccess);
                jsObj.put("message", (Object)answerMessage);
                response.setContentType("text/html;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.println(jsObj.toString());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private List<WfDocument> filterAddedInActivity(List<WfDocument> docs, String processId, String activityId) {
        ArrayList<WfDocument> list = new ArrayList<WfDocument>();
        for (WfDocument wfDocument : docs) {
            if (!this.addedInActivity(wfDocument, processId, activityId)) continue;
            list.add(wfDocument);
        }
        return list;
    }

    private List<WfDocument> filterAddedInStage(List<WfDocument> docs, String processId, String activityId) {
        ArrayList<WfDocument> list = new ArrayList<WfDocument>();
        for (WfDocument wfDocument : docs) {
            if (!this.addedInActivityDef(wfDocument, processId, activityId)) continue;
            list.add(wfDocument);
        }
        return list;
    }

    private boolean addedInActivity(WfDocument wfDocument, String processId, String activityId) {
        DetachedCriteria dc = DetachedCriteria.forClass(ActivityDocument.class);
        dc.addOrder(Order.asc((String)"date"));
        dc.add((Criterion)Restrictions.eq((String)"addedHere", (Object)true));
        dc.createAlias("process", "process");
        dc.add((Criterion)Restrictions.eq((String)"process.processId", (Object)processId));
        dc.createAlias("activity", "activity", JoinType.LEFT_OUTER_JOIN);
        dc.add((Criterion)Restrictions.eq((String)"activity.activityId", (Object)activityId));
        dc.createAlias("version", "version", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.file", "version.file", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.newestFile", "version.newestFile", JoinType.LEFT_OUTER_JOIN);
        dc.add((Criterion)Restrictions.eq((String)"version.newestFile.id", (Object)wfDocument.getFile().getId()));
        QueryExecutor qe = ComponentFactory.getQueryExecutor();
        List files = qe.findByCriteria(dc);
        if (files.isEmpty()) {
            log.warn((Object)("Nie znalezono dokumentu dla: aId=" + activityId + " fileId=" + wfDocument.getFile().getId()));
            return false;
        }
        return true;
    }

    private boolean addedInActivityDef(WfDocument wfDocument, String processId, String activityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(ActivityDocument.class);
        dc.addOrder(Order.asc((String)"date"));
        dc.add((Criterion)Restrictions.eq((String)"addedHere", (Object)true));
        dc.createAlias("process", "process");
        dc.add((Criterion)Restrictions.eq((String)"process.processId", (Object)processId));
        dc.createAlias("activity", "activity", JoinType.LEFT_OUTER_JOIN);
        dc.add((Criterion)Restrictions.eq((String)"activity.activityDefinitionId", (Object)activityDefId));
        dc.createAlias("version", "version", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.file", "version.file", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.newestFile", "version.newestFile", JoinType.LEFT_OUTER_JOIN);
        dc.add((Criterion)Restrictions.eq((String)"version.newestFile.id", (Object)wfDocument.getFile().getId()));
        QueryExecutor qe = ComponentFactory.getQueryExecutor();
        List files = qe.findByCriteria(dc);
        if (files.isEmpty()) {
            log.warn((Object)("Nie znalezono dokumentu dla: actDefId=" + activityDefId + " fileId=" + wfDocument.getFile().getId()));
            return false;
        }
        return true;
    }
}

