/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.ExportProcessToPdf;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.ActionTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.extension.ActionTool;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.xpdl.elements.Package;

public class ExportProcessToPdfApplication {
    public static Logger log = Logger.getLogger(ExportProcessToPdfApplication.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(AppParameter s_processid, AppParameter s_activityid) throws ClassNotFoundException {
        log.trace((Object)("************ ExportProcessToPdfApplication.execute(s_processid=" + s_processid.the_value.toString() + ", s_activityid=" + s_activityid.the_value.toString() + ") ************"));
        SharkTransaction st = null;
        DBManagement dbm = new DBManagement();
        try {
            st = Shark.getInstance().createTransaction();
            String processId = (String)s_processid.the_value;
            String activityId = (String)s_activityid.the_value;
            log.debug((Object)("ProcessId: " + processId));
            log.debug((Object)("ActivityId: " + activityId));
            String sClassName = "Archiwum proces\u00f3w ENG";
            String sExpirationDate = "NEVER";
            String sDevice = "Archiwum_testowe";
            String sFolder = "Koszyk";
            String sOtherIndecies = "ALL";
            String sLanguage = "PL";
            String sPDFIds = "FALSE";
            String sPDFVariables = "TRUE";
            String sPDFHistory = "TRUE";
            String sPDFDocuments = "TRUE";
            String sPDFComments = "TRUE";
            String sTaskTemplate = "Akceptacja zam\u00f3wienia";
            String sLogin = "admin";
            String pdfFileId = ExportProcessToPdf.ExportProcess(st, processId, sClassName, sExpirationDate, sDevice, sFolder, sOtherIndecies, sLanguage, sPDFIds, sPDFVariables, sPDFHistory, sPDFDocuments, sPDFComments, sTaskTemplate, "admin");
            log.debug((Object)("PdfFileId: " + pdfFileId));
            DocClassTable docClassTable = dbm.getDocClassByName(sClassName);
            if (docClassTable == null) {
                throw new CUFException("Brak klasy dokumentow o nazwie " + sClassName);
            }
            Long id = docClassTable.getId();
            if (id == null) {
                throw new CUFException("Brak identyfikatora klasy dokumentow " + sClassName);
            }
            String sDocClassId = id.toString();
            if (!pdfFileId.equalsIgnoreCase("-1")) {
                WfActivity wfActivity = SharkFunctions.getWfActivity((SharkTransaction)st, (String)processId, (String)activityId);
                Map<String, Object> processContextMap = SharkClientFunctions.getProcessContextMap(st, processId);
                if (processContextMap == null) {
                    throw new CUFException("Brak mapy kontekstu procesu lub zadania");
                }
                Object obj = processContextMap.get("DocIds");
                if (obj == null) {
                    throw new CUFException("Brak zmiennej DocIds w kontekscie zadania");
                }
                String sDocIds = obj.toString();
                sDocIds = sDocIds.equalsIgnoreCase("") ? pdfFileId : sDocIds + "," + pdfFileId;
                log.debug((Object)("DocIds po dodaniu pliku PDF: " + sDocIds));
                Tools.SetDocumentIdsVariable((SharkTransaction)st, (WfActivity)wfActivity, (String)sDocIds);
                processContextMap.put("DocIds", sDocIds);
                WfProcess wfProcess = SharkFunctions.getWfProcess((SharkTransaction)st, (String)processId);
                Package pack = SharkFunctions.getPackageManager().getPackageByProcessId(processId);
                boolean contextSet = dbm.SaveVariableValuesToDB(st, pack, wfProcess, processContextMap);
                if (contextSet) {
                    log.debug((Object)"Wygenerowany dokument PDF dodany do procesu");
                } else {
                    log.debug((Object)"Nie dodano wygenerowanego dokumentu PDF do procesu");
                }
                ArrayList alDocClasses = dbm.GetAllDocClasses();
                ArrayList alActions = DBManagement.GetAllActions((String)sDocClassId);
                for (int i = 0; i < alActions.size(); ++i) {
                    ActionTable action = (ActionTable)alActions.get(i);
                    if (action.getActionSource().compareToIgnoreCase("attachDocument") != 0 || action.getActionType().compareToIgnoreCase("startScript") != 0) continue;
                    String fullPackageName = action.getActionValue();
                    int iPos = fullPackageName.lastIndexOf(46);
                    String methodName = fullPackageName.substring(iPos + 1);
                    String packageName = fullPackageName.substring(0, iPos);
                    try {
                        Object[] input = new String[]{new String(pdfFileId), new String(sDocClassId)};
                        Class<?> cl = Class.forName(packageName);
                        Class[] par = new Class[]{String.class, String.class};
                        Method mthd = cl.getMethod(methodName, par);
                        Integer output = (Integer)mthd.invoke((Object)new ActionTool(), input);
                        log.debug((Object)("res:" + output));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                log.debug((Object)("Plik nie zostanie dolaczony do dokumentow procesu o identyfikatorze " + processId));
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
    }
}

