/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.mail;

import com.plusmpm.email.MailClient;
import com.suncode.cuf.mail.Addresses;
import com.suncode.cuf.mail.FileAttachment;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SendReport;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class MailSenderImpl
implements MailSender {
    private static final Logger log = Logger.getLogger(MailSenderImpl.class);

    @Override
    public SendReport send(MailConfiguration cfg, MailContent content, List<String> destinationMails) {
        return this.send(cfg, content, new Addresses(destinationMails));
    }

    @Override
    public SendReport send(MailConfiguration cfg, MailContent content, Addresses addresses) {
        String[] source = cfg.getSourceMail().split("@");
        MailClient client = new MailClient(source[0], cfg.getUser(), cfg.getPassword(), source[1], cfg.getHost(), cfg.getSmtpPort(), String.valueOf(cfg.isSmtpAuthEnabled()), false, cfg.getSourceMail(), String.valueOf(cfg.isSslEnabled()), String.valueOf(cfg.isTlsEnabled()));
        SendReport report = new SendReport();
        if (addresses.isSendAsOne()) {
            try {
                this.send(client, addresses.getDirectAddresses().toArray(new String[0]), addresses.getCopyAddresses().toArray(new String[0]), addresses.getHiddenCopyAddresses().toArray(new String[0]), content);
                report.getSuccessfulEmails().addAll(addresses.getDirectAddresses());
            }
            catch (MessagingException e) {
                report.getFailedEmails().addAll(addresses.getDirectAddresses());
                log.warn((Object)e.getMessage());
            }
        } else {
            for (String mail : addresses.getDirectAddresses()) {
                try {
                    this.send(client, new String[]{mail}, addresses.getCopyAddresses().toArray(new String[0]), addresses.getHiddenCopyAddresses().toArray(new String[0]), content);
                    report.getSuccessfulEmails().add(mail);
                }
                catch (MessagingException e) {
                    report.getFailedEmails().add(mail);
                    log.warn((Object)e.getMessage());
                }
            }
        }
        return report;
    }

    private void send(MailClient client, String[] mail, String[] cc, String[] bcc, MailContent content) throws MessagingException {
        if (content.hasAttachment()) {
            List<FileAttachment> attachments = content.getAttachedFiles();
            client.sendMessage(mail, cc, bcc, content.getSubject(), content.getContent(), this.getAttachmentsPaths(attachments), this.getAttachmentsNames(attachments), true);
        } else {
            try {
                client.sendMessage(mail, cc, bcc, content.getSubject(), content.getContent(), true);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String[] getAttachmentsNames(List<FileAttachment> attachments) {
        String[] names = new String[attachments.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = attachments.get(i).getName();
        }
        return names;
    }

    private String[] getAttachmentsPaths(List<FileAttachment> attachments) {
        String[] paths = new String[attachments.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = attachments.get(i).getPath();
        }
        return paths;
    }
}

