/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller.archive;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.cuf.archive.DocumentHelper;
import com.suncode.cuf.web.dto.archive.DocumentUploadForm;
import com.suncode.pwfl.archive.FileSaver;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"cuf/document"})
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    private DocumentHelper helper;
    @Autowired
    private FileService fileService;

    @RequestMapping(value={"description/change"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonMessage changeDescription(@RequestParam Long fileId, @RequestParam String description) {
        log.debug("Changing file description: fileId=[{}] description=[{}]", (Object)fileId, (Object)description);
        this.helper.changeDescription(fileId, description);
        return new JsonMessage();
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonMessage deleteDocuments(@RequestParam List<Long> fileIds) {
        log.debug("Deleting documents: fileIds=[{}]", fileIds);
        for (Long id : fileIds) {
            this.fileService.deleteFile(id);
        }
        return new JsonMessage();
    }

    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, produces={"text/html"})
    @ResponseBody
    public String uploadDocument(DocumentUploadForm uploadForm) throws IOException {
        String userName = SessionUtils.getLoggedUserName();
        ArrayList<WfFile> wfFiles = new ArrayList<WfFile>();
        for (MultipartFile file : uploadForm.getFiles()) {
            InputStream is = file.getInputStream();
            FileSaver fs = this.fileService.getFileSaver();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(uploadForm.getDocumentClassId());
            fd.setFileName(file.getOriginalFilename());
            fd.setDescription(uploadForm.getDescription());
            fd.setUserName(userName);
            fd.setInputStream(is);
            fd.setProcessId(uploadForm.getProcessId());
            fd.setActivityId(uploadForm.getActivityId());
            fd.setIndexes(uploadForm.getIndexes());
            fd.setSaveAsNewVersion(uploadForm.isSaveAsNewVersion());
            WfFile wfFile = fs.addFile(fd);
            wfFile.setVersion(null);
            wfFile.setDocumentClass(null);
            wfFiles.add(wfFile);
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(wfFiles);
    }
}

