/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller;

import com.suncode.cuf.data.DataFinderHelper;
import com.suncode.cuf.search.custom.ParameterizedSimpleDataFinder;
import com.suncode.cuf.search.custom.SimpleDataFinder;
import com.suncode.cuf.search.custom.SimpleQueryDefinition;
import com.suncode.cuf.search.hibernate.HibernateFinder;
import com.suncode.cuf.search.hibernate.HibernateQueryDefinition;
import com.suncode.cuf.web.dto.query.DocumentQueryDto;
import com.suncode.cuf.web.dto.query.ProcessQueryDto;
import com.suncode.cuf.web.dto.query.SimpleQueryDto;
import com.suncode.cuf.web.dto.query.SqlQueryDto;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"cuf/finder"})
public class FinderController {
    @Autowired
    private HibernateFinder hibernateFinder;
    @Autowired
    private DataFinderHelper dataFinderHelper;
    @Autowired
    private SQLFinder sqlFinder;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private ProcessFinder processFinder;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<?> find(@RequestBody HibernateQueryDefinition query) {
        List list = this.hibernateFinder.find(query);
        return list;
    }

    @RequestMapping(value={"/hibernate"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<?> findCounted(@RequestBody HibernateQueryDefinition query) {
        CountedResult list = this.hibernateFinder.findCounted(query);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/simple"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<?> find(@RequestBody SimpleQueryDto dto) {
        SimpleQueryDefinition query = dto.getQuery();
        SimpleDataFinder dc = (SimpleDataFinder)this.dataFinderHelper.find(dto.getClassName());
        if (dc instanceof ParameterizedSimpleDataFinder) {
            ParameterizedSimpleDataFinder dataFinder = (ParameterizedSimpleDataFinder)dc;
            dataFinder.setParameters(dto.getParameters());
            try {
                CountedResult countedResult = dataFinder.find(query.getFilters(), query.getSorters(), query.getStart(), query.getLimit());
                return countedResult;
            }
            finally {
                dataFinder.clearParameters();
            }
        }
        CountedResult list = dc.find(query.getFilters(), query.getSorters(), query.getStart(), query.getLimit());
        return list;
    }

    @RequestMapping(value={"/sql"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<?> find(@RequestBody SqlQueryDto builder) {
        CountedResult list = this.sqlFinder.find(builder.getQuery(), builder.getReturnType(), builder.getStart(), builder.getLimit());
        return list;
    }

    @RequestMapping(value={"/process"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<?> find(@RequestBody ProcessQueryDto dto) {
        CountedResult procs = this.processFinder.findByIndexes(dto.getProcessDefId(), dto.getFilters(), dto.getSorters(), dto.getStart(), dto.getLimit(), dto.getJoins());
        return procs;
    }

    @RequestMapping(value={"/document"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<?> find(@RequestBody DocumentQueryDto dto) {
        CountedResult list = this.documentFinder.findByIndexes(dto.getDocumentClassId(), dto.getFilters(), dto.getSorters(), dto.getStart(), dto.getLimit(), dto.getJoins());
        return list;
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.POST})
    @ResponseBody
    public String find(@RequestParam String test) {
        return test;
    }
}

