/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.mail;

import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;

public class SystemMailConfiguration
extends MailConfiguration {
    private static SystemMailConfiguration instance;

    private SystemMailConfiguration() {
        String email = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_EMAIL);
        String smtpMailServer = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPMAILSERVER);
        String smtpPort = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPPORTNO).toString();
        String smtpUser = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPUSER);
        String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USERPASSWORD);
        Boolean smtpAuth = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPAUTH);
        Boolean useSsl = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESSL);
        Boolean startTls = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESTARTTLS);
        this.setHost(smtpMailServer);
        this.setSmtpPort(smtpPort);
        this.setUser(smtpUser);
        this.setPassword(password);
        this.setSmtpAuthEnabled(smtpAuth);
        this.setSourceMail(email);
        this.setSslEnabled(useSsl);
        this.setTlsEnabled(startTls);
    }

    public static SystemMailConfiguration getInstance() {
        if (instance == null) {
            instance = new SystemMailConfiguration();
        }
        return instance;
    }

    static void setInstance(SystemMailConfiguration instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Instance can't be null");
        }
        SystemMailConfiguration.instance = instance;
    }

    @Override
    public void setSslEnabled(boolean sslEnabled) {
        this.throwEx();
        super.setSslEnabled(sslEnabled);
    }

    @Override
    public void setTlsEnabled(boolean tlsEnabled) {
        this.throwEx();
        super.setTlsEnabled(tlsEnabled);
    }

    @Override
    public void setSourceMail(String sourceMail) {
        this.throwEx();
        super.setSourceMail(sourceMail);
    }

    @Override
    public void setUser(String user) {
        this.throwEx();
        super.setUser(user);
    }

    @Override
    public void setPassword(String password) {
        this.throwEx();
        super.setPassword(password);
    }

    @Override
    public void setHost(String host) {
        this.throwEx();
        super.setHost(host);
    }

    @Override
    public void setSmtpPort(String smtpPort) {
        this.throwEx();
        super.setSmtpPort(smtpPort);
    }

    private void throwEx() {
        if (instance != null) {
            throw new IllegalStateException("System configuration is read-only");
        }
    }

    @Override
    public void setSmtpAuthEnabled(boolean smtpAuthEnabled) {
        this.throwEx();
        super.setSmtpAuthEnabled(smtpAuthEnabled);
    }
}

