/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.CommentsTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class SharkClientFunctions {
    public static Logger log = Logger.getLogger(SharkClientFunctions.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean acceptTaskAndSetVariable(String processId, String activityId, String userId, Map<String, String> contextMap) throws Exception {
        Boolean bl;
        log.trace((Object)("************************* acceptTaskAndSetVariable(processId=" + processId + ", activityId=" + activityId + ", userId=" + userId + ", Map<String, String>) ********************"));
        SharkTransaction sharkTransaction = null;
        String username = null;
        String password = null;
        ExecutionAdministration ea = null;
        WfProcess currentProcess = null;
        WfActivity currentActivity = null;
        WfAssignment currentAssignment = null;
        try {
            username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            sharkTransaction = Shark.getInstance().createTransaction();
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
            currentProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId);
            Map processContextMap = currentProcess.process_context(sharkTransaction);
            if (activityId == null) {
                activityId = (String)processContextMap.get("ActivityId");
            }
            currentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId);
            currentAssignment = SharkFunctions.GetWfAssignment((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId, (String)userId);
            Map activityContextMap = currentActivity.process_context(sharkTransaction);
            if (!currentAssignment.get_accepted_status(sharkTransaction)) {
                currentActivity.change_state(sharkTransaction, "open.running");
            }
            processContextMap.putAll(contextMap);
            activityContextMap.putAll(contextMap);
            currentProcess.set_process_context(sharkTransaction, processContextMap);
            currentActivity.set_process_context(sharkTransaction, activityContextMap);
            SharkFunctions.SetActivityResult((SharkTransaction)sharkTransaction, (WfActivity)currentActivity, (Map)activityContextMap);
            currentActivity.complete(sharkTransaction);
            sharkTransaction.commit();
            bl = true;
        }
        catch (Exception e) {
            try {
                try {
                    Shark.getInstance().emptyCaches(sharkTransaction);
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    sharkTransaction.rollback();
                    throw e;
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (sharkTransaction != null && ea != null) {
                    ea.disconnect(sharkTransaction);
                }
                if (sharkTransaction == null) throw throwable;
                SharkFunctions.ClearSharkTransaction(sharkTransaction);
                throw throwable;
            }
        }
        if (sharkTransaction != null && ea != null) {
            ea.disconnect(sharkTransaction);
        }
        if (sharkTransaction == null) return bl;
        SharkFunctions.ClearSharkTransaction((SharkTransaction)sharkTransaction);
        return bl;
    }

    public static Boolean acceptTaskAndSetVariable(SharkTransaction sharkTransaction, String processId, String activityId, String userId, Map<String, String> contextMap, String taskId) throws Exception {
        log.trace((Object)("************************* acceptTaskAndSetVariable(SharkTransaction, processId=" + processId + ", activityId=" + activityId + ", userId=" + userId + ", Map<String, String>, taskId=" + taskId + ") ********************"));
        String username = null;
        String password = null;
        ExecutionAdministration ea = null;
        WfProcess currentProcess = null;
        WfActivity currentActivity = null;
        WfAssignment currentAssignment = null;
        try {
            username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
            currentProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId);
            Map processContextMap = currentProcess.process_context(sharkTransaction);
            currentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId);
            currentAssignment = SharkFunctions.GetWfAssignment((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId, (String)userId);
            Map activityContextMap = currentActivity.process_context(sharkTransaction);
            if (!currentAssignment.get_accepted_status(sharkTransaction)) {
                currentActivity.change_state(sharkTransaction, "open.running");
            }
            processContextMap.putAll(contextMap);
            currentProcess.set_process_context(sharkTransaction, processContextMap);
            currentActivity.set_process_context(sharkTransaction, activityContextMap);
            SharkFunctions.SetActivityResult((SharkTransaction)sharkTransaction, (WfActivity)currentActivity, (Map)activityContextMap);
            currentActivity.complete(sharkTransaction);
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (sharkTransaction != null && ea != null) {
                ea.disconnect(sharkTransaction);
            }
        }
    }

    public static boolean acceptNotRunningNotStartedTask(String processId, String activityId, Map<String, Object> contextMap) throws CUFException, Exception {
        log.trace((Object)("************************* acceptTaskAndSetVariable(processId=" + processId + ", activityId=" + activityId + ", Map<String, Object>) ********************"));
        boolean bStatus = false;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            bStatus = SharkClientFunctions.acceptNotRunningNotStartedTask(st, processId, activityId, contextMap);
            st.commit();
            boolean bl = bStatus;
            return bl;
        }
        catch (CUFException e) {
            throw e;
        }
        catch (Exception e) {
            if (st != null) {
                Shark.getInstance().emptyCaches(st);
            }
            if (st != null) {
                st.rollback();
            }
            throw e;
        }
        finally {
            if (st != null) {
                SharkFunctions.ClearSharkTransaction((SharkTransaction)st);
            }
        }
    }

    public static boolean acceptNotRunningNotStartedTask(SharkTransaction sharkTransaction, String processId, String activityId, Map<String, Object> contextMap) throws CUFException, Exception {
        log.trace((Object)("************************* acceptTaskAndSetVariable(SharkTransaction, processId=" + processId + ", activityId=" + activityId + ", Map<String, Object>) ********************"));
        String username = null;
        String password = null;
        String resourceUsername = null;
        ExecutionAdministration ea = null;
        WfProcess currentProcess = null;
        WfActivity currentActivity = null;
        WfResource wfResource = null;
        ArrayList<String> assignees = new ArrayList<String>();
        try {
            String actualState;
            username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            resourceUsername = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.BUFOR_USERNAME);
            resourceUsername = Tools.isNullOrEmpty((String)resourceUsername) ? username : resourceUsername.replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
            currentProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId);
            Map processContextMap = currentProcess.process_context(sharkTransaction);
            currentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId);
            wfResource = ea.getResource(sharkTransaction, resourceUsername);
            if (wfResource == null) {
                resourceUsername = username;
                wfResource = ea.getResource(sharkTransaction, username);
                if (wfResource == null) {
                    throw new Exception("Nie mozna zaakceptowac zadania. Brak mozliwosci przypisania zadania przed akceptacja");
                }
            }
            if ((actualState = currentActivity.state(sharkTransaction)).compareTo("open.not_running.not_started") != 0) {
                throw new CUFException("Wybrane zadanie zosta\u0142o ju\u017c podj\u0119te przez innego u\u017cytkownika");
            }
            WfAssignment[] wfAssignments = currentActivity.get_sequence_assignment(sharkTransaction, 0);
            if (wfAssignments == null || wfAssignments.length == 0) {
                throw new CUFException("Nie mo\u017cna cofn\u0105\u0107 zadania.");
            }
            for (WfAssignment wfAssignment : wfAssignments) {
                String assignee = wfAssignment.assignee(sharkTransaction).resource_key(sharkTransaction);
                assignees.add(assignee);
            }
            if (assignees.contains(resourceUsername)) {
                throw new CUFException("Nie mo\u017cna cofn\u0105\u0107 zadania.");
            }
            WfAssignment wfAssignment = wfAssignments[0];
            wfAssignment.set_assignee(sharkTransaction, wfResource);
            currentActivity.change_state(sharkTransaction, "open.running");
            Map activityContextMap = currentActivity.process_context(sharkTransaction);
            processContextMap.putAll(contextMap);
            activityContextMap.putAll(contextMap);
            currentProcess.set_process_context(sharkTransaction, processContextMap);
            currentActivity.set_process_context(sharkTransaction, activityContextMap);
            SharkFunctions.SetActivityResult((SharkTransaction)sharkTransaction, (WfActivity)currentActivity, (Map)activityContextMap);
            currentActivity.complete(sharkTransaction);
            int n = 1;
            return n != 0;
        }
        catch (CUFException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (sharkTransaction != null && ea != null) {
                ea.disconnect(sharkTransaction);
            }
        }
    }

    public static Boolean setVariable(SharkTransaction sharkTransaction, String processId, String activityId, Map<String, String> contextMap, String variableName) throws Exception {
        log.trace((Object)("************************* setVariable(SharkTransaction, processId=" + processId + ", activityId=" + activityId + ", Map<String, String>, variableName=" + variableName + ") ********************"));
        String username = null;
        String password = null;
        ExecutionAdministration ea = null;
        WfProcess currentProcess = null;
        WfActivity currentActivity = null;
        try {
            username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
            currentProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId);
            Map processContextMap = currentProcess.process_context(sharkTransaction);
            currentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId);
            Map activityContextMap = currentActivity.process_context(sharkTransaction);
            String value = contextMap.get(variableName);
            processContextMap.put(variableName, value);
            currentProcess.set_process_context(sharkTransaction, processContextMap);
            currentActivity.set_process_context(sharkTransaction, processContextMap);
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (sharkTransaction != null && ea != null) {
                ea.disconnect(sharkTransaction);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean setVariable(String processId, String activityId, Map<String, String> contextMap, String variableName) throws Exception {
        Boolean bl;
        log.trace((Object)("************************* setVariable(processId=" + processId + ", activityId=" + activityId + ", Map<String, String>, variableName=" + variableName + ") ********************"));
        SharkTransaction sharkTransaction = null;
        String username = null;
        String password = null;
        ExecutionAdministration ea = null;
        WfProcess currentProcess = null;
        WfActivity currentActivity = null;
        try {
            username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            sharkTransaction = Shark.getInstance().createTransaction();
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
            currentProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId);
            Map processContextMap = currentProcess.process_context(sharkTransaction);
            if (activityId == null) {
                activityId = (String)processContextMap.get("ActivityId");
            }
            currentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)processId, (String)activityId);
            Map activityContextMap = currentActivity.process_context(sharkTransaction);
            String value = contextMap.get(variableName);
            processContextMap.put(variableName, value);
            currentProcess.set_process_context(sharkTransaction, processContextMap);
            currentActivity.set_process_context(sharkTransaction, processContextMap);
            sharkTransaction.commit();
            bl = true;
        }
        catch (Exception e) {
            try {
                try {
                    Shark.getInstance().emptyCaches(sharkTransaction);
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    sharkTransaction.rollback();
                    throw e;
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (sharkTransaction != null && ea != null) {
                    ea.disconnect(sharkTransaction);
                }
                if (sharkTransaction == null) throw throwable;
                SharkFunctions.ClearSharkTransaction(sharkTransaction);
                throw throwable;
            }
        }
        if (sharkTransaction != null && ea != null) {
            ea.disconnect(sharkTransaction);
        }
        if (sharkTransaction == null) return bl;
        SharkFunctions.ClearSharkTransaction((SharkTransaction)sharkTransaction);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setProcessContextMap(String sProcessId, Map processCtx) {
        log.trace((Object)("************************* setProcessContextMap(sProcessId=" + sProcessId + ", Map) ********************"));
        boolean status = false;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            status = SharkClientFunctions.setProcessContextMap(st, sProcessId, processCtx);
            st.commit();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return status;
    }

    public static boolean setProcessContextMap(SharkTransaction st, String sProcessId, Map processCtx) throws Exception {
        log.trace((Object)("************************* setProcessContextMap(SharkTransaction, sProcessId=" + sProcessId + ", Map) ********************"));
        boolean status = false;
        ExecutionAdministration ea = null;
        try {
            String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfProcess wfProcess = ea.getProcess(st, sProcessId);
            SharkFunctions.SetProcessContext((SharkTransaction)st, (WfProcess)wfProcess, (Map)processCtx);
            DBManagement dbm = new DBManagement();
            Package pack = SharkFunctions.getPackageManager().getPackageByWfProcess(st, wfProcess);
            dbm.SaveVariableValuesToDB(st, pack, wfProcess, processCtx);
            status = true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (st != null && ea != null) {
                ea.disconnect(st);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getProcessContextMap(String sProcessId) {
        log.trace((Object)("************************* getProcessContextMap(sProcessId=" + sProcessId + ") ********************"));
        SharkTransaction st = null;
        Map<String, Object> mapa = null;
        try {
            st = Shark.getInstance().createTransaction();
            mapa = SharkClientFunctions.getProcessContextMap(st, sProcessId);
            st.commit();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return mapa;
    }

    public static Map<String, Object> getProcessContextMap(SharkTransaction st, String sProcessId) throws Exception {
        log.trace((Object)("************************* getProcessContextMap(SharkTransaction, sProcessId=" + sProcessId + ") ********************"));
        Map mapa = null;
        ExecutionAdministration ea = null;
        try {
            String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfProcess wfProcess = ea.getProcess(st, sProcessId);
            mapa = SharkFunctions.GetProcessContext((SharkTransaction)st, (WfProcess)wfProcess);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (st != null && ea != null) {
                ea.disconnect(st);
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getActivityContextMap(String sProcessId, String sActivityId) {
        log.trace((Object)("************************* getActivityContextMap(sProcessId=" + sProcessId + ", sActivityId=" + sActivityId + ") ********************"));
        Map mapa = null;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            mapa = SharkClientFunctions.getActivityContextMap(st, sProcessId, sActivityId);
            st.commit();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return mapa;
    }

    public static Map getActivityContextMap(SharkTransaction st, String sProcessId, String sActivityId) throws Exception {
        log.trace((Object)("************************* getActivityContextMap(SharkTransaction, sProcessId=" + sProcessId + ", sActivityId=" + sActivityId + ") ********************"));
        Map mapa = null;
        ExecutionAdministration ea = null;
        try {
            String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfActivity wfActivity = ea.getActivity(st, sProcessId, sActivityId);
            mapa = SharkFunctions.GetActivityContext((SharkTransaction)st, (WfActivity)wfActivity);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (st != null && ea != null) {
                ea.disconnect(st);
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setActivityContextMap(String sProcessId, String sActivityId, Map activityCtx) {
        log.trace((Object)("************************* setActivityContextMap(sProcessId=" + sProcessId + ", sActivityId=" + sActivityId + ", Map) ********************"));
        boolean status = false;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            status = SharkClientFunctions.setActivityContextMap(st, sProcessId, sActivityId, activityCtx);
            st.commit();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return status;
    }

    public static boolean setActivityContextMap(SharkTransaction st, String sProcessId, String sActivityId, Map activityCtx) throws Exception {
        log.trace((Object)("************************* setActivityContextMap(SharkTransaction, sProcessId=" + sProcessId + ", sActivityId=" + sActivityId + ", Map) ********************"));
        boolean status = false;
        ExecutionAdministration ea = null;
        try {
            String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfActivity wfActivity = ea.getActivity(st, sProcessId, sActivityId);
            wfActivity.set_process_context(st, activityCtx);
            status = true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (st != null && ea != null) {
                ea.disconnect(st);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WfActivity getPreviousActivity(SharkTransaction sharkTransaction, String sProcessId, String sActivityId) throws Exception {
        ExecutionAdministration ea = null;
        String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
        String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
        ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
        ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
        WfProcess wfProcess = SharkFunctions.getWfProcess((SharkTransaction)sharkTransaction, (String)sProcessId);
        WfActivity wfActivity = SharkFunctions.getWfActivity((SharkTransaction)sharkTransaction, (String)sProcessId, (String)sActivityId);
        long lastStateTime = wfActivity.last_state_time((SharkTransaction)sharkTransaction).time;
        WfActivityIterator iterator = wfProcess.get_activities_in_state(sharkTransaction, "closed.completed");
        WfActivity latestActivity = null;
        try {
            WfActivity temp = null;
            temp = iterator.get_next_object(sharkTransaction);
            long lastCreated = 0L;
            long latestTime = 0L;
            while (temp != null) {
                long created;
                long temptime = temp.last_state_time((SharkTransaction)sharkTransaction).time;
                if (latestTime < temptime && temptime < lastStateTime) {
                    latestTime = temptime;
                    latestActivity = temp;
                    lastCreated = Shark.getInstance().getAdminInterface().getAdminMisc().getActivityCreatedTime(sharkTransaction, sProcessId, sActivityId);
                } else if (latestTime == temptime && temptime < lastStateTime && (created = Shark.getInstance().getAdminInterface().getAdminMisc().getActivityCreatedTime(sharkTransaction, sProcessId, sActivityId)) >= lastCreated) {
                    latestTime = temptime;
                    latestActivity = temp;
                    lastCreated = created;
                }
                try {
                    temp = iterator.get_next_object(sharkTransaction);
                }
                catch (BaseException be) {
                    break;
                }
            }
            if (latestActivity != null) {
                log.debug((Object)"Znaleziono poprzednie zadanie");
            } else {
                log.debug((Object)"Nie ma poprzedniego zadania");
            }
        }
        catch (BaseException be) {
            log.debug((Object)"Nie ma takiego obiektu...");
        }
        finally {
            try {
                if (sharkTransaction != null && ea != null) {
                    ea.disconnect(sharkTransaction);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return latestActivity;
    }

    public static String getVarTypeForVarId(WorkflowProcess wp, String sID) {
        log.trace((Object)("************ getVarTypeForVarId(WorkflowProcess, sID=" + sID + ") ************"));
        String sType = null;
        try {
            DataField dataField;
            if (wp != null && sID != null && (dataField = wp.getDataField(sID)) != null) {
                String subType;
                ExtendedAttribute oneExtAttr;
                ExtendedAttributes extAttrs;
                DataType dataType = dataField.getDataType();
                if (dataType != null) {
                    sType = dataType.getDataTypes().getBasicType().getType();
                }
                if ((extAttrs = dataField.getExtendedAttributes()) != null && (oneExtAttr = extAttrs.getFirstExtendedAttributeForName("SUBTYPE")) != null && (subType = oneExtAttr.getVValue()) != null) {
                    sType = subType;
                }
            }
            if (sType != null) {
                if (sType.contains("DATE") || sType.contains("date")) {
                    sType = "DATE";
                }
                if (sType.contains("AMOUNT") || sType.contains("amount")) {
                    sType = "FLOAT";
                }
                if (!((sType = sType.toLowerCase()).equalsIgnoreCase("string") || sType.equalsIgnoreCase("date") || sType.equalsIgnoreCase("float") || sType.equalsIgnoreCase("integer"))) {
                    sType = "string";
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sType;
    }

    public static Map<String, String> getAllVarTypesForVarIds(WorkflowProcess wp, String sProcDefId) {
        HashMap<String, String> varTypes = new HashMap<String, String>();
        Map mAllProcVar = null;
        try {
            ProcessData processData = new ProcessData();
            mAllProcVar = ProcessData.getProcessVariableIdNameMap((String)sProcDefId);
            for (String q : mAllProcVar.keySet()) {
                String v = SharkClientFunctions.getVarTypeForVarId(wp, q);
                varTypes.put(q, v);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return varTypes;
    }

    public static List<CommentsTable> getCommentsFromActivity(String activityId, String processId) {
        DBManagement dbm = new DBManagement();
        ArrayList alComments = dbm.GetAllCommentsForProcess(processId);
        SimpleDateFormat sdf = new SimpleDateFormat(DBManagement.CONST_DATEFORMAT);
        ArrayList<CommentsTable> ct = new ArrayList<CommentsTable>();
        for (int i = 0; i < alComments.size(); ++i) {
            CommentsTable commentsTable = (CommentsTable)alComments.get(i);
            if (commentsTable.getActivityId().compareToIgnoreCase(activityId) != 0) continue;
            ct.add(commentsTable);
        }
        return ct;
    }
}

