/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.ExcelFormat;
import com.suncode.cuf.io.office.model.ExportSheetDefinition;
import com.suncode.cuf.io.office.model.writer.ValueWriter;
import com.suncode.cuf.io.office.model.writer.ValueWriterResolver;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriter {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriter.class);
    private ExcelFormat format = ExcelFormat.XLSX;
    private Workbook workbook;
    private CreationHelper helper;

    public void write(ExportSheetDefinition sheet, OutputStream os) throws IOException {
        this.write(Arrays.asList(sheet), os);
    }

    public void write(ExportSheetDefinition sheet, String path) {
        this.write(Arrays.asList(sheet), path);
    }

    public void write(List<ExportSheetDefinition> sheets, OutputStream os) throws IOException {
        this.initWriting();
        for (ExportSheetDefinition excelSheet : sheets) {
            this.writeDataToWorkbook(excelSheet);
        }
        this.writeToStream(os);
    }

    public void write(List<ExportSheetDefinition> sheets, String path) {
        this.initWriting();
        for (ExportSheetDefinition excelSheet : sheets) {
            this.writeDataToWorkbook(excelSheet);
        }
        this.writeToFile(path);
    }

    public ExcelFormat getFormat() {
        return this.format;
    }

    public void setFormat(ExcelFormat format) {
        this.format = format;
    }

    private void writeToFile(String path) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(path);
            this.writeToStream(os);
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
        finally {
            if (os != null) {
                IOUtils.closeQuietly((Closeable)os);
            }
        }
    }

    private void initWriting() {
        log.info("Writing data to Excel...");
        this.workbook = this.format.createWorkbook();
        this.helper = this.workbook.getCreationHelper();
    }

    private void writeDataToWorkbook(ExportSheetDefinition excelSheet) {
        log.debug("Sheet name: {}", (Object)excelSheet.getName());
        this.validate(excelSheet);
        log.debug("Writing...");
        Sheet sheet = this.createSheet(excelSheet.getName());
        this.createHeaderRow(sheet, excelSheet);
        this.writeData(excelSheet, sheet);
    }

    private void validate(ExportSheetDefinition excelSheet) {
        log.debug("Validating...");
    }

    private void writeToStream(OutputStream os) throws IOException {
        this.workbook.write(os);
    }

    private void writeData(ExportSheetDefinition excelSheet, Sheet sheet) {
        int rowIdx = 1;
        for (Map<String, Object> row : excelSheet.getData()) {
            Row r = sheet.createRow(rowIdx);
            this.createRow(row, r, excelSheet);
            ++rowIdx;
        }
    }

    private void createRow(Map<String, Object> row, Row r, ExportSheetDefinition excelSheet) {
        String[] keys = excelSheet.getKeysOrder();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Cell cell = r.createCell(i);
            Object value = row.get(key);
            if (value == null) continue;
            ValueWriter writer = this.resolveValueWriter(key, row.get(key), excelSheet.getValueWriters());
            writer.setCellType(cell, this.workbook, this.helper);
            writer.setCellValue(cell, value);
        }
    }

    private ValueWriter resolveValueWriter(String key, Object value, Map<String, ValueWriter> map) {
        ValueWriter writer = map.get(key);
        if (writer == null) {
            writer = ValueWriterResolver.getInstance().resolve(value.getClass());
            map.put(key, writer);
        }
        return writer;
    }

    private void createHeaderRow(Sheet sheet, ExportSheetDefinition excelSheet) {
        Row firstRow = sheet.createRow(0);
        String[] headers = excelSheet.getHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            Cell cell = firstRow.createCell(i);
            cell.setCellValue(header);
        }
    }

    private Sheet createSheet(String name) {
        return this.workbook.createSheet(name);
    }
}

