/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper;

import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.exception.ServiceException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StructureValidator {
    @Autowired
    private UserService us;
    Set<String> usersExisting = new HashSet<String>();

    public void validateStructure(List<Map<String, String>> struct) {
        int i = 1;
        try {
            for (Map<String, String> map : struct) {
                this.checkRole(map);
                this.checkPositions(map);
                this.checkUserId(map);
                this.checkGroups(map);
                ++i;
            }
        }
        catch (ServiceException e) {
            throw new ServiceException("Wiersz: " + i, (Throwable)e);
        }
    }

    private void checkGroups(Map<String, String> map) {
        String userId;
        String groups = map.get("groups");
        if (StringUtils.isBlank((String)groups) && !this.userExist(userId = map.get("userName"))) {
            throw new ServiceException("Nie podano grupy dla u\u017cytkownika: " + userId);
        }
    }

    private boolean userExist(String userId) {
        if (this.usersExisting.contains(userId)) {
            return true;
        }
        User u = this.us.getUser(userId, new String[0]);
        if (u == null) {
            return false;
        }
        this.usersExisting.add(u.getUserName());
        return true;
    }

    private void checkUserId(Map<String, String> map) {
        String userId = map.get("userName");
        if (StringUtils.isEmpty((String)userId)) {
            throw new ServiceException("Nazwa u\u017cytkownika nie mo\u017ce by\u0107 pusta.");
        }
    }

    private void checkPositions(Map<String, String> map) {
        String possym = map.get("positionSymbol");
        if (!StringUtils.isEmpty((String)possym) && possym.contains(";")) {
            throw new ServiceException("Sybmol stanowiska nie mo\u017ce zawiera\u0107 znaku ';'.");
        }
    }

    private void checkRole(Map<String, String> map) {
        String sRoles = this.readString(map.get("roles"));
        if (!StringUtils.isEmpty((String)sRoles)) {
            String[] roles;
            for (String role : roles = sRoles.split(";")) {
                Role r = this.getRole(role);
                if (r != null) continue;
                throw new ServiceException("Rola o id: " + role + " nie istnieje w systemie.");
            }
        }
    }

    private Role getRole(String roleId) {
        return CUFFactory.getRoleHelper().getRole(roleId);
    }

    private String readString(Object object) {
        String s = object == null ? "" : object.toString();
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        return s.trim();
    }
}

