/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.workflow.archiver.ZipArchiverManager;
import com.suncode.pwfl.workflow.cipher.CipherManager;
import com.suncode.pwfl.workflow.support.MSWordFileCustomProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DownloadFile
extends HttpServlet {
    public static Logger log = Logger.getLogger(DownloadFile.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.trace((Object)"************************* DownloadFile Servlet ****************************");
        String encodedFileName = req.getParameter("fileId");
        log.debug((Object)("Pobieranie pliku o kodzie: " + encodedFileName));
        try (InputStream is = null;){
            if (StringUtils.isBlank((String)encodedFileName)) {
                throw new CUFException("Nie podano kodu pliku");
            }
            WfFile file = ArchiveServices.getFileByEncodedId(encodedFileName);
            if (file == null) {
                throw new CUFException("Nie znaleziono pliku o kodzie " + encodedFileName);
            }
            log.debug((Object)("Id znalezionego pliku: " + file.getId()));
            String filePath = file.getPath() + file.getSystemFileName();
            File f = new File(filePath);
            if (f == null || !f.exists()) {
                throw new CUFException("Plik nie istnieje we wskazanej dla niego lokalizacji " + filePath);
            }
            is = new FileInputStream(f);
            is = ZipArchiverManager.uncompress((InputStream)is, (WfFile)file);
            is = CipherManager.decryptFile((InputStream)is, (WfFile)file);
            is = MSWordFileCustomProperties.addProperties((InputStream)is, (WfFile)file);
            String mimetype = CUFTools.getMIMETypeFromExt(FilenameUtils.getExtension((String)file.getFileName()));
            if (StringUtils.isBlank((String)mimetype)) {
                mimetype = "application/octet-stream";
            }
            resp.setContentType(mimetype);
            resp.setContentLength(is.available());
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getFileName() + "\"; filename*=utf-8''" + URLEncoder.encode(file.getFileName(), "UTF-8"));
            ServletOutputStream outputStream = resp.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            log.debug((Object)"Zako\u0144czono wysy\u0142anie pliku");
        }
    }
}

