/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.right;

import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.right.DocClassRightService;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassConditionProtectionTable;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DocClassRightServiceImpl
implements DocClassRightService {
    private DBManagement dbm = new DBManagement();

    @Override
    public void addRight(String resourceId, boolean isGroup, Long documentClassId, String level) {
        if ((level = this.readLevel(level)).equalsIgnoreCase("none")) {
            throw new IllegalArgumentException("Cannot add NONE right by this service");
        }
        Authorization.addRight((String)("System.Archive.DocClasses." + documentClassId + "." + level), (String)resourceId, (boolean)isGroup);
        if (level.equalsIgnoreCase("modify") || level.equalsIgnoreCase("delete")) {
            Authorization.addRight((String)("System.Archive.DocClasses." + documentClassId + ".read"), (String)resourceId, (boolean)isGroup);
        }
        if (level.equalsIgnoreCase("delete")) {
            Authorization.addRight((String)("System.Archive.DocClasses." + documentClassId + ".modify"), (String)resourceId, (boolean)isGroup);
        }
    }

    @Override
    public void addRight(String resourceId, boolean isGroup, String documentClassName, String level, boolean adding, boolean printing) {
        DocClassTable d = this.dbm.getDocClassByName(documentClassName);
        this.addRight(resourceId, isGroup, d.getId(), level);
        if (adding) {
            this.addRight(resourceId, isGroup, d.getId(), "release");
        }
        if (printing) {
            this.addRight(resourceId, isGroup, d.getId(), "printing");
        }
    }

    @Override
    public void addConditionRight(String resourceId, boolean isGroup, String documentClassName, String type, String indexName, String operator, String value) {
        IndexTable idx = this.dbm.getIndexByName(indexName);
        DocClassTable dc = this.dbm.getDocClassByName(documentClassName);
        value = this.readIndexValue(idx.getId(), value, type, operator);
        DocClassConditionProtectionTable docClassConditionProtectionTable = new DocClassConditionProtectionTable(dc.getId().toString(), resourceId, String.valueOf(isGroup), type, value);
        this.dbm.addDocClassConditionProtection(docClassConditionProtectionTable);
    }

    @Override
    public void importDocumentClassRights(String path) throws Exception {
        ExcelReader er = new ExcelReader();
        List<Map<String, Object>> data = er.readExcel(path);
        for (Map<String, Object> row : data) {
            boolean isGroup = this.isGroup(row);
            String resourceId = this.readResourceId(row);
            String level = (String)row.get("Poziom uprawnie\u0144");
            boolean adding = this.readBoolean(row.get("Dodawanie dokument\u00f3w"));
            boolean printing = this.readBoolean(row.get("Drukowanie"));
            String documentClassName = (String)row.get("Nazwa klasy dokument\u00f3w");
            this.addRight(resourceId, isGroup, documentClassName, level, adding, printing);
        }
    }

    @Override
    public void importDocumentClassConditionRightsFromExcel(String path) throws Exception {
        ExcelReader er = new ExcelReader();
        HashMap<String, Class> excelTypes = new HashMap<String, Class>();
        excelTypes.put("Warto\u015b\u0107", Integer.class);
        er.setExcelTypes(excelTypes);
        List<Map<String, Object>> data = er.readExcel(path);
        for (Map<String, Object> row : data) {
            boolean isGroup = this.isGroup(row);
            String resourceId = this.readResourceId(row);
            String type = this.readType(row.get("Typ warunku"));
            String documentClassName = (String)row.get("Nazwa klasy dokument\u00f3w");
            String indexName = (String)row.get("Indeks");
            String operator = (String)row.get("Operator");
            String value = String.valueOf(row.get("Warto\u015b\u0107"));
            this.addConditionRight(resourceId, isGroup, documentClassName, type, indexName, operator, value);
        }
    }

    private String readType(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Nie podano typu");
        }
        String val = (String)object;
        if (val.equalsIgnoreCase("Por\u00f3wnanie warto\u015bci")) {
            return "compareValues";
        }
        if (val.equalsIgnoreCase("Dokumenty w zadaniach u\u017cytkownika")) {
            return "userProcessesDocuments";
        }
        if (val.startsWith("Dokumenty w zadaniach u\u017cytkownik\u00f3w z jed")) {
            return "userOuProcessesDocuments";
        }
        if (val.equalsIgnoreCase("Dokumenty z jednostki organizacyjnej u\u017cytkownika")) {
            return "userOuDocuments";
        }
        if (val.startsWith("Dokumenty z jednostek")) {
            return "userSubOuDocuments";
        }
        throw new IllegalArgumentException("Nieprawid\u0142owy typ: " + val);
    }

    private boolean readBoolean(Object object) {
        if (object == null) {
            return false;
        }
        String val = (String)object;
        return val.equalsIgnoreCase("tak") || val.equalsIgnoreCase("t") || val.equalsIgnoreCase("true");
    }

    private String readLevel(String level) {
        if (level.equalsIgnoreCase("read") || level.equalsIgnoreCase("odczyt")) {
            return "read";
        }
        if (level.equalsIgnoreCase("modify") || level.equalsIgnoreCase("modyfikacja")) {
            return "modify";
        }
        if (level.equalsIgnoreCase("delete") || level.equalsIgnoreCase("usuwanie")) {
            return "delete";
        }
        if (level.equalsIgnoreCase("release")) {
            return "release";
        }
        if (level.equalsIgnoreCase("printing")) {
            return "printing";
        }
        if (level.equalsIgnoreCase("none")) {
            return "none";
        }
        throw new IllegalArgumentException("Nieprawid\u0142owa warto\u015b\u0107 pola poziom: " + level);
    }

    private boolean isGroup(Map<String, Object> row) {
        String resourceId = (String)row.get("Nazwa u\u017cytkownika");
        return StringUtils.isBlank((String)resourceId);
    }

    private String readIndexValue(Long id, String value, String type, String operator) {
        String sCondition = null;
        if (type.compareTo("compareValues") == 0) {
            if (StringUtils.isBlank((String)operator)) {
                throw new IllegalArgumentException("Nie podano operatora");
            }
            String sIndexId = "idx000" + id;
            String sValue = value;
            if (operator.compareToIgnoreCase("LIKE") == 0) {
                if (sValue.indexOf("*") != -1 || sValue.indexOf("%") != -1) {
                    sValue = sValue.replace('*', '%');
                }
            } else if (operator.compareToIgnoreCase("IN") == 0) {
                String[] sValueLines = sValue.split("\r\n|[\n\r\u2028\u2029\u0085\f]");
                StringBuilder sbCondition = new StringBuilder(sIndexId);
                sbCondition.append(" IN (");
                for (String sValueLine : sValueLines) {
                    if (Tools.isNullOrEmpty((String)sValueLine)) continue;
                    sbCondition.append("'");
                    sbCondition.append(sValueLine);
                    sbCondition.append("',");
                }
                if (sbCondition.charAt(sbCondition.length() - 1) == ',') {
                    sbCondition.deleteCharAt(sbCondition.length() - 1);
                }
                sbCondition.append(")");
                sCondition = sbCondition.toString();
            }
            if (sCondition == null) {
                sCondition = sIndexId + " " + operator + " '" + sValue + "'";
            }
        } else if (type.compareTo("userOuDocuments") == 0) {
            String sIndexId;
            sCondition = sIndexId = "idx000" + id;
        } else if (type.compareTo("userSubOuDocuments") == 0) {
            String sIndexId;
            sCondition = sIndexId = "idx000" + id;
        }
        return sCondition;
    }

    private String readResourceId(Map<String, Object> row) {
        String resourceId = (String)row.get("Nazwa u\u017cytkownika");
        if (StringUtils.isBlank((String)resourceId) && StringUtils.isBlank((String)(resourceId = (String)row.get("Nazwa grupy")))) {
            throw new IllegalArgumentException("Nie podano grupy ani u\u017cytkownika");
        }
        return resourceId;
    }
}

