/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.FinderFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class WordTemplateDocumentWrapper {
    private List<WfFile> wfFileList;
    private UserFinder userFinder;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public WordTemplateDocumentWrapper(List<WfDocument> documentsList) {
        this.wfFileList = documentsList.stream().map(document -> document.getFile()).collect(Collectors.toList());
        this.userFinder = FinderFactory.getUserFinder();
    }

    public String getDocumentsNames() {
        return this.wfFileList.stream().map(WfFile::getFileName).collect(Collectors.joining(";"));
    }

    public String getDocumentsDescriptions() {
        return this.wfFileList.stream().map(WfFile::getDescription).collect(Collectors.joining(";"));
    }

    public String getDocumentsClassNames() {
        return this.wfFileList.stream().map(wfFile -> wfFile.getDocumentClass().getName()).collect(Collectors.joining(";"));
    }

    public String getDocumentsClassUploaders() {
        return this.wfFileList.stream().map(WfFile::getUploader).map(username -> {
            User user = this.userFinder.findByUserName(username, new String[0]);
            if (user == null) {
                return username;
            }
            if (StringUtils.isNotBlank((String)user.getFullName())) {
                return user.getFullName();
            }
            return user.getUserName();
        }).collect(Collectors.joining(";"));
    }

    public String getDocumentsDates() {
        return this.wfFileList.stream().map(wfFile -> dateFormat.format(wfFile.getFileDate())).collect(Collectors.joining(";"));
    }
}

