/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf;

import com.documents4j.api.IConverter;
import com.documents4j.job.LocalConverter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfOfficeConverter {
    private static final Logger log = LoggerFactory.getLogger(PdfOfficeConverter.class);
    private static IConverter converter;

    public static IConverter getConverter() {
        if (converter == null) {
            converter = ((LocalConverter.Builder)LocalConverter.builder().baseFolder(PdfOfficeConverter.getBaseFolder())).build();
        }
        return converter;
    }

    public static IConverter forceReloadConverter() {
        converter.kill();
        converter = null;
        return PdfOfficeConverter.getConverter();
    }

    private static File getBaseFolder() {
        String baseFolderPath = System.getProperty("plusworkflow.home") + "/documents4j";
        File directory = new File(baseFolderPath);
        if (directory.exists()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                log.warn("Cannot delete documents4j directory " + baseFolderPath, (Throwable)e);
            }
        }
        directory.mkdirs();
        return directory;
    }
}

