/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.right;

import com.plusmpm.CUF.util.extension.right.RightService;
import com.plusmpm.util.Authorization;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class RightServiceImpl
implements RightService {
    private static Map<String, String> levels;

    @Override
    public void addRight(String resourceId, boolean isGroup, String module) {
        this.validate(resourceId, isGroup, module);
        Authorization.addRight((String)module, (String)resourceId, (boolean)isGroup);
    }

    public void validate(String resourceId, boolean isGroup, String module) {
        if (StringUtils.isBlank((String)resourceId)) {
            throw new IllegalArgumentException("Nie podano resourceId");
        }
        if (StringUtils.isBlank((String)module)) {
            throw new IllegalArgumentException("Nie podano module");
        }
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        if (isGroup) {
            try {
                uga.doesGroupExist(resourceId);
            }
            catch (BaseException e) {
                throw new IllegalArgumentException("Grupa: " + resourceId + " nie istnieje ", e);
            }
        }
        try {
            uga.doesUserExist(resourceId);
        }
        catch (BaseException e) {
            throw new IllegalArgumentException("U\u017cytkownik: " + resourceId + " nie istnieje ", e);
        }
    }

    @Override
    public Map<String, String> getLevelNames() {
        if (levels == null) {
            levels = new HashMap<String, String>();
            levels.put("System", "system");
            levels.put("Administracja", "system.admin");
            levels.put("Archiwum", "system.archive");
            levels.put("Klasy dokument\u00f3w", "system.archive.docclasses");
            levels.put("Zestawy dokument\u00f3w", "system.archive.links");
            levels.put("Obieg dokument\u00f3w", "system.workflow");
            levels.put("Tworzenie proces\u00f3w", "system.workflow.processes.create");
            levels.put("Zadania", "system.workflow.tasks");
            levels.put("Kalendarz", "system.workflow.calendar");
            levels.put("Wyszukiwanie proces\u00f3w", "system.processes.view");
            levels.put("Statystyki proces\u00f3w", "system.processes.stats");
            levels.put("Raporty", "system.reports");
            levels.put("Konto u\u017cytkownika", "system.useraccount");
            levels.put("Modu\u0142y", "system.plugins");
        }
        return levels;
    }
}

