/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper;

import com.suncode.cuf.plannedtask.administration.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.helper.StructureAdapter;
import com.suncode.cuf.plannedtask.administration.helper.StructureMappings;
import com.suncode.cuf.plannedtask.administration.helper.StructureValidator;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.exception.GroupAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.util.SpringContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class StructureImporter {
    private static final Logger log = ContextLogger.getLogger(StructureImporter.class);
    private ImportStructureMode mode;
    Comparator<Map<String, String>> userNameComparator = new Comparator<Map<String, String>>(){

        @Override
        public int compare(Map<String, String> m1, Map<String, String> m2) {
            return m1.get("userName").compareTo(m2.get("userName"));
        }
    };

    public void setMode(ImportStructureMode mode) {
        this.mode = mode;
    }

    public void importStructure(List<Map<String, Object>> rawData, StructureMappings mappings, ImportStructureMode mode) throws UserNotFoundException, GroupNotFoundException, UserAlreadyExistException, GroupAlreadyExistException {
        List<Map<String, String>> converted = this.convertData(rawData, mappings);
        this.validate(converted);
        this.mode = mode;
        this.readStructure(converted);
    }

    public void validate(List<Map<String, String>> converted) {
        StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
        validator.validateStructure(converted);
    }

    public List<Map<String, String>> convertData(List<Map<String, Object>> rawData, StructureMappings mappings) {
        StructureAdapter sa = (StructureAdapter)SpringContext.getBean(StructureAdapter.class);
        List<Map<String, String>> converted = sa.convertImportingStructure(rawData, mappings);
        Assert.isTrue((rawData.size() == converted.size() ? 1 : 0) != 0, (String)"Przekonwertowane dane maj\u0105 inny rozmiar");
        log.debug("Konwersja struktury zako\u0144czona powodzeniem");
        return converted;
    }

    public void readStructure(List<Map<String, String>> structure) throws UserNotFoundException, GroupNotFoundException, UserAlreadyExistException, GroupAlreadyExistException {
        Collections.sort(structure, this.userNameComparator);
        for (int i = 0; i < structure.size(); ++i) {
            Map<String, String> row = structure.get(i);
            User user = this.mode.buildUser(row, i, structure);
            log.trace("Read row: {}", row);
            if (user == null || user.getPositions().size() <= 0) continue;
            i += user.getPositions().size() - 1;
        }
        this.mode.removeUnusedElements();
    }
}

