/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.ProcessFinder;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.Tools;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ActivityFinder {
    private Logger log = Logger.getLogger(ActivityFinder.class);
    private ProcessFinder pf = new ProcessFinder();

    private String generateQuery(Map<String, Object> params) {
        String type = (String)params.get("resourceType");
        String query = "";
        String actName = "";
        String actDefId = "";
        if (params.containsKey("activityName")) {
            actName = "and a.name=:activityName ";
        }
        if (params.containsKey("activityDefId")) {
            actDefId = "and a.activitydefinitionid=:activityDefId ";
        }
        if (type == null || type.isEmpty()) {
            query = query + "select distinct a.id as activityid,a.processid  ";
            query = query + " from activities a ";
            query = query + "join processes p on a.process=p.objectid ";
            query = query + "join processdefinitions pd on p.processdefinition=pd.objectid ";
            query = query + "where 0=0 ";
            query = query + actDefId;
            query = query + actName;
        } else if (type.equalsIgnoreCase("role")) {
            query = query + "select distinct at.activityid,a.processid  ";
            query = query + "from assignmentstable at  ";
            query = query + "join activities a on a.id=at.activityid ";
            query = query + "join processes p on a.process=p.objectid ";
            query = query + "join processdefinitions pd on p.processdefinition=pd.objectid ";
            query = query + "join pm_userposition up on up.userid=at.resourceid ";
            query = query + "join pm_positionrole pr on pr.positionid=up.positionid ";
            query = query + "where pr.roleid=:resourceName ";
            query = query + actDefId;
            query = query + actName;
        } else if (type.equalsIgnoreCase("group")) {
            query = query + "select distinct at.activityid,a.processid ";
            query = query + "from assignmentstable at  ";
            query = query + "join activities a on a.id=at.activityid ";
            query = query + "join processes p on a.process=p.objectid ";
            query = query + "join processdefinitions pd on p.processdefinition=pd.objectid ";
            query = query + "join usertable ut on ut.userid=at.resourceid  ";
            query = query + "join usergrouptable ugt on ugt.userid=ut.objectid ";
            query = query + "join grouptable gt on gt.objectid=ugt.groupid ";
            query = query + "where gt.groupid=:resourceName ";
            query = query + actDefId;
            query = query + actName;
        } else if (type.equalsIgnoreCase("userName")) {
            query = query + "select distinct at.activityid as activityid,a.processid ";
            query = query + "from assignmentstable at  ";
            query = query + "join activities a on a.id=at.activityid ";
            query = query + "join processes p on a.process=p.objectid ";
            query = query + "join processdefinitions pd on p.processdefinition=pd.objectid ";
            query = query + "where at.resourceid=:resourceName ";
            query = query + actDefId;
            query = query + actName;
        } else {
            this.log.warn((Object)"Nie obs\u0142u\u017cony warunek");
        }
        if (!Tools.isNullOrEmpty((String)query)) {
            if (params.containsKey("processDefId")) {
                query = query + "and pd.processdefinitionid=:processDefId ";
            } else if (params.containsKey("processName")) {
                query = query + "and p.name=:processName ";
            }
        }
        return query;
    }

    public List<Map<String, Object>> find(Map<String, Object> params) throws Exception {
        if (!params.containsKey("processDefId") && !params.containsKey("processName")) {
            throw new IllegalArgumentException("Nie podano parametr\u00f3w processName i processDefId");
        }
        String query = this.generateQuery(params);
        List<Map<String, Object>> activities = new ArrayList<Map<String, Object>>();
        if (Tools.isNullOrEmpty((String)query)) {
            this.log.error((Object)"Wprowadzono nieprawid\u0142owe parametry");
            return activities;
        }
        this.log.debug((Object)("query: " + query));
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery(query);
            sql.addScalar("processid", (Type)StandardBasicTypes.STRING);
            sql.addScalar("activityid", (Type)StandardBasicTypes.STRING);
            List<String> sqlParams = Arrays.asList(sql.getNamedParameters());
            for (String key : params.keySet()) {
                Object val;
                if (!sqlParams.contains(key) || (val = params.get(key)) == null) continue;
                if (key.startsWith("startDate")) {
                    sql.setDate(key, (Date)val);
                    continue;
                }
                sql.setParameter(key, val);
            }
            sql.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
            activities = sql.list();
            tx.commit();
            ArrayList<Map<String, Object>> arrayList = activities;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getActivitiesFromProcess(String processId, String activityName, List<String> states) {
        this.log.debug((Object)"ACTIVITYFINDER : getActivitiesFromProcess");
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String select = "select processid as processid, id as activityid, laststatetime as taskfinish ";
            String from = "from activities ";
            String where = "where processid=:processId and name=:activityName ";
            if (states != null && states.size() >= 1) {
                String stateStm = "and ( ";
                for (String state : states) {
                    stateStm = stateStm + "state = " + state + " or ";
                }
                stateStm = stateStm.substring(0, stateStm.length() - 3);
                stateStm = stateStm + ")";
                where = where + stateStm;
            }
            String query = select + from + where;
            SQLQuery sql = hs.createSQLQuery(query);
            sql.setString("processId", processId);
            sql.setString("activityName", activityName);
            sql.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
            List acts = sql.list();
            SimpleDateFormat sdf = new SimpleDateFormat(DBManagement.CONST_DATEFORMAT);
            for (Map map : acts) {
                BigInteger lastState = (BigInteger)map.get("taskfinish");
                long lLastState = lastState.longValue();
                map.remove("taskfinish");
                map.put("processId", map.remove("processid"));
                map.put("activityId", map.remove("activityid"));
                map.put("taskFinish", sdf.format(new Date(lLastState)));
                this.log.debug((Object)("processId: " + map.get("processId")));
                this.log.debug((Object)("activityId: " + map.get("activityId")));
                this.log.debug((Object)("taskFinish: " + map.get("taskFinish")));
            }
            tx.commit();
            List list = acts;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.log.error((Object)e.getMessage(), (Throwable)e);
            List<Map<String, Object>> list = null;
            return list;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> getActivitiesFromProcess(String processId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select id from activities where processid=:processId ");
            sql.addScalar("id", (Type)StandardBasicTypes.STRING);
            sql.setString("processId", processId);
            List actIds = sql.list();
            tx.commit();
            List list = actIds;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }
}

