/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure;

import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.plannedtask.administration.structure.ImportStructureUtils;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureValidator;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.GroupMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.OrgUnitMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.PositionMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.UserMappings;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.logging.LoggerLevel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOrgStructure {
    private static final Logger taskLog = LoggerFactory.getLogger((String)"ScheduledTask");

    public void importStructure(String path, String mode) throws Exception {
        this.importStructure(path, mode, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="importStructure", description="importStructure", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path, @TaskParam(name="read_mode", description="read_mode_desc") String mode, @TaskParam(name="Unused_users", description="Unused_users_desc") String unusedUsersHandleType, @TaskParam(name="Assign_users_tasks", description="Assign_users_tasks_desc") String assignmentUsers) throws Exception {
        ContextLogger.set(taskLog, LoggerLevel.INFO);
        try {
            ImportStructureUtils.checkFileExist(path);
            List<ImportSheetDefinition> importSheetDefinitions = this.buildDefinitions();
            StructureData data = ImportStructureUtils.importDataFromXls(importSheetDefinitions, path);
            StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
            validator.validateStructure(data, mode);
            ImportStructureUtils.exportDataToDatabase(data, mode, unusedUsersHandleType, assignmentUsers);
        }
        finally {
            ContextLogger.clear();
        }
    }

    private List<ImportSheetDefinition> buildDefinitions() {
        ArrayList<ImportSheetDefinition> definitions = new ArrayList<ImportSheetDefinition>();
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("U\u017cytkownicy", UserMappings.getInstance()));
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("Grupy", GroupMappings.getInstance()));
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("Stanowiska", PositionMappings.getInstance()));
        definitions.add(ImportStructureUtils.getSheetDefinitionForStructure("Jednostki organizacyjne", OrgUnitMappings.getInstance()));
        return definitions;
    }
}

