/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.database.config.DatabaseConfig;
import com.suncode.cuf.hibernate.HibernateQueryExecutor;
import com.suncode.cuf.hibernate.SessionFactoryBuilder;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.plannedtask.administration.ExportStructure;
import com.suncode.cuf.plannedtask.administration.helper.StructureValidator;
import com.suncode.cuf.plannedtask.administration.helper.internal.DBMappings;
import com.suncode.cuf.plannedtask.administration.helper.internal.ExcelMappings;
import com.suncode.cuf.plannedtask.administration.structure.ImportStructureUtils;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureMappings;
import com.suncode.cuf.sql.query.SelectQuery;
import com.suncode.cuf.sql.query.type.SqlTypes;
import com.suncode.pwfl.util.SpringContext;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportStructure
extends AbstractAdvancedTask {
    private static final Logger taskLog = LoggerFactory.getLogger((String)"ScheduledTask");
    private volatile double progress = 0.0;
    public static final String APPEND = "APPEND";
    public static final String STANDARD = "STANDARD";
    public static final String OVERRIDE = "OVERRIDE";

    public Double getProgress() {
        return this.progress;
    }

    public void importStructure(String path, String mode) throws Exception {
        this.importStructure(path, mode, "", "");
    }

    @AdvancedTask(name="importStructure", description="importStructure", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path, @TaskParam(name="read_mode", description="read_mode_desc") String mode, @TaskParam(name="Unused_users", description="Unused_users_desc") String unusedUsersHandleType, @TaskParam(name="Assign_users_tasks", description="Assign_users_tasks_desc") String assignmentUsers) throws Exception {
        ImportStructureUtils.checkFileExist(path);
        Workbook wb = this.getWorkBook(path);
        ImportSheetDefinition sheetDef = ImportStructureUtils.getSheetDefinitionForStructure(wb.getSheetAt(0).getSheetName(), ExcelMappings.getInstance());
        wb.close();
        ArrayList<ImportSheetDefinition> importSheetDefinitions = new ArrayList<ImportSheetDefinition>();
        importSheetDefinitions.add(sheetDef);
        StructureData data = ImportStructureUtils.importDataFromXls(importSheetDefinitions, path);
        StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
        validator.validateStructure(data, mode);
        ImportStructureUtils.exportDataToDatabase(data, mode, unusedUsersHandleType, assignmentUsers);
    }

    @AdvancedTask(name="importStructureFromDb", description="importStructureFromDb", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructureFromDb(@TaskParam(name="dbtype", description="dbtype_desc") String dbType, @TaskParam(name="dburl", description="dburl") String url, @TaskParam(name="dbport", description="dbport") String port, @TaskParam(name="dbname", description="dbname") String dbName, @TaskParam(name="tablename", description="tablename") String tableName, @TaskParam(name="dbusername", description="dbusername") String userName, @TaskParam(name="dbpass", description="dbpass") String password, @TaskParam(name="read_mode", description="read_mode_desc") String mode, @TaskParam(name="columns", description="columns") String columns) throws Exception {
        StructureMappings mappings = this.getDBMappings(columns);
        DatabaseConfig dbcfg = ExportStructure.buildDBConfig(dbType, url, port, dbName, userName, password);
        StructureData data = this.readData(dbcfg, tableName, mappings);
        this.progress = 0.5;
        ImportStructureUtils.exportDataToDatabase(data, mode, "", "");
        this.progress = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructureData readData(DatabaseConfig dbcfg, String tableName, StructureMappings mappings) {
        try (SessionFactory sf = null;){
            sf = SessionFactoryBuilder.buildSessionFactory(dbcfg);
            HibernateQueryExecutor executor = new HibernateQueryExecutor();
            executor.setSessionFactory(sf);
            SelectQuery select = new SelectQuery();
            select.setQuery(this.buildQuery(mappings, tableName));
            this.buildScalars(select, mappings);
            List<Map<String, Object>> data = executor.list(select);
            SheetDefinition sheetDef = new SheetDefinition("sheet0", data, mappings.getColumnNames());
            ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
            sheets.add(sheetDef);
            StructureData structureData = new StructureData(sheets);
            return structureData;
        }
    }

    private void buildScalars(SelectQuery select, StructureMappings mappings) {
        for (String col : mappings.getColumnNames()) {
            select.addScalar(col, SqlTypes.STRING);
        }
    }

    private String buildQuery(StructureMappings mappings, String tableName) {
        Object[] cols = mappings.getColumnNames();
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(StringUtils.join((Object[])cols, (String)","));
        sb.append(" from ");
        sb.append(tableName);
        return sb.toString();
    }

    StructureMappings getDBMappings(String columns) {
        DBMappings mappings = new DBMappings();
        if (StringUtils.isNotBlank((CharSequence)columns)) {
            mappings.setColumnNames(columns.split(";"));
        }
        return mappings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Workbook getWorkBook(String path) {
        try (FileInputStream is = new FileInputStream(path);){
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            return workbook;
        }
        catch (Exception e) {
            taskLog.error("B\u0142\u0105d odczytu pliku: " + e);
            return null;
        }
    }
}

