/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.ini.INIFile;
import com.plusmpm.util.Tools;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class Reports {
    public static Logger log = Logger.getLogger(Reports.class);
    private static String sFilePathResults;
    private static String sFilePathErrorResults;

    public static void RunReportGenerator(String sIniPath, String sFilePath, String sRaportSzkic, String sRaportResults) {
        log.debug((Object)("************************ RunReportGenerator(sIniPath=" + sIniPath + ", sFilePath=" + sFilePath + ", sRaportSzkic=" + sRaportSzkic + ", sRaportResults=" + sRaportResults + ") *************************"));
        long startTime = new Date().getTime();
        INIFile obj = null;
        try {
            sIniPath = CUFTools.cutSpaces(sIniPath);
            obj = new INIFile(sIniPath);
        }
        catch (Exception e) {
            log.debug((Object)"Blad podczas otwierania pliku konfiguracyjnego");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (obj != null) {
                boolean bSendReport;
                sFilePath = CUFTools.cutSpaces(sFilePath);
                sRaportSzkic = CUFTools.cutSpaces(sRaportSzkic);
                sRaportResults = CUFTools.cutSpaces(sRaportResults);
                String sMessage = null;
                String sErrorMessage = null;
                if (obj.getStringProperty("ReportOptions", "EnableErrorReport").compareToIgnoreCase("TRUE") == 0) {
                    log.debug((Object)"Proba tworzenia raportu bledow");
                    bSendReport = false;
                    if (Reports.createErrorReport(sFilePath, obj)) {
                        sErrorMessage = "Raport bledow utworzony pomyslnie.";
                        log.debug((Object)sErrorMessage);
                        bSendReport = true;
                    } else {
                        sErrorMessage = "Tworzenie raportu bledow zakonczone niepowodzeniem.";
                        log.debug((Object)sErrorMessage);
                    }
                    if (bSendReport && obj.getStringProperty("ReportOptions", "SendErrorReport").compareToIgnoreCase("TRUE") == 0) {
                        log.debug((Object)"Proba wyslania raportu bledow");
                        Reports.prepareToSend(obj, "SendErrorReport", sErrorMessage, "Raport bledow", sFilePathErrorResults);
                    }
                }
                if (obj.getStringProperty("ReportOptions", "EnableReport").compareToIgnoreCase("TRUE") == 0) {
                    log.debug((Object)"Proba tworzenia raportu");
                    bSendReport = false;
                    if (Reports.createReport(sFilePath, sRaportSzkic, sRaportResults, obj)) {
                        sMessage = "Raport utworzony pomyslnie.";
                        log.debug((Object)sMessage);
                        bSendReport = true;
                    } else {
                        sMessage = "Tworzenie raportu zakonczone niepowodzeniem.";
                        log.debug((Object)sMessage);
                    }
                    if (bSendReport && obj.getStringProperty("ReportOptions", "SendReport").compareToIgnoreCase("TRUE") == 0) {
                        log.debug((Object)"Proba wyslania raportu");
                        Reports.prepareToSend(obj, "SendReport", sMessage, "Raport", sFilePathResults);
                    }
                }
            } else {
                log.debug((Object)("Wystapil blad podczas otwierania lub plik konfiguracyjny nie istnieje w podanej lokalizacji " + sIniPath));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego RunReportGenerator: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static void prepareToSend(INIFile obj, String sSection, String sMessage, String sSubject, String sFilePath) {
        log.trace((Object)("************ prepareToSend(INIFile, sSection=" + sSection + ", sMessage=" + sMessage + ", sSubject=" + sSubject + ", sFilePath=" + sFilePath + ") ************"));
        try {
            String sEmail = obj.getStringProperty(sSection, "Addresses");
            String SMTPMailServer = obj.getStringProperty(sSection, "SMTPMailServer");
            String SMTPPortNo = obj.getStringProperty(sSection, "SMTPPortNo");
            String User2 = obj.getStringProperty(sSection, "User");
            String UserPassword = obj.getStringProperty(sSection, "UserPassword");
            String SourceAddress = obj.getStringProperty(sSection, "SourceAddress");
            String SMTPAuth = obj.getStringProperty(sSection, "SMTPAuth");
            if (!Tools.isNullOrEmpty((String)sEmail)) {
                sEmail = CUFTools.cutSpaces(sEmail);
                String[] sEmailTable = sEmail.split(";");
                if (!(Tools.isNullOrEmpty((String)SMTPMailServer) || Tools.isNullOrEmpty((String)SMTPPortNo) || Tools.isNullOrEmpty((String)User2) || Tools.isNullOrEmpty((String)UserPassword) || Tools.isNullOrEmpty((String)SourceAddress) || Tools.isNullOrEmpty((String)SMTPAuth))) {
                    SMTPMailServer = CUFTools.cutSpaces(SMTPMailServer);
                    SMTPPortNo = CUFTools.cutSpaces(SMTPPortNo);
                    User2 = CUFTools.cutSpaces(User2);
                    UserPassword = CUFTools.cutSpaces(UserPassword);
                    SourceAddress = CUFTools.cutSpaces(SourceAddress);
                    SMTPAuth = CUFTools.cutSpaces(SMTPAuth);
                    for (int j = 0; j < sEmailTable.length; ++j) {
                        boolean isSend = false;
                        for (int i = 0; i < 5; ++i) {
                            isSend = Reports.sendEmail(sEmailTable[j], SourceAddress, SMTPMailServer, SMTPPortNo, sFilePath, sMessage, sSubject, User2, UserPassword, Boolean.valueOf(SMTPAuth));
                            if (isSend) {
                                sMessage.concat(" " + sSubject + " wyslany w " + (i + 1) + " probach.");
                                break;
                            }
                            try {
                                TimeUnit.SECONDS.sleep(10L);
                                continue;
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        if (isSend) {
                            log.debug((Object)(sSubject + " zostal wyslany na adres " + sEmailTable[j]));
                            continue;
                        }
                        log.debug((Object)(sSubject + " nie zostal wyslany poprawnie na adres " + sEmailTable[j]));
                    }
                } else {
                    log.debug((Object)("Brak parametrow skrzynki pocztowej dla wychodzacych wiadomosci. Sprawdz sekcje " + sSection + " w pliku konfiguracyjnym"));
                }
            } else {
                log.debug((Object)("Brak adresu odbiorcy maila. Sprawdz sekcje " + sSection + " w pliku konfiguracyjnym"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static boolean sendEmail(String to, String from, String host, String SMTPPort, String filename, String msgText1, String subject, final String user, final String password, boolean authentication) {
        log.trace((Object)("************ sendEmail(to=" + to + ", from=" + from + ", host=" + host + ", SMTPPort=" + SMTPPort + ", filename=" + filename + ", msgText1=" + msgText1 + ", subject=" + subject + ", user=" + user + ", password, authentication=" + String.valueOf(authentication) + ") ************"));
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", SMTPPort);
        props.put("mail.store.protocol", "pop3");
        props.put("mail.transport.protocol", "smtp");
        Session session = null;
        if (authentication) {
            props.put("mail.user", user);
            props.put("mail.password", password);
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "true");
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        session.setDebug(false);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(subject);
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(msgText1);
            MimeBodyPart mbp2 = new MimeBodyPart();
            mbp2.attachFile(filename);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            mp.addBodyPart((BodyPart)mbp2);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean createErrorReport(String sFilePath, INIFile obj) {
        log.trace((Object)("************ createErrorReport(sFilePath=" + sFilePath + ", INIFile) ************"));
        HashMap results = null;
        try {
            String[] propertyNames;
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            sFilePathErrorResults = sFilePath + "ErrorReport_" + String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + ".xls";
            log.debug((Object)("Lokalizacja pliku z raportem bledow: " + sFilePathErrorResults));
            File xls = new File(sFilePathErrorResults);
            WorkbookSettings wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            WritableWorkbook workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            ArrayList<Integer> nrOfErrorActions = new ArrayList<Integer>();
            for (String property : propertyNames = obj.getPropertyNames("Actions")) {
                try {
                    if (property.substring(0, 5).compareToIgnoreCase("error") != 0) continue;
                    nrOfErrorActions.add(Integer.valueOf(property.substring(17, property.length())));
                }
                catch (Exception e) {
                    log.debug((Object)("Nieznana definicja akcji o nazwie " + property));
                }
            }
            log.debug((Object)("Ilosc akcji dla raportu bledow: " + nrOfErrorActions.size()));
            if (nrOfErrorActions.size() == 0) {
                log.debug((Object)"Brak jakiejkolwiek akcji ErrorReportAction dla raportu bledow w sekcji Actions w pliku konfiguracyjnym");
                return false;
            }
            boolean anyEffect = false;
            int createdSheetNr = 0;
            for (int i = 1; i <= nrOfErrorActions.size(); ++i) {
                String actionName = obj.getStringProperty("Actions", "ErrorReportAction" + nrOfErrorActions.get(i - 1));
                if (actionName != null) {
                    actionName = CUFTools.cutSpaces(actionName);
                    log.debug((Object)("Wykonywana akcja dla raportu bledow: " + actionName));
                    String sType = obj.getStringProperty(actionName, "Type");
                    String sValue = obj.getStringProperty(actionName, "Value");
                    String sLocation = obj.getStringProperty(actionName, "Location");
                    String sCellType = obj.getStringProperty(actionName, "CellType");
                    sType = CUFTools.cutSpaces(sType);
                    sValue = CUFTools.cutSpaces(sValue);
                    sLocation = CUFTools.cutSpaces(sLocation);
                    sCellType = CUFTools.cutSpaces(sCellType);
                    if (!(Tools.isNullOrEmpty((String)sType) || Tools.isNullOrEmpty((String)sValue) || Tools.isNullOrEmpty((String)sLocation) || Tools.isNullOrEmpty((String)sCellType))) {
                        String sSheetNumber = sLocation.split("-")[0];
                        WritableSheet sheet = null;
                        try {
                            sheet = workbook.getSheet(Integer.valueOf(sSheetNumber).intValue());
                        }
                        catch (Exception e) {
                            sheet = null;
                        }
                        if (sheet == null) {
                            sheet = workbook.createSheet(actionName, createdSheetNr);
                            ++createdSheetNr;
                        }
                        if (sType.compareToIgnoreCase("query") != 0) continue;
                        log.debug((Object)("Wykonywanie zapytania " + sValue));
                        anyEffect = true;
                        results = new HashMap();
                        results = Reports.executeQuery(sValue);
                        if (workbook != null) {
                            Reports.saveDataToExcel(results, workbook, sLocation, sCellType);
                            continue;
                        }
                        log.debug((Object)"Workbook jest null");
                        continue;
                    }
                    log.debug((Object)("Brak definicji akcji " + actionName + " lub bledna definicja"));
                    continue;
                }
                log.debug((Object)("Brak akcji przypisanej dla ErrorReportAction" + nrOfErrorActions.get(i - 1)));
            }
            if (!anyEffect) {
                log.debug((Object)"Brak poprawnej definicji jakiejkolwiek akcji. Sprawdz definicje akcji");
                return false;
            }
            if (workbook != null) {
                workbook.write();
                workbook.close();
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean createReport(String sFilePath, String sFileSzkic, String sFileResults, INIFile obj) {
        log.trace((Object)("************ createReport(sFilePath=" + sFilePath + ", sFileSzkic=" + sFileSzkic + ", sFileResults=" + sFileResults + ", INIFile) ************"));
        HashMap results = null;
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String sFilePathSzkic = sFilePath + sFileSzkic + ".xls";
        sFilePathResults = sFilePath + sFileResults + "_" + String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + ".xls";
        File file1 = new File(sFilePathSzkic);
        File file2 = new File(sFilePathResults);
        Workbook workbook1 = null;
        WritableWorkbook workbook = null;
        try {
            workbook1 = Workbook.getWorkbook((File)file1);
            workbook = Workbook.createWorkbook((File)file2, (Workbook)workbook1);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            String[] propertyNames;
            ArrayList<Integer> nrOfActions = new ArrayList<Integer>();
            for (String property : propertyNames = obj.getPropertyNames("Actions")) {
                try {
                    if (property.substring(0, 5).compareToIgnoreCase("error") == 0) continue;
                    nrOfActions.add(Integer.valueOf(property.substring(12, property.length())));
                }
                catch (Exception e) {
                    log.debug((Object)("Nieznana definicja akcji o nazwie " + property));
                }
            }
            log.debug((Object)("Ilosc akcji dla raportu: " + nrOfActions.size()));
            if (nrOfActions.size() == 0) {
                log.debug((Object)"Brak jakiejkolwiek akcji ReportAction dla raportu w sekcji Actions w pliku konfiguracyjnym");
                return false;
            }
            boolean anyEffect = false;
            for (int i = 1; i <= nrOfActions.size(); ++i) {
                String actionName = obj.getStringProperty("Actions", "ReportAction" + nrOfActions.get(i - 1));
                if (actionName != null) {
                    actionName = CUFTools.cutSpaces(actionName);
                    log.debug((Object)("Wykonywana akcja dla raportu: " + actionName));
                    String sType = obj.getStringProperty(actionName, "Type");
                    String sValue = obj.getStringProperty(actionName, "Value");
                    String sLocation = obj.getStringProperty(actionName, "Location");
                    String sCellType = obj.getStringProperty(actionName, "CellType");
                    sType = CUFTools.cutSpaces(sType);
                    sValue = CUFTools.cutSpaces(sValue);
                    sLocation = CUFTools.cutSpaces(sLocation);
                    sCellType = CUFTools.cutSpaces(sCellType);
                    if (!(Tools.isNullOrEmpty((String)sType) || Tools.isNullOrEmpty((String)sValue) || Tools.isNullOrEmpty((String)sLocation) || Tools.isNullOrEmpty((String)sCellType))) {
                        if (sType.compareToIgnoreCase("query") != 0) continue;
                        log.debug((Object)("Wykonywanie zapytania " + sValue));
                        anyEffect = true;
                        results = new HashMap();
                        results = Reports.executeQuery(sValue);
                        if (workbook != null) {
                            Reports.saveDataToExcel(results, workbook, sLocation, sCellType);
                            continue;
                        }
                        log.debug((Object)"Workbook jest null");
                        continue;
                    }
                    log.debug((Object)("Brak definicji akcji " + actionName + " lub bledna definicja"));
                    continue;
                }
                log.debug((Object)("Brak akcji przypisanej dla ReportAction" + nrOfActions.get(i - 1)));
            }
            if (!anyEffect) {
                log.debug((Object)"Brak poprawnej definicji jakiejkolwiek akcji. Sprawdz definicje akcji");
                return false;
            }
            if (workbook != null) {
                workbook.write();
                workbook.close();
            }
            if (workbook1 != null) {
                workbook1.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap executeQuery(String sQuerry) {
        log.trace((Object)("************ executeQuery(sQuerry=" + sQuerry + ") ************"));
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        LinkedHashMap<String, List> hashmap1 = null;
        try {
            conn = DBManagement.ConnectToDB();
            if (conn != null && !conn.isClosed()) {
                st = conn.createStatement();
                log.debug((Object)sQuerry);
                rs = st.executeQuery(sQuerry);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numbColumn = rsmd.getColumnCount();
                log.debug((Object)("Ilosc kolumn: " + numbColumn));
                if (numbColumn > 0) {
                    int i;
                    List[] tab1 = new List[numbColumn];
                    hashmap1 = new LinkedHashMap<String, List>();
                    String columnName = null;
                    for (i = 0; i < numbColumn; ++i) {
                        tab1[i] = new ArrayList();
                    }
                    while (rs.next()) {
                        for (i = 1; i < numbColumn + 1; ++i) {
                            columnName = rsmd.getColumnName(i);
                            String value = rs.getString(columnName);
                            if (value == null) {
                                value = "";
                            }
                            tab1[i - 1].add(value);
                        }
                    }
                    for (i = 0; i < numbColumn; ++i) {
                        hashmap1.put(rsmd.getColumnName(i + 1), tab1[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return hashmap1;
    }

    private static boolean saveDataToExcel(HashMap data, WritableWorkbook workbook, String sLocation, String sTypeCells) {
        log.trace((Object)("************ saveDataToExcel(HashMap, WritableWorkbook, sLocation=" + sLocation + ", sTypeCells=" + sTypeCells + ") ************"));
        String[] sLoc = sLocation.split(";");
        String[] sTypeCellTab = sTypeCells.split(";");
        String[] sOneLoc = null;
        if (data != null) {
            Set set1 = data.entrySet();
            Iterator it = set1.iterator();
            int itemlocation = 0;
            int difflocation = 0;
            int itemtypecell = 0;
            while (it.hasNext()) {
                sOneLoc = sLoc[itemlocation].split("-");
                String sSheetNumber = sOneLoc[0];
                String sColNumber = sOneLoc[1];
                String sRowNumber = sOneLoc[2];
                String sTypeCell = sTypeCellTab[itemtypecell];
                if ((sTypeCell = sTypeCell.replace(" ", "")).compareTo("") == 0) {
                    sTypeCell = "text";
                }
                if (sTypeCell.compareTo("text") != 0 && sTypeCell.compareTo("number") != 0) {
                    sTypeCell = "text";
                }
                Label lblName = null;
                Number nb = null;
                Map.Entry me = it.next();
                log.debug(me.getKey());
                List list1 = (List)me.getValue();
                for (int i = 0; i < list1.size(); ++i) {
                    WritableSheet excelSheet = workbook.getSheet(Integer.valueOf(sSheetNumber).intValue());
                    CellFormat cellform = excelSheet.getCell(Integer.valueOf(sColNumber).intValue(), Integer.valueOf(sRowNumber).intValue()).getCellFormat();
                    if (sTypeCell.compareToIgnoreCase("text") == 0) {
                        lblName = cellform != null ? new Label(Integer.valueOf(sColNumber) + difflocation, Integer.valueOf(sRowNumber) + i, (String)list1.get(i), cellform) : new Label(Integer.valueOf(sColNumber) + difflocation, Integer.valueOf(sRowNumber) + i, (String)list1.get(i));
                    }
                    if (sTypeCell.compareToIgnoreCase("number") == 0) {
                        String value = (String)list1.get(i);
                        log.debug((Object)value);
                        Double valuedbl = Double.valueOf(value);
                        nb = cellform != null ? new Number(Integer.valueOf(sColNumber) + difflocation, Integer.valueOf(sRowNumber) + i, valuedbl.doubleValue(), cellform) : new Number(Integer.valueOf(sColNumber) + difflocation, Integer.valueOf(sRowNumber) + i, valuedbl.doubleValue());
                    }
                    try {
                        if (sTypeCell.compareToIgnoreCase("number") == 0) {
                            excelSheet.addCell(nb);
                        }
                        if (sTypeCell.compareToIgnoreCase("text") != 0) continue;
                        excelSheet.addCell(lblName);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (++itemlocation >= sLoc.length) {
                    itemlocation = sLoc.length - 1;
                    ++difflocation;
                }
                if (++itemtypecell < sTypeCellTab.length) continue;
                itemtypecell = sTypeCellTab.length - 1;
            }
        }
        return true;
    }
}

