/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.process.Comment;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WordTemplateCommentWrapper {
    private final List<Comment> commentsList;
    private UserFinder userFinder = FinderFactory.getUserFinder();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public WordTemplateCommentWrapper(List<Comment> commentsList) {
        this.commentsList = commentsList;
    }

    public String getCommentsAuthors() {
        return this.commentsList.stream().map(comment -> this.findUser((Comment)comment)).collect(Collectors.joining(";"));
    }

    private String findUser(Comment comment) {
        User user = this.userFinder.findByUserName(comment.getUserId(), new String[0]);
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getFullName())) {
            return user.getFullName();
        }
        return comment.getUserId();
    }

    public String getCommentsDates() {
        return this.commentsList.stream().map(comment -> dateFormat.format(comment.getCommentDate())).collect(Collectors.joining(";"));
    }

    public String getCommentsActivitiesNames() {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        return this.commentsList.stream().map(comment -> activityFinder.getActivity(comment.getProcessId(), comment.getActivityId(), new String[0])).map(Activity::getName).collect(Collectors.joining(";"));
    }

    public String getCommentsContents() {
        return this.commentsList.stream().map(Comment::getComment).collect(Collectors.joining(";"));
    }
}

