/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureMappings;
import com.suncode.cuf.util.collection.map.MapUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportSheetDefinition {
    private static final Logger log = LoggerFactory.getLogger(ImportSheetDefinition.class);
    private String name;
    private String[] keysOrder;
    private String[] headers;
    private InputStream input;
    private String path;
    private Map<String, ValueReader> valueReaders = new HashMap<String, ValueReader>();
    private Map<String, String> mappings;
    private String[] optionalColumns;
    private boolean shouldValidateColumns;
    private List<String> columnsToImport;

    public ImportSheetDefinition(String name) {
        this(name, null);
    }

    public ImportSheetDefinition(String name, StructureMappings structureMappings) {
        this.name = name;
        this.mappings = structureMappings == null ? null : structureMappings.getReverseColumnMappings();
        this.setOptionalColumns(structureMappings == null ? null : structureMappings.getOptionalColumns());
        this.shouldValidateColumns = structureMappings == null ? true : structureMappings.shouldValidateColumns();
    }

    public ImportSheetDefinition(String name, StructureMappings structureMappings, List<String> columnsToImport) {
        this(name, structureMappings);
        this.columnsToImport = columnsToImport;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String[] getKeysOrder() {
        if (this.keysOrder == null) {
            this.keysOrder = this.readKeysFromMappings();
            if (this.keysOrder == null) {
                throw new CUFServiceException("Can't read sheet keys");
            }
        }
        return this.keysOrder;
    }

    private String[] readKeysFromMappings() {
        String[] keys = null;
        if (this.mappings == null || this.mappings.isEmpty()) {
            log.debug("No data.");
        } else {
            keys = MapUtils.keysToArray(this.mappings);
        }
        return keys;
    }

    public void setKeysOrder(String[] keysOrder) {
        this.keysOrder = keysOrder;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getHeaders() {
        if (this.headers == null) {
            String[] keys = this.getKeysOrder();
            this.headers = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String header;
                String key = keys[i];
                this.headers[i] = header = this.getHeader(key);
            }
        }
        return this.headers;
    }

    private String getHeader(String key) {
        if (this.mappings != null) {
            return this.mappings.get(key);
        }
        return key;
    }

    public Map<String, ValueReader> getValueReaders() {
        return this.valueReaders;
    }

    public void setValueReaders(Map<String, ValueReader> valueReaders) {
        this.valueReaders = valueReaders;
    }

    public void setValueWriter(String key, ValueReader valueReader) {
        this.valueReaders.put(key, valueReader);
    }

    public String[] getOptionalColumns() {
        return this.optionalColumns;
    }

    public void setOptionalColumns(String[] optionalColumns) {
        this.optionalColumns = optionalColumns;
    }

    public boolean shouldValidateColumns() {
        return this.shouldValidateColumns;
    }

    public List<String> getColumnsToImport() {
        return this.columnsToImport;
    }
}

