/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileSaver;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class StoreDocumentBytes
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(StoreDocumentBytes.class);

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"********** StoreDocumentBytes Servlet **********");
        PrintWriter out = null;
        ServletInputStream servletInputStream = null;
        String sFileId = "-1";
        Object bytes = null;
        String tempPath = "";
        String tempFileLocation = "";
        File uploadedFile = null;
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            String processId = request.getParameter("processId");
            String activityId = request.getParameter("activityId");
            String docClassName = request.getParameter("docClassName");
            String orgFileName = request.getParameter("fileName");
            String description = request.getParameter("description");
            String newVersion = request.getParameter("newVersion");
            boolean bNewVersion = false;
            String uploader = request.getParameter("uploader");
            String hmMapping = request.getParameter("hmMapping");
            servletInputStream = request.getInputStream();
            log.debug((Object)"wczytano parametry");
            if (Tools.isNullOrEmpty((String)processId)) {
                log.debug((Object)"brak processId");
                throw new CUFException("Brak identyfikatora procesu");
            }
            if (Tools.isNullOrEmpty((String)activityId)) {
                log.debug((Object)"brak activityId");
                throw new CUFException("Brak identyfikatora zadania");
            }
            if (servletInputStream == null) {
                log.debug((Object)"brak strumienia");
                throw new CUFException("Brak strumienia danych pliku");
            }
            if (description == null) {
                description = "";
            }
            if (hmMapping == null) {
                hmMapping = "";
            }
            if (!Tools.isNullOrEmpty((String)newVersion)) {
                bNewVersion = Boolean.parseBoolean(newVersion);
            }
            if (Tools.isNullOrEmpty((String)uploader) || !uga.doesUserExist(uploader)) {
                uploader = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            }
            log.debug((Object)"wczytano parametry");
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            FileSaver saver = fs.getFileSaver();
            DocumentClassService dcs = ServiceFactory.getDocumentClassService();
            DocumentClass dc = dcs.getDocumentClass(docClassName, new String[0]);
            log.debug((Object)("pobrano klase: " + dc.getName()));
            log.debug((Object)"Rozpoczynam dodawanie pliku");
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(dc.getId());
            fd.setFileName(orgFileName);
            fd.setDescription(description);
            fd.setUserName(uploader);
            fd.setInputStream((InputStream)servletInputStream);
            fd.setProcessId(processId);
            fd.setActivityId(activityId);
            WfFile file = saver.addFile(fd);
            sFileId = String.valueOf(file.getId());
            log.debug((Object)("Doda\u0142em plik o id: " + sFileId));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (uploadedFile != null) {
                    uploadedFile.delete();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                out = response.getWriter();
                out.println(sFileId);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static File copyBytesToFile(File uploadedDir, String orgFileName, byte[] bytes) throws Exception {
        log.trace((Object)("******************** CopyBytesToFile(File, orgFileName=" + orgFileName + ", byte[]) ********************"));
        File uploadedFile = null;
        FileOutputStream fos = null;
        try {
            boolean bFileCreated;
            uploadedFile = new File(uploadedDir + "/" + orgFileName);
            if (uploadedFile.exists()) {
                uploadedFile.delete();
            }
            if (!(bFileCreated = uploadedFile.createNewFile())) {
                throw new Exception("Nie udalo sie zapisac pliku na dysku");
            }
            fos = new FileOutputStream(uploadedFile);
            fos.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return uploadedFile;
    }
}

