/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.util;

import com.suncode.pwfl.util.logging.LoggerLevel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class CompositeLogger
implements Logger {
    private List<ThresholdLogger> loggers = new ArrayList<ThresholdLogger>();

    public void addLogger(Logger log, LoggerLevel level) {
        this.loggers.add(new ThresholdLogger(log, level));
    }

    protected List<ThresholdLogger> getLoggers() {
        return this.loggers;
    }

    private List<Logger> getLoggers(LoggerLevel minLevel) {
        ArrayList<Logger> loggers = new ArrayList<Logger>();
        for (ThresholdLogger log : this.getLoggers()) {
            if (!log.isEnabled(minLevel)) continue;
            loggers.add(log.logger);
        }
        return loggers;
    }

    public String getName() {
        return null;
    }

    public boolean isTraceEnabled() {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            if (!log.isTraceEnabled()) continue;
            return true;
        }
        return false;
    }

    public void trace(String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            if (!log.isTraceEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void trace(Marker marker, String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.trace(marker, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            if (!log.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    public void debug(String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            if (!log.isDebugEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void debug(Marker marker, String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.DEBUG)) {
            log.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            if (!log.isInfoEnabled()) continue;
            return true;
        }
        return false;
    }

    public void info(String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(msg);
        }
    }

    public void info(String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(msg, t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            if (!log.isInfoEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void info(Marker marker, String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.INFO)) {
            log.info(marker, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            if (!log.isWarnEnabled()) continue;
            return true;
        }
        return false;
    }

    public void warn(String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(format, arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(format, arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(format, arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(msg, t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            if (!log.isWarnEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void warn(Marker marker, String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.WARN)) {
            log.warn(marker, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            if (!log.isErrorEnabled()) continue;
            return true;
        }
        return false;
    }

    public void error(String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(msg);
        }
    }

    public void error(String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(msg, t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            if (!log.isErrorEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void error(Marker marker, String msg) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        for (Logger log : this.getLoggers(LoggerLevel.ERROR)) {
            log.error(marker, msg, t);
        }
    }

    protected static class ThresholdLogger {
        Logger logger;
        LoggerLevel level;

        public ThresholdLogger(Logger logger, LoggerLevel level) {
            this.logger = logger;
            this.level = level;
        }

        boolean isEnabled(LoggerLevel level) {
            if (this.level == null) {
                return true;
            }
            return level.ordinal() >= this.level.ordinal();
        }
    }
}

