/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.cuf.util.TemporaryFile;
import com.suncode.cuf.util.template.WordTemplateUtil;
import com.suncode.cuf.web.dto.template.DocumentInfo;
import com.suncode.cuf.web.dto.template.WordTemplateForm;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.NoResultException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;

@Service
@Provides(value={WordTemplateService.class})
public class WordTemplateService {
    @Autowired
    private ProcessService processService;
    @Autowired
    @Qualifier(value="sharkProcessService")
    private ProcessService sharkProcessService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private DocumentTemplateService templateService;
    private static ConcurrentMap<UUID, InputStream> oneTimeDocuments = new ConcurrentHashMap<UUID, InputStream>();

    private void generate(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format, String templatePath) throws NoResultException {
        Process process = this.sharkProcessService.getProcess(processId, new String[]{"processDefinition"});
        ProcessDefinition processDefinitionEntity = process.getProcessDefinition();
        String processDefId = processDefinitionEntity.getProcessDefinitionId();
        if (StringUtils.isBlank((String)templatePath)) {
            DocumentTemplateTable template = this.templateService.getByNameAndProcess(templateName, processDefId, new String[0]);
            if (template == null) {
                throw new IllegalArgumentException("Document template with name [" + templateName + "] not found");
            }
            templatePath = template.getTemplatePath();
        }
        String outputPath = output.getAbsolutePath();
        Map<String, Object> context = this.populateContext(processId, activityId, mappings);
        PrepeareDoc.prepareDocument(templatePath, outputPath, context, null, "@", processId, null, null, format == OutputFormat.PDF);
    }

    private void generate(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format, Long fileId) throws NoResultException {
        String outputPath = output.getAbsolutePath();
        Map<String, Object> context = this.populateContext(processId, activityId, mappings);
        PrepeareDoc.prepareDocument(outputPath, context, null, "@", processId, null, null, format == OutputFormat.PDF, fileId);
    }

    public void generateForProcess(File output, String templateName, String processId, OutputFormat format) {
        this.generate(output, templateName, processId, null, null, format, "");
    }

    public void generateForProcess(File output, String templateName, String processId, Map<String, Object> mappings, OutputFormat format) {
        this.generate(output, templateName, processId, null, mappings, format, "");
    }

    public void generateForProcess(File output, String templateName, String processId, Map<String, Object> mappings, OutputFormat format, String templatePath) {
        this.generate(output, templateName, processId, null, mappings, format, templatePath);
    }

    public void generateForProcess(File output, String templateName, String processId, Map<String, Object> mappings, OutputFormat format, long fileId) {
        this.generate(output, templateName, processId, null, mappings, format, fileId);
    }

    public void generateForActivity(File output, String templateName, String processId, String activityId, OutputFormat format) {
        this.generate(output, templateName, processId, activityId, null, format, "");
    }

    public void generateForActivity(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format) {
        this.generate(output, templateName, processId, activityId, mappings, format, "");
    }

    public void generateForActivity(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format, String templatePath) {
        this.generate(output, templateName, processId, activityId, mappings, format, templatePath);
    }

    public void generateForActivity(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format, long fileId) {
        this.generate(output, templateName, processId, activityId, mappings, format, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentInfo generateForActivityAndAttach(WordTemplateForm config) throws Exception {
        DocumentInfo doc = new DocumentInfo();
        File document = TemporaryFile.create();
        try {
            this.generateForActivity(config, document);
            WfDocument wfDoc = WordTemplateUtil.archiveAndAttachToProcess(document, config.getProcessId(), config.getActivityId(), config.getDocumentClass(), config.getTemplate(), config.getFormat(), config.isAttachToProcess(), config.isNewVersion(), config.getDocumentName());
            doc.setId(wfDoc.getFile().getId());
        }
        finally {
            FileUtils.deleteQuietly((File)document);
        }
        return doc;
    }

    private void generateForActivity(WordTemplateForm config, File document) {
        if (config.getFileId() != null) {
            this.generateForActivity(document, config.getTemplate(), config.getProcessId(), config.getActivityId(), config.getMappings(), config.getFormat(), config.getFileId());
        } else {
            this.generateForActivity(document, config.getTemplate(), config.getProcessId(), config.getActivityId(), config.getMappings(), config.getFormat(), config.getTemplatePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentInfo generateAndAttach(WordTemplateForm config) throws Exception {
        DocumentInfo doc = new DocumentInfo();
        File document = TemporaryFile.create();
        try {
            this.generateForProcess(config, document);
            WfDocument wfDoc = WordTemplateUtil.archiveAndAttachToProcess(document, config.getProcessId(), config.getActivityId(), config.getDocumentClass(), config.getTemplate(), config.getFormat(), config.isAttachToProcess(), config.isNewVersion(), config.getDocumentName());
            doc.setId(wfDoc.getFile().getId());
        }
        finally {
            FileUtils.deleteQuietly((File)document);
        }
        return doc;
    }

    private void generateForProcess(WordTemplateForm config, File document) {
        if (config.getFileId() != null) {
            this.generateForProcess(document, config.getTemplate(), config.getProcessId(), config.getMappings(), config.getFormat(), config.getFileId());
        } else {
            this.generateForProcess(document, config.getTemplate(), config.getProcessId(), config.getMappings(), config.getFormat(), config.getTemplatePath());
        }
    }

    public String generateDocumentUUID(WordTemplateForm config) throws IOException {
        File document = TemporaryFile.create();
        this.generateForProcess(config, document);
        FileInputStream is = new FileInputStream(document);
        UUID id = UUID.randomUUID();
        oneTimeDocuments.put(id, is);
        return id.toString();
    }

    public InputStream getTemporaryDocument(String uuid) throws IOException {
        UUID id = UUID.fromString(uuid);
        InputStream is = (InputStream)oneTimeDocuments.remove(id);
        if (is == null) {
            throw new HttpServerErrorException(HttpStatus.NOT_FOUND);
        }
        return is;
    }

    private Map<String, Object> populateContext(String processId, String activityId, Map<String, Object> mappings) {
        Map context = activityId != null ? this.activityService.getActivityContext(processId, activityId) : this.processService.getProcessContext(processId);
        if (mappings != null && !mappings.isEmpty()) {
            context.putAll(mappings);
        }
        return context;
    }

    public static enum OutputFormat {
        PDF,
        DOCX;

    }
}

