/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.i18n.I18N;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.plusmpm.util.workflowData.ProcessData;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DeleteFinishedProcesses
extends AbstractAdvancedTask {
    public Logger log = Logger.getLogger(DeleteFinishedProcesses.class);
    private volatile double progress = 0.0;

    public Double getProgress() {
        return this.progress;
    }

    @AdvancedTask(name="DeleteFinishedProcesses", description="DeleteFinishedProcesses_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void DeleteProcesses(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefIdDFP") String sProcessDefId, @TaskParam(name="advancedTask.paramName.finishDateFrom", description="advancedTask.paramDesc.finishDateFrom") String sFinishDateFrom, @TaskParam(name="advancedTask.paramName.daysBeforeNow", description="advancedTask.paramDesc.daysBeforeNow") String sDaysBeforeNow, @TaskParam(name="advancedTask.paramName.allClosedStates", description="advancedTask.paramDesc.allClosedStates") String sAllClosedStates, @TaskParam(name="advancedTask.paramName.whenFinish", description="advancedTask.paramDesc.whenFinish") String sWhenFinish) {
        this.log.debug((Object)("************************ DeleteProcesses(sProcessDefId=" + sProcessDefId + ", sFinishDateFrom=" + sFinishDateFrom + ", sDaysBeforeNow=" + sDaysBeforeNow + ", sAllClosedStates=" + sAllClosedStates + ", sWhenFinish=" + sWhenFinish + ") *************************"));
        this.DeleteProcesses(sProcessDefId, sFinishDateFrom, sDaysBeforeNow, sAllClosedStates, sWhenFinish, "TRUE", "1");
    }

    public void DeleteProcesses(String sProcessDefId, String sFinishDateFrom, String sDaysBeforeNow, String sAllClosedStates, String sWhenFinish, String withIdx, String minuteIntervals) {
        long startTime;
        block18: {
            this.log.debug((Object)("************************ DeleteProcesses(sProcessDefId=" + sProcessDefId + ", sFinishDateFrom=" + sFinishDateFrom + ", sDaysBeforeNow=" + sDaysBeforeNow + ", sAllClosedStates=" + sAllClosedStates + ", sWhenFinish=" + sWhenFinish + ", withIdx=" + withIdx + ", minuteIntervals=" + minuteIntervals + ") *************************"));
            startTime = new Date().getTime();
            String lastValueOfParam = sFinishDateFrom;
            String lastCorrectDeleteTime = sFinishDateFrom;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int iMinuteIntervals = 1;
            this.progress = 0.1;
            try {
                int iDaysBeforeNow = 0;
                try {
                    iDaysBeforeNow = Integer.valueOf(sDaysBeforeNow);
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    throw new CUFException("Niepoprawny format danych trzeciego parametru okreslajacego ilosc dni wstecz. Parametr musi byc wartoscia liczbowa");
                }
                try {
                    sdf.parse(sFinishDateFrom);
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    throw new CUFException("Drugi parametr zadania okreslajacy poczatkowa wyszukiwania ma niepoprawny format. Wymagany format to yyyy-MM-dd HH:mm:ss");
                }
                if (Tools.isNullOrEmpty((String)minuteIntervals)) {
                    throw new CUFException("Nie podano parametru przedzialu minutowego");
                }
                try {
                    iMinuteIntervals = Integer.parseInt(minuteIntervals);
                    if (iMinuteIntervals <= 0) {
                        throw new CUFException("Parametr przedzialu minutowego musi byc wartoscia dodatnia");
                    }
                }
                catch (NumberFormatException e) {
                    taskLog.error((Object)e.getMessage());
                    throw new CUFException("Parametr przedzialu minutowego musi byc calkowita wartoscia liczbowa");
                }
                String sCurrentDate = sdf.format(new Date(startTime));
                String sFinishDateTo = this.changeDate(sCurrentDate, -1 * iDaysBeforeNow, true);
                lastCorrectDeleteTime = this.ExecuteDeleteProcesses(sProcessDefId, sFinishDateFrom, sFinishDateTo, sAllClosedStates, sWhenFinish, withIdx, iMinuteIntervals, startTime);
                this.progress = 0.6;
                try {
                    List ListOfScheduledTasksTable = ScheduledTasksMethods.getAllScheduledTasks();
                    DeleteFinishedProcesses object = new DeleteFinishedProcesses();
                    String thisFunctionName = "";
                    StackTraceElement[] e = Thread.currentThread().getStackTrace();
                    if (e != null && e.length > 1) {
                        thisFunctionName = e[1].getMethodName();
                    }
                    String thisPackageName = ((Object)((Object)object)).getClass().getPackage().getName();
                    String thisClassName = ((Object)((Object)object)).getClass().getName();
                    if (thisClassName.lastIndexOf(46) > 0) {
                        thisClassName = thisClassName.substring(thisClassName.lastIndexOf(46) + 1);
                    }
                    String thisTask = thisPackageName + "." + thisClassName + "." + thisFunctionName;
                    if (ListOfScheduledTasksTable == null) break block18;
                    for (ScheduledTasksTable scheduledTasksTable : ListOfScheduledTasksTable) {
                        if (scheduledTasksTable == null) continue;
                        String className = scheduledTasksTable.getClass_name();
                        String methodName = scheduledTasksTable.getMethod_name();
                        String task = className + "." + methodName;
                        boolean processing = scheduledTasksTable.getIs_processing();
                        if (!processing || !thisTask.equalsIgnoreCase(task)) continue;
                        long taskId = scheduledTasksTable.getId();
                        List<ScheduledTasksParametersTable> ListOfParams = this.getListOfParams(taskId);
                        if (ListOfParams != null) {
                            for (ScheduledTasksParametersTable scheduledTasksParametersTable : ListOfParams) {
                                if (scheduledTasksParametersTable == null) continue;
                                int pos = scheduledTasksParametersTable.getParameter_position();
                                String value = scheduledTasksParametersTable.getParameter_value();
                                if (value == null || !value.equalsIgnoreCase(lastValueOfParam) || pos != 1) continue;
                                scheduledTasksParametersTable.setParameter_value(lastCorrectDeleteTime);
                                ScheduledTasksMethods.changeScheduledTaskParameter((ScheduledTasksParametersTable)scheduledTasksParametersTable);
                                this.log.debug((Object)("Zmieniono parametr wykonywania zadania zaplanowanego DeleteProcesses. Parametr od kiedy szukac zakonczone procesy zmieniony na czas ostatniego poprawnego usuwania: " + lastCorrectDeleteTime));
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (CUFException e) {
                taskLog.error((Object)e.getMessage());
                this.log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long stopTime = new Date().getTime();
        this.progress = 1.0;
        this.log.debug((Object)("Czas wykonywania zadania zaplanowanego DeleteProcesses: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="DeleteProcessesBetweenDates", description="DeleteProcessesBetweenDates_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void DeleteProcessesBetweenDates(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefIdDFP") String sProcessDefId, @TaskParam(name="advancedTask.paramName.finishDateFrom", description="advancedTask.paramDesc.finishDateFrom") String sFinishDateFrom, @TaskParam(name="advancedTask.paramName.finishDateTo", description="advancedTask.paramDesc.finishDateTo") String sFinishDateTo, @TaskParam(name="advancedTask.paramName.allClosedStates", description="advancedTask.paramDesc.allClosedStates") String sAllClosedStates, @TaskParam(name="advancedTask.paramName.whenFinish", description="advancedTask.paramDesc.whenFinish") String sWhenFinish) {
        this.log.debug((Object)("************************ DeleteProcessesBetweenDates(sProcessDefId=" + sProcessDefId + ", sFinishDateFrom=" + sFinishDateFrom + ", sFinishDateTo=" + sFinishDateTo + ", sAllClosedStates=" + sAllClosedStates + ", sWhenFinish=" + sWhenFinish + " ) *************************"));
        this.DeleteProcessesBetweenDates(sProcessDefId, sFinishDateFrom, sFinishDateTo, sAllClosedStates, sWhenFinish, "TRUE", "1");
    }

    public void DeleteProcessesBetweenDates(String sProcessDefId, String sFinishDateFrom, String sFinishDateTo, String sAllClosedStates, String sWhenFinish, String withIdx, String minuteIntervals) {
        long startTime;
        block18: {
            this.log.debug((Object)("************************ DeleteProcessesBetweenDates(sProcessDefId=" + sProcessDefId + ", sFinishDateFrom=" + sFinishDateFrom + ", sFinishDateTo=" + sFinishDateTo + ", sAllClosedStates=" + sAllClosedStates + ", sWhenFinish=" + sWhenFinish + ", withIdx=" + withIdx + ", minuteIntervals=" + minuteIntervals + ") *************************"));
            startTime = new Date().getTime();
            this.progress = 0.0;
            String lastCorrectDeleteTime = sFinishDateFrom;
            String lastValueOfParam = sFinishDateFrom;
            int iMinuteIntervals = 1;
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date dateFrom = sdf.parse(sFinishDateFrom);
                Date dateTo = sdf.parse(sFinishDateTo);
                if (dateFrom == null || dateTo == null) {
                    throw new CUFException("Niepoprawny format dat w parametrach zadania zaplanowanego");
                }
                if (Tools.isNullOrEmpty((String)minuteIntervals)) {
                    throw new CUFException("Nie podano parametru przedzialu minutowego");
                }
                try {
                    iMinuteIntervals = Integer.parseInt(minuteIntervals);
                    if (iMinuteIntervals <= 0) {
                        throw new CUFException("Parametr przedzialu minutowego musi byc wartoscia dodatnia");
                    }
                }
                catch (NumberFormatException e) {
                    taskLog.error((Object)e.getMessage());
                    throw new CUFException("Parametr przedzialu minutowego musi byc calkowita wartoscia liczbowa");
                }
                Long timeFrom = dateFrom.getTime();
                Long timeTo = dateTo.getTime();
                Long durationCheck = new Long(-1L);
                Long minuteIntervalsInMillis = new Long(iMinuteIntervals * 60 * 1000);
                if (timeFrom != null && timeTo != null) {
                    durationCheck = timeTo - timeFrom;
                }
                if (durationCheck <= 0L) {
                    throw new CUFException("Data koncowa wyszukiwania jest wczesniejsza lub taka sama jak data poczatkowa. Sprawdz parametry zadania");
                }
                if (minuteIntervalsInMillis > durationCheck) {
                    throw new CUFException("Przedzial minutowy jest dluzszy niz przedzial czasowy okreslony za pomoca dat");
                }
                this.progress = 0.2;
                lastCorrectDeleteTime = this.ExecuteDeleteProcesses(sProcessDefId, sFinishDateFrom, sFinishDateTo, sAllClosedStates, sWhenFinish, withIdx, iMinuteIntervals, startTime);
                this.progress = 0.7;
                try {
                    List ListOfScheduledTasksTable = ScheduledTasksMethods.getAllScheduledTasks();
                    DeleteFinishedProcesses object = new DeleteFinishedProcesses();
                    String thisFunctionName = "";
                    StackTraceElement[] e = Thread.currentThread().getStackTrace();
                    if (e != null && e.length > 1) {
                        thisFunctionName = e[1].getMethodName();
                    }
                    String thisPackageName = ((Object)((Object)object)).getClass().getPackage().getName();
                    String thisClassName = ((Object)((Object)object)).getClass().getName();
                    if (thisClassName.lastIndexOf(46) > 0) {
                        thisClassName = thisClassName.substring(thisClassName.lastIndexOf(46) + 1);
                    }
                    String thisTask = thisPackageName + "." + thisClassName + "." + thisFunctionName;
                    if (ListOfScheduledTasksTable == null) break block18;
                    for (ScheduledTasksTable scheduledTasksTable : ListOfScheduledTasksTable) {
                        if (scheduledTasksTable == null) continue;
                        String className = scheduledTasksTable.getClass_name();
                        String methodName = scheduledTasksTable.getMethod_name();
                        if (Tools.isNullOrEmpty((String)className) || Tools.isNullOrEmpty((String)methodName)) continue;
                        String task = className + "." + methodName;
                        boolean processing = scheduledTasksTable.getIs_processing();
                        if (!processing || !thisTask.equalsIgnoreCase(task)) continue;
                        long taskId = scheduledTasksTable.getId();
                        List<ScheduledTasksParametersTable> ListOfParams = this.getListOfParams(taskId);
                        if (ListOfParams != null) {
                            for (ScheduledTasksParametersTable scheduledTasksParametersTable : ListOfParams) {
                                if (scheduledTasksParametersTable == null) continue;
                                int pos = scheduledTasksParametersTable.getParameter_position();
                                String value = scheduledTasksParametersTable.getParameter_value();
                                if (value == null || !value.equalsIgnoreCase(lastValueOfParam) || pos != 1) continue;
                                scheduledTasksParametersTable.setParameter_value(lastCorrectDeleteTime);
                                ScheduledTasksMethods.changeScheduledTaskParameter((ScheduledTasksParametersTable)scheduledTasksParametersTable);
                                this.log.debug((Object)("Zmieniono parametr wykonywania zadania zaplanowanego DeleteProcessesBetweenDates. Parametr od kiedy szukac zakonczone procesy zmieniony na czas ostatniego poprawnego usuwania: " + lastCorrectDeleteTime));
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (CUFException e) {
                taskLog.error((Object)e.getMessage());
                this.log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long stopTime = new Date().getTime();
        this.progress = 1.0;
        this.log.debug((Object)("Czas wykonywania zadania zaplanowanego DeleteProcessesBetweenDates: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ExecuteDeleteProcesses(String sProcessDefId, String sFinishDateFrom, String sFinishDateTo, String sAllClosedStates, String sWhenFinish, String withIdx, int iMinuteIntervals, long startTime) {
        this.log.debug((Object)("************************ ExecuteDeleteProcesses(sProcessDefId=" + sProcessDefId + ", sFinishDateFrom=" + sFinishDateFrom + ", sFinishDateTo=" + sFinishDateTo + ", sAllClosedStates=" + sAllClosedStates + ", sWhenFinish=" + sWhenFinish + ", withIdx=" + withIdx + ", iMinuteIntervals=" + iMinuteIntervals + ", startTime=" + String.valueOf(startTime) + ") *************************"));
        SharkTransaction st = null;
        AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
        Long lWhenFinish = new Long(-1L);
        int howManyProcessesDeleted = 0;
        int oneCommitDeleted = 0;
        boolean errorDuringDeleting = false;
        boolean bWithIdx = true;
        String lastCorrectDeleteTime = sFinishDateFrom;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dControlDate = null;
        try {
            dControlDate = sdf.parse(sFinishDateTo);
            ProcessData processData = new ProcessData();
            Map processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
            if (processDefIdsAndNamesMap == null || processDefIdsAndNamesMap.size() == 0) {
                throw new CUFException("Brak identyfikatorow definicji procesow w systemie");
            }
            Iterator processDefIdIterator = processDefIdsAndNamesMap.keySet().iterator();
            boolean bProcDefIdExists = false;
            while (processDefIdIterator.hasNext()) {
                String oneProcDefId = (String)processDefIdIterator.next();
                if (!oneProcDefId.equals(sProcessDefId)) continue;
                bProcDefIdExists = true;
                break;
            }
            if (!bProcDefIdExists) {
                throw new CUFException("W systemie nie istnieje proces o identyfikatorze definicji " + sProcessDefId);
            }
            WorkflowProcess wp = null;
            Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(sProcessDefId);
            HashMap<String, String> hmAdSearchVar = new HashMap<String, String>();
            List<AdvanceSearchResult> processes = null;
            wp = pack.getWorkflowProcess(sProcessDefId);
            if (wp == null) {
                throw new CUFException("Proces o identyfikatorze definicji " + sProcessDefId + " nie istnieje");
            }
            this.log.debug((Object)("Proces o identyfikatorze definicji " + sProcessDefId + " istnieje"));
            int iIntervals = this.getTimeDifference(sFinishDateFrom, sFinishDateTo, iMinuteIntervals);
            if (iIntervals <= 0) {
                throw new CUFException("Data zakonczenia wyszukiania zakonczonych procesow jest wczesniejsza lub taka sama jak data rozpoczecia wyszukiwania");
            }
            try {
                String[] whenFinishSplit = sWhenFinish.split(":");
                Long[] whenFinishSplitValues = new Long[3];
                int counterForTable = 0;
                for (String oneTime : whenFinishSplit) {
                    if (Tools.isNullOrEmpty((String)oneTime)) {
                        oneTime = "0";
                    }
                    Long value = Long.valueOf(oneTime);
                    whenFinishSplitValues[counterForTable] = counterForTable != 0 && value > 59L ? new Long(59L) : value;
                    ++counterForTable;
                }
                lWhenFinish = 3600L * whenFinishSplitValues[0] + 60L * whenFinishSplitValues[1] + whenFinishSplitValues[2];
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                lWhenFinish = new Long(3600L);
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!Tools.isNullOrEmpty((String)withIdx)) {
                bWithIdx = Boolean.parseBoolean(withIdx);
            }
            boolean bContinue = true;
            this.log.debug((Object)("Zakonczone procesy wyszukiwane miedzy datami: od " + sFinishDateFrom + " do " + sFinishDateTo));
            this.log.debug((Object)("Liczba przedzialow czasowych: " + iIntervals));
            this.log.debug((Object)("Przyblizony maksymalny czas trwania zadania zaplanowanego: " + CUFTools.plannedTaskDuration(1000L * lWhenFinish)));
            String sActualFinishDateTo = this.changeDate(sFinishDateFrom, iMinuteIntervals, false);
            hmAdSearchVar.put("procDefId", sProcessDefId);
            while (iIntervals > 0 && bContinue) {
                long currentTimeExternal;
                boolean bStillHasTimeExternal;
                st = null;
                oneCommitDeleted = 0;
                processes = null;
                hmAdSearchVar.put("procStateSelect", "closed.completed");
                hmAdSearchVar.put("procFinish", sFinishDateFrom + ";" + sActualFinishDateTo);
                this.log.debug((Object)("Trwa wyszukiwanie procesow zakonczonych od " + sFinishDateFrom + " do " + sActualFinishDateTo + " o identyfikatorze definicji " + sProcessDefId));
                if (bWithIdx) {
                    processes = this.createSearch(hmAdSearchVar, wp);
                    if (sAllClosedStates.equalsIgnoreCase("TRUE")) {
                        hmAdSearchVar.put("procStateSelect", "closed.terminated");
                        List<AdvanceSearchResult> processesTerminated = this.createSearch(hmAdSearchVar, wp);
                        if (processesTerminated != null && processesTerminated.size() > 0) {
                            if (processes == null) {
                                processes = new ArrayList<AdvanceSearchResult>();
                            }
                            for (AdvanceSearchResult oneTerminatedProcess : processesTerminated) {
                                processes.add(oneTerminatedProcess);
                            }
                        }
                        hmAdSearchVar.put("procStateSelect", "closed.aborted");
                        List<AdvanceSearchResult> processesAborted = this.createSearch(hmAdSearchVar, wp);
                        if (processesAborted != null && processesAborted.size() > 0) {
                            if (processes == null) {
                                processes = new ArrayList<AdvanceSearchResult>();
                            }
                            for (AdvanceSearchResult oneAbortedProcess : processesAborted) {
                                processes.add(oneAbortedProcess);
                            }
                        }
                    }
                    processes = this.eliminateDuplicateProcesses(processes);
                } else {
                    Connection con = null;
                    String query = "SELECT proctab.id as processid from processes as proctab JOIN processdefinitions as procdeftab ON (procdeftab.objectid=proctab.processdefinition) where procdeftab.processdefinitionid = '" + sProcessDefId + "'";
                    ArrayList<HashMap<String, String>> results = null;
                    try {
                        con = InternalDataBase.connect();
                        if (con != null) {
                            query = sAllClosedStates.equalsIgnoreCase("TRUE") ? query + " AND (proctab.state=1000006 OR proctab.state=1000008 OR proctab.state=1000010)" : query + " AND proctab.state=1000006";
                            Date d1 = sdf.parse(sFinishDateFrom);
                            Date d2 = sdf.parse(sActualFinishDateTo);
                            Long time1 = d1.getTime();
                            Long time2 = d2.getTime();
                            results = InternalDataBase.executeQuery(con, query = query + " AND proctab.laststatetime >= " + time1.toString() + " AND proctab.laststatetime <= " + time2.toString());
                            if (results != null && results.size() > 0) {
                                processes = new ArrayList<AdvanceSearchResult>();
                                for (HashMap<String, String> oneProcess : results) {
                                    String oneProcessId = oneProcess.get("processid");
                                    AdvanceSearchResult advanceSearchResult = new AdvanceSearchResult();
                                    advanceSearchResult.setProcessId(oneProcessId);
                                    processes.add(advanceSearchResult);
                                }
                            }
                        } else {
                            this.log.warn((Object)"Brak polaczenia z wewnetrzna baza danych");
                        }
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        InternalDataBase.distconnect(con);
                    }
                }
                if (processes != null && processes.size() > 0) {
                    this.log.debug((Object)("Znaleziono " + processes.size() + " procesow zakonczonych od " + sFinishDateFrom + " do " + sActualFinishDateTo + " o identyfikatorze definicji " + sProcessDefId));
                    ExecutionAdministration ea = null;
                    try {
                        st = Shark.getInstance().createTransaction();
                    }
                    catch (Throwable throwable) {
                        taskLog.error((Object)throwable.getMessage());
                        this.log.error((Object)throwable.getMessage(), throwable);
                        try {
                            Shark.getInstance().emptyCaches(st);
                        }
                        catch (Exception e1) {
                            taskLog.error((Object)e1.getMessage());
                            this.log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                        try {
                            st.rollback();
                        }
                        catch (Exception e2) {
                            taskLog.error((Object)e2.getMessage());
                            this.log.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    try {
                        String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
                        String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
                        ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                        ea.connect(st, username, password, "KlientTestowy", null);
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    for (int i = 0; i < processes.size(); ++i) {
                        try {
                            long currentTimeInternal;
                            boolean bStillHasTimeInternal;
                            block75: {
                                AdvanceSearchResult advanceSearchResult = processes.get(i);
                                if (advanceSearchResult != null) {
                                    String processId = advanceSearchResult.getProcessId();
                                    if (st != null && ea != null && !Tools.isNullOrEmpty((String)processId)) {
                                        String sProcessCreateTime = "'brak danych'";
                                        Long processCreateTime = null;
                                        try {
                                            try {
                                                processCreateTime = adminMisc.getProcessCreatedTime(st, processId);
                                            }
                                            catch (BaseException e) {
                                                taskLog.error((Object)e.getMessage());
                                            }
                                            if (processCreateTime != null) {
                                                sProcessCreateTime = sdf.format(new Date(processCreateTime));
                                            }
                                            ea.deleteClosedProcess(st, processId);
                                            ++howManyProcessesDeleted;
                                            ++oneCommitDeleted;
                                            this.log.debug((Object)("Proces o identyfikatorze " + processId + " utworzony " + sProcessCreateTime + " zostal usuniety"));
                                            boolean bRet = this.deleteProcessVariableValuesFromDB(ea, adminMisc, processId);
                                            if (bRet) {
                                                this.log.debug((Object)("Wartosci zmiennych procesu o identyfikatorze " + processId + " zostaly usuniete"));
                                                break block75;
                                            }
                                            this.log.debug((Object)("Blad podczas usuwania wartosci zmiennych procesu o identyfikatorze " + processId));
                                        }
                                        catch (Exception e) {
                                            taskLog.error((Object)e.getMessage());
                                            this.log.debug((Object)("Proces o identyfikatorze " + processId + " utworzony " + sProcessCreateTime + " nie zostal usuniety. Wystapil blad usuwania"));
                                            this.log.error((Object)e.getMessage(), (Throwable)e);
                                            errorDuringDeleting = true;
                                        }
                                    } else {
                                        this.log.debug((Object)("Proces o identyfikatorze " + processId + " nie zostanie usuniety. Brak uprawnien administratorskich"));
                                        errorDuringDeleting = true;
                                    }
                                }
                            }
                            if (bStillHasTimeInternal = this.stillHasTime(lWhenFinish, (currentTimeInternal = new Date().getTime()) - startTime)) continue;
                            bContinue = false;
                            break;
                        }
                        catch (Exception e) {
                            taskLog.error((Object)e.getMessage());
                            this.log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                try {
                    if (st != null) {
                        if (oneCommitDeleted > 0) {
                            this.log.debug((Object)"Komitowanie transakcji");
                        }
                        st.commit();
                        if (oneCommitDeleted > 0) {
                            this.log.debug((Object)("W transakcji usunieto " + oneCommitDeleted + " procesow"));
                        }
                    }
                }
                catch (Throwable throwable) {
                    taskLog.error((Object)throwable.getMessage());
                    this.log.error((Object)throwable.getMessage(), throwable);
                    errorDuringDeleting = true;
                    try {
                        Shark.getInstance().emptyCaches(st);
                    }
                    catch (Exception e1) {
                        taskLog.error((Object)e1.getMessage());
                        this.log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    try {
                        if (st != null) {
                            st.rollback();
                        }
                    }
                    catch (Exception e2) {
                        taskLog.error((Object)e2.getMessage());
                        this.log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
                finally {
                    try {
                        if (st != null) {
                            SharkFunctions.ClearSharkTransaction(st);
                        }
                    }
                    catch (Exception e1) {
                        taskLog.error((Object)e1.getMessage());
                        this.log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
                if (processes == null && !errorDuringDeleting || oneCommitDeleted == processes.size() && !errorDuringDeleting) {
                    lastCorrectDeleteTime = sActualFinishDateTo;
                }
                if (!(bStillHasTimeExternal = this.stillHasTime(lWhenFinish, (currentTimeExternal = new Date().getTime()) - startTime))) break;
                if (--iIntervals <= 0) continue;
                sFinishDateFrom = this.changeDate(sFinishDateFrom, iMinuteIntervals, false);
                Date dActualControlDate = sdf.parse(sActualFinishDateTo = this.changeDate(sActualFinishDateTo, iMinuteIntervals, false));
                if (!dActualControlDate.after(dControlDate)) continue;
                sActualFinishDateTo = sFinishDateTo;
                this.log.warn((Object)("Przedzial minutowy spowodowal przekroczenie koncowej daty wyszukiwania procesow (data " + sActualFinishDateTo + ". Ustawiono date koncowa na " + sFinishDateTo));
            }
            taskLog.info((Object)("Calkowita ilosc usunietych procesow: " + howManyProcessesDeleted));
            taskLog.info((Object)("Ostatni weryfikowany przedzial czasowy poszukiwania zakonczonych procesow: od " + sFinishDateFrom + " do " + sActualFinishDateTo));
            this.log.debug((Object)("Calkowita ilosc usunietych procesow: " + howManyProcessesDeleted));
            this.log.debug((Object)("Ostatni weryfikowany przedzial czasowy poszukiwania zakonczonych procesow: od " + sFinishDateFrom + " do " + sActualFinishDateTo));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            this.log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lastCorrectDeleteTime;
    }

    private List<ScheduledTasksParametersTable> getListOfParams(long id) {
        this.log.trace((Object)("************ getListOfParams(id=" + String.valueOf(id) + ") ************"));
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createQuery("from ScheduledTasksParametersTable where scheduled_task_id=:ident").setParameter("ident", (Object)id).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            taskLog.error((Object)e.getMessage());
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private List<AdvanceSearchResult> eliminateDuplicateProcesses(List<AdvanceSearchResult> processes) {
        this.log.trace((Object)"************ eliminateDuplicateProcesses(List<AdvanceSearchResult>) ************");
        ArrayList<AdvanceSearchResult> newProcesses = null;
        try {
            if (processes != null && processes.size() > 0) {
                this.log.debug((Object)"Eliminowanie duplikatow procesow");
                newProcesses = new ArrayList<AdvanceSearchResult>();
                for (AdvanceSearchResult asr : processes) {
                    if (asr == null) continue;
                    boolean bAdd = true;
                    if (newProcesses.size() == 0) {
                        newProcesses.add(asr);
                        continue;
                    }
                    String asrProcessId = asr.getProcessId();
                    for (AdvanceSearchResult newASR : newProcesses) {
                        if (newASR == null) continue;
                        String newASRProcessId = newASR.getProcessId();
                        if (Tools.isNullOrEmpty((String)asrProcessId) || Tools.isNullOrEmpty((String)newASRProcessId) || !asrProcessId.equalsIgnoreCase(newASRProcessId)) continue;
                        bAdd = false;
                        break;
                    }
                    if (!bAdd) continue;
                    newProcesses.add(asr);
                }
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return newProcesses;
    }

    private boolean stillHasTime(Long lWhenFinish, Long duration) {
        this.log.trace((Object)("************ stillHasTime(lWhenFinish=" + String.valueOf(lWhenFinish) + ", duration=" + String.valueOf(duration) + ") ************"));
        boolean res = false;
        try {
            Long seconds = TimeUnit.MILLISECONDS.toSeconds(duration);
            if (lWhenFinish != null && duration != null && seconds < lWhenFinish) {
                res = true;
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private List<AdvanceSearchResult> createSearch(HashMap<String, String> hmAdSearchVar, WorkflowProcess wp) throws Exception {
        this.log.trace((Object)"************ createSearch(HashMap<String, String>, WorkflowProcess) ************");
        I18N oMessage = new I18N();
        HashMap<String, String> hmNameProcVar = new HashMap<String, String>();
        HashMap<String, Integer> hmIdxVariables = new HashMap<String, Integer>();
        AdvanceVariableForm[] searchVariableTab = null;
        ArrayList alResult = null;
        DBManagement dbm = new DBManagement();
        Vector vCountQuery = new Vector();
        Set set = null;
        Iterator iter = null;
        hmNameProcVar.put("procDefId", oMessage.getString("n_a"));
        hmNameProcVar.put("processType", oMessage.getString("Typ_procesu"));
        hmNameProcVar.put("procName", oMessage.getString("Nazwa_procesu"));
        hmNameProcVar.put("procDescr", oMessage.getString("Opis_procesu"));
        hmNameProcVar.put("procInitiator", oMessage.getString("Inicjator"));
        hmNameProcVar.put("procStateSelect", oMessage.getString("Status_procesu"));
        hmNameProcVar.put("realizationPercent", oMessage.getString("Procent_realizacji"));
        hmNameProcVar.put("procStart", oMessage.getString("Data_rozpoczecia"));
        hmNameProcVar.put("procFinish", oMessage.getString("Data_zakonczenia"));
        hmNameProcVar.put("processDeadline", oMessage.getString("Przekroczenie_terminu_w_dn"));
        hmNameProcVar.put("taskName", oMessage.getString("Nazwa_zadania"));
        hmNameProcVar.put("taskStateSelect", oMessage.getString("Status_zadania"));
        hmNameProcVar.put("taskUser", oMessage.getString("Uzytkownik"));
        hmNameProcVar.put("taskStart", oMessage.getString("Data_rozpoczecia"));
        hmNameProcVar.put("taskFinish", oMessage.getString("Data_zakonczenia"));
        hmNameProcVar.put("taskDeadline", oMessage.getString("Przekroczenie_terminu_zadania_w_dn"));
        hmNameProcVar.put("onlyActiveTask", oMessage.getString("Tylko_zadania_do_wykonania"));
        hmNameProcVar.put("onlyLoggedUserTask", oMessage.getString("Tylko_moje_zadania"));
        hmNameProcVar.put("taskDeadlineName", oMessage.getString("Nazwa_terminu_ostatecznego"));
        hmNameProcVar.put("resultsInOneRow", oMessage.getString("Wyswietl_wyniki_zmiennych__tabelarycznych_w_jednym_wierszu"));
        hmIdxVariables.put("processType", 0);
        hmIdxVariables.put("procName", 1);
        hmIdxVariables.put("procDescr", 2);
        hmIdxVariables.put("procInitiator", 3);
        hmIdxVariables.put("procStateSelect", 4);
        hmIdxVariables.put("realizationPercent", 5);
        hmIdxVariables.put("procStart", 6);
        hmIdxVariables.put("procFinish", 7);
        hmIdxVariables.put("processDeadline", 8);
        hmIdxVariables.put("taskName", 9);
        hmIdxVariables.put("taskStateSelect", 10);
        hmIdxVariables.put("taskUser", 11);
        hmIdxVariables.put("taskStart", 12);
        hmIdxVariables.put("taskFinish", 13);
        hmIdxVariables.put("taskDeadline", 14);
        hmIdxVariables.put("onlyActiveTask", 15);
        hmIdxVariables.put("onlyLoggedUserTask", 16);
        hmIdxVariables.put("procDefId", 17);
        hmIdxVariables.put("taskDeadlineName", 18);
        hmIdxVariables.put("resultsInOneRow", 19);
        try {
            if (hmAdSearchVar.containsKey("procDefId")) {
                searchVariableTab = new AdvanceVariableForm[hmNameProcVar.size()];
                set = hmNameProcVar.entrySet();
                for (Map.Entry n : set) {
                    String VarId = (String)n.getKey();
                    int VarIdx = (Integer)hmIdxVariables.get(VarId);
                    String VarName = (String)n.getValue();
                    searchVariableTab[VarIdx] = new AdvanceVariableForm();
                    if (hmAdSearchVar.containsKey(VarId)) {
                        if (VarId.equalsIgnoreCase("procFinish")) {
                            String[] sDates = hmAdSearchVar.get(VarId).split(";");
                            searchVariableTab[VarIdx].setName(VarId);
                            searchVariableTab[VarIdx].setActive("on");
                            searchVariableTab[VarIdx].setViewname(VarName);
                            searchVariableTab[VarIdx].setValue(sDates[0]);
                            searchVariableTab[VarIdx].setValue2(sDates[1]);
                            continue;
                        }
                        searchVariableTab[VarIdx].setName(VarId);
                        searchVariableTab[VarIdx].setActive("on");
                        searchVariableTab[VarIdx].setViewname(VarName);
                        searchVariableTab[VarIdx].setValue(hmAdSearchVar.get(VarId));
                        continue;
                    }
                    searchVariableTab[VarIdx].setName(VarId);
                    searchVariableTab[VarIdx].setViewname(VarName);
                    searchVariableTab[VarIdx].setValue("");
                }
            } else {
                throw new Exception("Nie podano procDefid ");
            }
            alResult = dbm.AdavanceProcessSearch(searchVariableTab, "admin", 0, 0, 0, null, vCountQuery, false);
            return alResult;
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            this.log.debug((Object)("Blad w funkcji createSearch " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String changeDate(String sFinishDateFrom, int timeCount, boolean bIsDay) {
        this.log.trace((Object)("************ changeDate(sFinishDateFrom=" + sFinishDateFrom + ", timeCount=" + String.valueOf(timeCount) + ", bIsDay=" + String.valueOf(bIsDay) + ") ************"));
        String sFinishDateTo = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date d1 = sdf.parse(sFinishDateFrom);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d1);
            if (bIsDay) {
                calendar.add(5, timeCount);
            } else {
                calendar.add(12, timeCount);
            }
            Date result = calendar.getTime();
            sFinishDateTo = sdf.format(result);
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sFinishDateTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteProcessVariableValuesFromDB(ExecutionAdministration ea, AdminMisc am, String sProcessId) {
        this.log.trace((Object)("************ deleteProcessVariableValuesFromDB(ExecutionAdministration, AdminMisc, sProcessId=" + sProcessId + ") ************"));
        boolean bRet = false;
        DBManagement dbm = new DBManagement();
        if (!Tools.isNullOrEmpty((String)sProcessId)) {
            try {
                WfProcess wfProcess = ea.getProcess(sProcessId);
                String sProcMgrName = wfProcess.manager().name();
                String procId = am.getProcessMgrProcDefId(sProcMgrName);
                String sIndecesTable = dbm.GetProcessTypesTable(procId);
                String sQuerry = "delete from " + sIndecesTable + " where processId = '" + sProcessId + "'";
                Connection con = null;
                Statement st = null;
                try {
                    con = InternalDataBase.connect();
                    if (con != null && !con.isClosed()) {
                        st = con.createStatement();
                        st.execute(sQuerry);
                        bRet = true;
                    }
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sqle) {
                            taskLog.error((Object)sqle.getMessage());
                            this.log.error((Object)sqle.getMessage(), (Throwable)sqle);
                        }
                    }
                    InternalDataBase.distconnect(con);
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    private int getTimeDifference(String sFinishDateFrom, String sLastFinishDate, int iMinutesIntervals) {
        this.log.trace((Object)("************ getTimeDifference(sFinishDateFrom=" + sFinishDateFrom + ", sLastFinishDate=" + sLastFinishDate + ", iMinutesIntervals=" + String.valueOf(iMinutesIntervals) + ") ************"));
        int iIntervals = -1;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date d1 = sdf.parse(sFinishDateFrom);
            Date d2 = sdf.parse(sLastFinishDate);
            Long time1 = d1.getTime();
            Long time2 = d2.getTime();
            Long duration = time2 - time1;
            if (duration > 0L) {
                long seconds = TimeUnit.MILLISECONDS.toSeconds(duration);
                double tempMinutes = Double.valueOf(String.valueOf(seconds)) / new Double(60.0);
                long minutes = Math.round(tempMinutes = Math.ceil(tempMinutes));
                if (minutes > 0L) {
                    String sIntervals = String.valueOf(minutes);
                    String sMinutesIntervals = String.valueOf(iMinutesIntervals);
                    double tempIntervals = Double.valueOf(sIntervals) / Double.valueOf(sMinutesIntervals);
                    tempIntervals = Math.ceil(tempIntervals);
                    iIntervals = (int)Math.round(tempIntervals);
                }
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return iIntervals;
    }
}

