/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class UserReceiver
implements Receiver {
    private String userName;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.USER;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.userName = receiverId;
        UserService userService = ServiceFactory.getUserService();
        User user = userService.getUser(this.userName, new String[0]);
        if (!excludedEmails.contains(user.getEmail())) {
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

