/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.plannedtask.administration.helper.StructureImporter;
import com.suncode.cuf.plannedtask.administration.structure.exception.StructureValidationException;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Scope(value="prototype")
public class StructureValidator {
    private final String GROUP_DUPLICATED_MESSAGE = "W arkuszu Grupy zdefiniowano wiele grup o nazwie: \"";
    private final String ORG_UNIT_DUPLICATED_MESSAGE = "W arkuszu Jednostki organizacyjne zdefiniowano wiele jednostek o symbolu: \"";
    private final String POSITION_DUPLICATED_MESSAGE = "W arkuszu Stanowiska zdefiniowano wiele stanowisk o symbolu: \"";
    private final String USER_DUPLICATED_MESSAGE = "W arkuszu U\u017cytkownicy zdefiniowano wielu u\u017cytkownik\u00f3w o nazwie: \"";
    private final String USER_POSITION_DUPLICATED_MESSAGE = "W arkuszu U\u017cytkownicy zdefiniowano wiele stanowisk o symbolu: \"";
    private static final Pattern emailPattern = Pattern.compile("^[\\w-']+(\\.[\\w-']+)*@([A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*?\\.[A-Za-z]{2,6}|(\\d{1,3}\\.){3}\\d{1,3})(:\\d{4})?$");
    private static final Logger log = ContextLogger.getLogger(StructureImporter.class);
    @Autowired
    private UserService us;
    @Autowired
    private OrganizationalUnitFinder ouFinder;
    @Autowired
    private PositionFinder posFinder;
    Set<String> usersExisting = new HashSet<String>();
    Set<String> groupsExisting = new HashSet<String>();
    Set<String> ouExisting = new HashSet<String>();
    Set<String> posExisting = new HashSet<String>();
    Set<String> dirPos = new HashSet<String>();
    private String mode;

    public void validateStructure(StructureData sd, String mode) {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        this.mode = mode;
        this.validateGroups(sd.getGroups(), errors);
        this.validateOrgUnits(sd.getOrgUnits(), sd.getPositions(), errors);
        this.validatePosition(sd.getPositions(), errors);
        this.validateUsers(sd.getUsers(), errors);
        if (!errors.isEmpty()) {
            log.error("Znaleziona liczba b\u0142\u0119d\u00f3w: {}", (Object)errors.size());
            for (String error : errors) {
                log.error(error);
            }
            throw new StructureValidationException();
        }
    }

    private void validateUsers(List<Map<String, CellValue<String>>> list, Set<String> errors) {
        LinkedHashMultimap duplicates = LinkedHashMultimap.create();
        LinkedHashMultimap duplicatedPositions = LinkedHashMultimap.create();
        for (Map<String, CellValue<String>> map : list) {
            String value;
            CellValue<String> userName = map.get("userName");
            CellValue<String> groups = map.get("groups");
            CellValue<String> positions = map.get("positions");
            CellValue<String> email = map.get("email");
            CellValue<String> withoutActivation = map.get("withoutActivation");
            String userPositions = positions.getValue();
            if (StringUtils.hasText((String)userPositions)) {
                for (String position : userPositions.split(";")) {
                    duplicatedPositions.put((Object)position, (Object)positions.getAlias());
                }
            }
            if (!StringUtils.hasText((String)userName.getValue())) {
                errors.add("Login nie mo\u017ce by\u0107 pusty. Prosz\u0119 sprawdzi\u0107 arkusz: " + userName.getSheetName() + " kom\u00f3rka: " + userName.getAlias());
            } else {
                duplicates.put((Object)this.prepareUserName(userName, errors), (Object)userName.getAlias());
            }
            if (StringUtils.hasText((String)email.getValue()) && !this.checkMail(email)) {
                errors.add("U\u017cytkownik: " + userName.getValue() + " posiada niepoprawny email: " + email.getValue() + ". Prosz\u0119 sprawdzi\u0107 arkusz U\u017cytkownicy kom\u00f3rka: " + email.getAlias());
            }
            if (!StringUtils.hasText((String)groups.getValue())) {
                errors.add("Grupa u\u017cytkownika nie mo\u017ce by\u0107 pusta. Prosz\u0119 sprawdzi\u0107 arkusz: " + groups.getSheetName() + " kom\u00f3rka: " + groups.getAlias());
            } else {
                this.checkGroups(groups, errors);
            }
            if (StringUtils.hasText((String)positions.getValue())) {
                this.checkPositions(positions, userName.getValue(), errors);
            }
            if (withoutActivation == null || !StringUtils.hasText((String)(value = withoutActivation.getValue())) || value.equals("0") || value.equals("1")) continue;
            errors.add("Kolumna Bez aktywacji: mo\u017ce zawiera\u0107 tylko warto\u015bci 1 lub 0. Prosz\u0119 sprawdzi\u0107 arkusz: " + groups.getSheetName() + " kom\u00f3rka: " + groups.getAlias());
        }
        this.checkDuplicates((Multimap<String, String>)duplicates, "W arkuszu U\u017cytkownicy zdefiniowano wielu u\u017cytkownik\u00f3w o nazwie: \"", errors);
        this.checkDuplicates((Multimap<String, String>)duplicatedPositions, "W arkuszu U\u017cytkownicy zdefiniowano wiele stanowisk o symbolu: \"", errors);
    }

    private String prepareUserName(CellValue<String> userName, Set<String> errors) {
        String[] splitted = userName.getValue().split("/", -1);
        this.validateSplittedName(splitted, userName.getAlias(), errors);
        if (splitted.length == 2) {
            return splitted[0] + "/" + splitted[1].toLowerCase();
        }
        return userName.getValue().toLowerCase();
    }

    private void validateSplittedName(String[] name, String alias, Set<String> errors) {
        if (name.length == 2) {
            if (!StringUtils.hasText((String)name[0]) || !StringUtils.hasText((String)name[1])) {
                errors.add("Niepoprawna nazwa u\u017cytkownika domenowego. Prosz\u0119 sprawdzi\u0107 arkusz: U\u017cytkownicy kom\u00f3rka: " + alias);
            }
        } else if (name.length > 2) {
            errors.add("Niepoprawna nazwa u\u017cytkownika domenowego. Prosz\u0119 sprawdzi\u0107 arkusz: U\u017cytkownicy kom\u00f3rka: " + alias);
        }
    }

    private void checkPositions(CellValue<String> positions, String userName, Set<String> errors) {
        String[] symbols;
        for (String symbol : symbols = positions.getValue().split(";")) {
            if (!this.positionExist(symbol)) {
                errors.add("Nie znaleziono stanowiska: \"" + symbol + "\" w arkuszu: " + positions.getSheetName() + ". Prosz\u0119 sprawdzi\u0107 kom\u00f3rk\u0119: " + positions.getAlias());
            }
            if (!"APPEND".equals(this.mode)) continue;
            this.checkPositionAvailable(positions, symbol, userName, errors);
        }
    }

    private void checkPositionAvailable(CellValue<String> positions, String symbol, String user, Set<String> errors) {
        Position position = this.posFinder.findBySymbol(symbol, new String[]{"user"});
        if (position == null || position.getUser() == null || user.equals(position.getUser().getUserName())) {
            return;
        }
        String username = position.getUser().getUserName();
        errors.add("Stanowisko \"" + symbol + "\" przypisane do u\u017cytkownika w arkuszu \"" + positions.getSheetName() + "\" w kom\u00f3rce " + positions.getAlias() + " nie jest dost\u0119pne. Przypisane jest ono aktualnie do u\u017cytkownika \"" + username + "\".");
    }

    private void validatePosition(List<Map<String, CellValue<String>>> list, Set<String> errors) {
        LinkedHashMultimap duplicates = LinkedHashMultimap.create();
        HashSet<CellValue<String>> hpos = new HashSet<CellValue<String>>();
        for (Map<String, CellValue<String>> map : list) {
            CellValue<String> name = map.get("name");
            CellValue<String> symbol = map.get("symbol");
            CellValue<String> higherPosition = map.get("higherPosition");
            CellValue<String> orgUnit = map.get("orgUnit");
            CellValue<String> roles = map.get("roles");
            if (!StringUtils.hasText((String)name.getValue())) {
                errors.add("Stanowisko nie mo\u017ce by\u0107 puste. Prosz\u0119 sprawdzi\u0107 arkusz: " + symbol.getSheetName() + " kom\u00f3rka: " + name.getAlias());
            }
            if (!StringUtils.hasText((String)symbol.getValue())) {
                errors.add("Symbol stanowiska nie mo\u017ce by\u0107 pusty. Prosz\u0119 sprawdzi\u0107 arkusz: " + symbol.getSheetName() + " kom\u00f3rka: " + symbol.getAlias());
            } else {
                duplicates.put((Object)symbol.getValue(), (Object)symbol.getAlias());
            }
            if (StringUtils.hasText((String)higherPosition.getValue()) && !this.positionExist(higherPosition.getValue())) {
                hpos.add(higherPosition);
            }
            if (StringUtils.hasText((String)orgUnit.getValue()) && !this.ouExist(orgUnit.getValue())) {
                errors.add("Nie znaleziono jednostki organizacyjnej: \"" + orgUnit.getValue() + "\" w arkuszu: " + orgUnit.getSheetName() + ". Prosz\u0119 sprawdzi\u0107 kom\u00f3rk\u0119: " + orgUnit.getAlias());
            }
            this.checkRole(roles, errors);
            this.posExisting.add(symbol.getValue());
        }
        for (CellValue cellValue : hpos) {
            if (this.positionExist((String)cellValue.getValue())) continue;
            errors.add("Nie znaleziono stanowiska: \"" + (String)cellValue.getValue() + "\" w arkuszu: " + cellValue.getSheetName() + ". Prosz\u0119 sprawdzi\u0107 kom\u00f3rk\u0119: " + cellValue.getAlias());
        }
        this.checkDuplicates((Multimap<String, String>)duplicates, "W arkuszu Stanowiska zdefiniowano wiele stanowisk o symbolu: \"", errors);
    }

    private boolean positionExist(String symbol) {
        if (!this.posExisting.contains(symbol)) {
            if ("OVERRIDE".equals(this.mode)) {
                return false;
            }
            if (this.posFinder.findBySymbol(symbol, new String[0]) == null) {
                return false;
            }
        }
        return true;
    }

    private boolean ouExist(String symbol) {
        if (!this.ouExisting.contains(symbol)) {
            if ("OVERRIDE".equals(this.mode)) {
                return false;
            }
            if (this.ouFinder.findBySymbol(symbol, new String[0]) == null) {
                return false;
            }
        }
        return true;
    }

    private void validateOrgUnits(List<Map<String, CellValue<String>>> list, List<Map<String, CellValue<String>>> positions, Set<String> errors) {
        LinkedHashMultimap duplicates = LinkedHashMultimap.create();
        HashSet<CellValue<String>> hous = new HashSet<CellValue<String>>();
        for (Map<String, CellValue<String>> map : list) {
            CellValue<String> name = map.get("name");
            CellValue<String> symbol = map.get("symbol");
            CellValue<String> higherOrgUnit = map.get("higherOrgUnit");
            CellValue<String> directorPosition = map.get("directorPosition");
            if (!StringUtils.hasText((String)name.getValue())) {
                errors.add("Jednostka organizacyjna nie mo\u017ce by\u0107 pusta. Prosz\u0119 sprawdzi\u0107 arkusz: " + symbol.getSheetName() + " kom\u00f3rka: " + name.getAlias());
            }
            if (!StringUtils.hasText((String)symbol.getValue())) {
                errors.add("Symbol jednostki organizacyjnej nie mo\u017ce by\u0107 pusty. Prosz\u0119 sprawdzi\u0107 arkusz: " + symbol.getSheetName() + " kom\u00f3rka: " + symbol.getAlias());
            } else {
                duplicates.put((Object)symbol.getValue(), (Object)symbol.getAlias());
            }
            if (StringUtils.hasText((String)higherOrgUnit.getValue())) {
                hous.add(higherOrgUnit);
            }
            if (StringUtils.hasText((String)directorPosition.getValue())) {
                if ("OVERRIDE".equals(this.mode)) {
                    this.checkPositionsInTemplate(positions, directorPosition, symbol, errors);
                }
                this.dirPos.add(directorPosition.getValue());
            }
            this.ouExisting.add(symbol.getValue());
        }
        for (CellValue cellValue : hous) {
            if (this.ouExist((String)cellValue.getValue())) continue;
            errors.add("Nie znaleziono jednostki nadrz\u0119dnej: \"" + (String)cellValue.getValue() + "\" w arkuszu: " + cellValue.getSheetName() + ". Prosz\u0119 sprawdzi\u0107 kom\u00f3rk\u0119: " + cellValue.getAlias());
        }
        this.checkDuplicates((Multimap<String, String>)duplicates, "W arkuszu Jednostki organizacyjne zdefiniowano wiele jednostek o symbolu: \"", errors);
    }

    private void validateGroups(List<Map<String, CellValue<String>>> list, Set<String> errors) {
        LinkedHashMultimap duplicates = LinkedHashMultimap.create();
        for (Map<String, CellValue<String>> map : list) {
            CellValue<String> name = map.get("name");
            if (!StringUtils.hasText((String)name.getValue())) {
                errors.add("Nazwa grupy nie mo\u017ce by\u0107 pusta. Prosz\u0119 sprawdzi\u0107 arkusz: " + name.getSheetName() + " kom\u00f3rka: " + name.getAlias());
            } else {
                duplicates.put((Object)name.getValue(), (Object)name.getAlias());
            }
            this.groupsExisting.add(name.getValue());
        }
        this.checkDuplicates((Multimap<String, String>)duplicates, "W arkuszu Grupy zdefiniowano wiele grup o nazwie: \"", errors);
    }

    private void checkGroups(CellValue<String> groups, Set<String> errors) {
        String[] roles;
        for (String role : roles = groups.getValue().split(";")) {
            if (this.groupExist(role)) continue;
            errors.add("Nie znaleziono grupy: \"" + role + "\" w arkuszu: " + groups.getSheetName() + ". Prosz\u0119 sprawdzi\u0107 kom\u00f3rk\u0119: " + groups.getAlias());
        }
    }

    private boolean groupExist(String groupName) {
        if (this.groupsExisting.contains(groupName)) {
            return true;
        }
        if ("OVERRIDE".equals(this.mode)) {
            return false;
        }
        UserGroup u = this.us.getGroup(groupName, new String[0]);
        return u != null;
    }

    private void checkRole(CellValue<String> sRoles, Set<String> errors) {
        if (StringUtils.hasText((String)sRoles.getValue())) {
            String[] roles;
            for (String role : roles = sRoles.getValue().split(";")) {
                Role r = this.getRole(role, sRoles);
                if (r != null) continue;
                errors.add("Rola o id: " + role + " nie istnieje w systemie. Prosz\u0119 sprawdzi\u0107 arkusz:" + sRoles.getSheetName() + " kom\u00f3rka: " + sRoles.getAlias());
            }
        }
    }

    private Role getRole(String roleId, CellValue<String> sRoles) {
        return CUFFactory.getRoleHelper().getRole(roleId, sRoles);
    }

    private boolean checkMail(CellValue<String> email) {
        Matcher matcher = emailPattern.matcher(email.getValue());
        return matcher.matches();
    }

    private void checkDuplicates(Multimap<String, String> duplicates, String message, Set<String> errors) {
        for (String name : duplicates.keySet()) {
            Collection cells = duplicates.get((Object)name);
            if (cells.size() <= 1) continue;
            errors.add(message + name + "\". Sprawd\u017a kom\u00f3rki: " + StringUtils.collectionToDelimitedString((Collection)cells, (String)", "));
        }
    }

    private void checkPositionsInTemplate(List<Map<String, CellValue<String>>> positions, CellValue<String> directorPosition, CellValue<String> symbol, Set<String> errors) {
        for (Map<String, CellValue<String>> position : positions) {
            for (CellValue<String> cell : position.values()) {
                String positionName = cell.getValue();
                if (!StringUtils.hasText((String)positionName) || !positionName.equals(directorPosition.getValue())) continue;
                return;
            }
        }
        errors.add("Nie znaleziono stanowiska: \"" + directorPosition.getValue() + "\" jednostki organizacyjnej: \"" + symbol.getValue() + "\" w arkuszu: Stanowiska. Sprawd\u017a arkusz: " + directorPosition.getSheetName() + " kom\u00f3rka: " + directorPosition.getAlias());
    }
}

