/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail;

import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SendMailSender {
    private static Logger log = Logger.getLogger(SendMailSender.class);
    private Map<String, String> smtpConf = this.getSmtpConfiguration();

    public static SendMailSender getInstance() {
        return new SendMailSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String sReceiverAddress, String sSubject, String sContent, List<WfDocument> listAttachments) throws MessagingException {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.smtpConf.get("SMTPMailServer"));
        properties.setProperty("mail.smtp.port", this.smtpConf.get("SMTPPortNo"));
        properties.setProperty("mail.smtp.auth", this.smtpConf.get("SMTPAuth"));
        properties.setProperty("mail.smtp.starttls.enable", this.smtpConf.get("UseSTARTTLS"));
        properties.setProperty("mail.smtp.ssl.enable", this.smtpConf.get("UseSSL"));
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication((String)SendMailSender.this.smtpConf.get("SMTPUser"), (String)SendMailSender.this.smtpConf.get("UserPassword"));
            }
        });
        MimeMessage message = new MimeMessage(session);
        message.addRecipients(Message.RecipientType.TO, sReceiverAddress);
        message.setSubject(sSubject);
        message.setFrom((Address)this.getInternetAddress(this.smtpConf.get("Email"), this.smtpConf.get("SourceAddress")));
        if (!listAttachments.isEmpty()) {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)sContent, "text/html; charset=utf-8");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (WfDocument attachment : listAttachments) {
                WfFile attachmentFile = attachment.getFile();
                InputStream is = null;
                try {
                    is = ServiceFactory.getFileService().getFileInputStream(Long.valueOf(attachmentFile.getId()));
                    messageBodyPart = new MimeBodyPart();
                    String mimeType = Tools.MIMETYPES_FILE_TYPE_MAP.getContentType(attachmentFile.getFileName());
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(is, mimeType)));
                    messageBodyPart.setFileName(attachmentFile.getFileName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                catch (IOException e) {
                    try {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            message.setContent((Multipart)multipart);
        } else {
            message.setContent((Object)sContent, "text/html; charset=utf-8");
        }
        Transport.send((Message)message);
        log.debug((Object)("Wys\u0142ano wiadomo\u015b\u0107 email na adres " + sReceiverAddress));
    }

    private Map<String, String> getSmtpConfiguration() {
        HashMap<String, String> smtpConf = new HashMap<String, String>();
        String email = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_EMAIL);
        String smtpMailServer = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPMAILSERVER);
        String smtpPort = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPPORTNO).toString();
        String smtpUser = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPUSER);
        String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USERPASSWORD);
        String smtpAuth = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SMTPAUTH).toString();
        String useSsl = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESSL).toString();
        String startTls = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_USESTARTTLS).toString();
        String sourceAddress = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DEFAULTMAILMESSAGEHANDLER_SOURCEADDRESS);
        smtpConf.put("SMTPMailServer", smtpMailServer);
        smtpConf.put("SMTPPortNo", smtpPort);
        smtpConf.put("SMTPAuth", smtpAuth);
        smtpConf.put("UseSTARTTLS", startTls);
        smtpConf.put("UseSSL", useSsl);
        smtpConf.put("Email", email);
        smtpConf.put("SMTPUser", smtpUser);
        smtpConf.put("UserPassword", password);
        smtpConf.put("SourceAddress", sourceAddress);
        return smtpConf;
    }

    private InternetAddress getInternetAddress(String email, String sourceAddress) throws AddressException {
        if (StringUtils.isBlank((String)sourceAddress)) {
            return new InternetAddress(email);
        }
        try {
            return new InternetAddress(email, sourceAddress);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            return new InternetAddress(email);
        }
    }
}

