/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.mail;

import com.suncode.cuf.mail.SimpleMailContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class TemplateMailContent
extends SimpleMailContent {
    private String templatePath;
    private Map<String, String> variables = new HashMap<String, String>();
    private boolean filled = false;

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public String getContent() {
        this.readContent();
        this.fillVariables();
        return this.content;
    }

    private void fillVariables() {
        if (!this.filled) {
            for (String key : this.variables.keySet()) {
                String value = this.variables.get(key);
                this.content = this.content.replaceAll("@" + key + "@", value);
                this.subject = this.subject.replaceAll("@" + key + "@", value);
            }
            this.filled = true;
        }
    }

    private void fillSubjectVariables() {
        for (String key : this.variables.keySet()) {
            String value = this.variables.get(key);
            this.subject = this.subject.replaceAll("@" + key + "@", value);
        }
    }

    private void readContent() {
        if (this.content == null) {
            try {
                File tpl = new File(this.templatePath);
                if (!tpl.exists()) {
                    throw new FileNotFoundException("Nie znaleziono pliku szablonu: " + tpl.getAbsolutePath());
                }
                this.content = FileUtils.readFileToString((File)tpl, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getSubject() {
        this.fillSubjectVariables();
        return super.getSubject();
    }
}

