/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model;

import com.google.common.collect.Lists;
import com.suncode.cuf.io.office.model.CellValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SheetDefinition {
    protected List<Map<String, CellValue<?>>> data;
    protected String name;
    protected String[] headers;

    SheetDefinition(String name, List<Map<String, Object>> data) {
        this(name, data, null);
    }

    public SheetDefinition(String name, List<Map<String, Object>> data, String[] headers) {
        this.data = this.convertObjectToCell(data);
        this.name = name;
        this.headers = headers;
    }

    public SheetDefinition(List<Map<String, CellValue<?>>> data, String name, String[] headers) {
        this.name = name;
        this.data = data;
        this.headers = headers;
    }

    public List<Map<String, Object>> getData() {
        return this.convertCellToObject();
    }

    public List<Map<String, CellValue<?>>> getImportCellData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    protected List<Map<String, Object>> convertCellToObject() {
        ArrayList result = Lists.newArrayList();
        for (Map<String, CellValue<?>> map : this.data) {
            HashMap converted = new HashMap();
            for (Map.Entry<String, CellValue<?>> entry : map.entrySet()) {
                converted.put(entry.getKey(), entry.getValue().getValue());
            }
            result.add(converted);
        }
        return result;
    }

    protected List<Map<String, CellValue<?>>> convertObjectToCell(List<Map<String, Object>> source) {
        ArrayList result = Lists.newArrayList();
        for (Map<String, Object> map : source) {
            HashMap<String, CellValue<Object>> converted = new HashMap<String, CellValue<Object>>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                CellValue<Object> cell = new CellValue<Object>(-1, -1, null, entry.getValue());
                converted.put(entry.getKey(), cell);
            }
            result.add(converted);
        }
        return result;
    }
}

