/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.queryDataChooser;

import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooser;
import com.plusmpm.CUF.util.extension.CUFHibernateUtil;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class QueryDataChooserManager {
    public static void save(QueryDataChooser oneQuery) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.save((Object)oneQuery);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void update(QueryDataChooser oneQuery) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.update((Object)oneQuery);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void delete(QueryDataChooser oneQuery) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.delete((Object)oneQuery);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public void deleteAll() throws HibernateException, Exception {
        List<QueryDataChooser> AllQueryList = QueryDataChooserManager.getAll();
        try {
            for (QueryDataChooser oneQuery : AllQueryList) {
                QueryDataChooserManager.delete(oneQuery);
            }
        }
        catch (HibernateException he) {
            throw he;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static List<QueryDataChooser> getAll() throws HibernateException, Exception {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createCriteria(QueryDataChooser.class).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<QueryDataChooser> getQueryDataChooserForName(String name) throws HibernateException, Exception {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createQuery("from QueryDataChooser where name=:ident order by query").setParameter("ident", (Object)name).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static long checkExistence(String sName, String sQuery, String sParameters, String sCountQuery, String sExternalDB, String sConfName, String sClassName) throws HibernateException, Exception {
        QueryDataChooser query = null;
        Session session = null;
        Transaction transaction = null;
        long result = -1L;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            query = (QueryDataChooser)session.createQuery("from QueryDataChooser where name=:sName and query=:sQuery and parameters=:sParameters and countQuery=:sCountQuery and externalDB=:sExternalDB and externalDBConfName=:sConfName and fullClassName=:sClassName").setParameter("sName", (Object)sName).setParameter("sQuery", (Object)sQuery).setParameter("sParameters", (Object)sParameters).setParameter("sCountQuery", (Object)sCountQuery).setParameter("sExternalDB", (Object)sExternalDB).setParameter("sConfName", (Object)sConfName).setParameter("sClassName", (Object)sClassName).uniqueResult();
            transaction.commit();
            if (query == null) {
                long l = result;
                return l;
            }
            long l = query.getId();
            return l;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static long checkExistenceOnlyQuery(String sName, String sQuery) throws HibernateException, Exception {
        QueryDataChooser query = null;
        Session session = null;
        Transaction transaction = null;
        long result = -1L;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            query = (QueryDataChooser)session.createQuery("from QueryDataChooser where name=:sName and query=:sQuery").setParameter("sName", (Object)sName).setParameter("sQuery", (Object)sQuery).uniqueResult();
            transaction.commit();
            if (query == null) {
                long l = result;
                return l;
            }
            long l = query.getId();
            return l;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }
}

