/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper;

import com.suncode.cuf.plannedtask.administration.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.helper.StructureAdapter;
import com.suncode.cuf.plannedtask.administration.helper.StructureMappings;
import com.suncode.cuf.plannedtask.administration.helper.StructureValidator;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class StructureImporter {
    private static final Logger log = ContextLogger.getLogger(StructureImporter.class);
    private StructureValidator structureValidator;
    private StructureAdapter structureAdapter;

    @Autowired
    public StructureImporter(StructureAdapter structureAdapter, StructureValidator structureValidator) {
        this.structureValidator = structureValidator;
        this.structureAdapter = structureAdapter;
    }

    public void importStructure(List<Map<String, Object>> rawData, StructureMappings mappings, ImportStructureMode mode) throws UserNotFoundException {
        this.importStructure(rawData, mappings, mode, "", "");
    }

    public void importStructure(List<Map<String, Object>> rawData, StructureMappings mappings, ImportStructureMode mode, String unusedUsersHandleType, String assignmentUsers) throws UserNotFoundException {
        List<Map<String, String>> converted = this.convertData(rawData, mappings);
        this.structureValidator.validateStructure(converted);
        this.readStructure(converted, mode, unusedUsersHandleType, assignmentUsers);
    }

    private List<Map<String, String>> convertData(List<Map<String, Object>> rawData, StructureMappings mappings) {
        List<Map<String, String>> converted = this.structureAdapter.convertImportingStructure(rawData, mappings);
        Assert.isTrue((rawData.size() == converted.size() ? 1 : 0) != 0, (String)"Przekonwertowane dane maj\u0105 inny rozmiar");
        log.debug("Konwersja struktury zako\u0144czona powodzeniem");
        return converted;
    }

    private void readStructure(List<Map<String, String>> structure, ImportStructureMode mode, String unusedUsersHandleType, String assignmentUsers) {
        Collections.sort(structure, StructureImporter.getUsernameComparator());
        mode.cacheUnusedUsers(new HashSet<String>(this.getStructureUsers(structure)));
        for (int i = 0; i < structure.size(); ++i) {
            Map<String, String> row = structure.get(i);
            User user = mode.buildUser(row, i, structure);
            log.trace("Read row: {}", row);
            if (user == null) continue;
            i += this.countUserDuplicatesInStructure(structure, user.getUserName(), i);
        }
        mode.removeUnusedElements(unusedUsersHandleType, assignmentUsers);
    }

    private int countUserDuplicatesInStructure(List<Map<String, String>> structure, String username, int currentIndex) {
        int userDuplicates = 0;
        while (this.isStillSameUser(structure, username, ++currentIndex)) {
            ++userDuplicates;
        }
        return userDuplicates;
    }

    private boolean isStillSameUser(List<Map<String, String>> structure, String username, int currentIndex) {
        return structure.size() > currentIndex && structure.get(currentIndex).get("userName").equals(username);
    }

    private List<String> getStructureUsers(List<Map<String, String>> structure) {
        return structure.stream().map(item -> (String)item.get("userName")).collect(Collectors.toList());
    }

    public static Comparator<Map<String, String>> getUsernameComparator() {
        return Comparator.comparing(item -> (String)item.get("userName"));
    }
}

