/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.Deactivation;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedUserManagement {
    private static final Logger log = LoggerFactory.getLogger(UnusedUserManagement.class);
    public static final String DEACTIVATE = "DEACTIVATE";
    private static final String SUPERIOR = "<SUPERIOR>";
    private List<User> unusedUsers;
    private UserService userService;

    public UnusedUserManagement(List<User> unusedUsers, UserService userService) {
        this.unusedUsers = unusedUsers != null ? unusedUsers : new ArrayList();
        this.userService = userService;
    }

    public void deleteUserIfPossible(User user, String assignmentUsers) {
        String userName = user.getUserName();
        try {
            if (user.isActive().booleanValue()) {
                this.deactivateUser(user, assignmentUsers);
            }
            this.userService.deleteUser(userName);
            log.debug("User '{}' has been deleted", (Object)userName);
        }
        catch (Exception e) {
            log.warn("Cannot delete user '{}' because user still has some dependencies in the system. User remains deactivated.", (Object)userName);
        }
    }

    public void deactivateUser(User user, String assignmentUsers) {
        try {
            if (user.isActive().booleanValue()) {
                Deactivation deactivation = this.getDeactivation(user, assignmentUsers);
                this.userService.deactivateUser(deactivation);
                log.debug("Deactivation of user '{}' ", (Object)user.getUserName());
            }
        }
        catch (Exception e) {
            log.warn("Could not deactivate user '{}' with custom assignments. Deactivating user with default settings instead.", (Object)user.getUserName());
            this.userService.deactivateUser(user.getUserName());
        }
    }

    private Deactivation getDeactivation(User deactivatedUser, String assignmentUsers) {
        Set<User> users = this.getAssignmentUsers(deactivatedUser, assignmentUsers);
        if (CollectionUtils.isEmpty(users)) {
            throw new IllegalArgumentException("Could not resolve assignment users.");
        }
        ArrayList<User> usersAsList = new ArrayList<User>(users);
        User defaultUser = (User)usersAsList.get(0);
        Deactivation deactivation = Deactivation.create((String)deactivatedUser.getUserName());
        deactivation.setNotificationUser(defaultUser);
        deactivation.setReportUser(defaultUser);
        deactivation.setSubstitutionUser(defaultUser);
        deactivation.setViewUser(defaultUser);
        deactivation.setUsers(usersAsList);
        return deactivation;
    }

    private Set<User> getAssignmentUsers(User deactivatedUser, String assignmentUsers) {
        String[] splittedUsers;
        LinkedHashSet<User> users = new LinkedHashSet<User>();
        for (String singleUser : splittedUsers = assignmentUsers.split(";")) {
            if (singleUser.equalsIgnoreCase(SUPERIOR)) {
                users.addAll(this.getSuperiorUsers(deactivatedUser));
                continue;
            }
            User user2 = this.userService.getUser(singleUser, new String[0]);
            if (user2 == null) continue;
            users.add(user2);
        }
        return users.stream().filter(user -> !this.unusedUsers.contains(user)).collect(Collectors.toSet());
    }

    private List<User> getSuperiorUsers(User deactivatedUser) {
        return deactivatedUser.getPositions().stream().map(position -> position.getHigherPosition()).filter(Objects::nonNull).map(Position::getUser).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }
}

