/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration;

import com.plusmpm.CUF.util.extension.DBService;
import com.plusmpm.CUF.util.extension.ExcelWriter;
import com.plusmpm.CUF.util.extension.QueryUtils;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.database.config.DatabaseConfig;
import com.suncode.cuf.database.config.MSSqlConfig;
import com.suncode.cuf.database.config.OracleConfig;
import com.suncode.cuf.database.config.PostgresConfig;
import com.suncode.cuf.hibernate.HibernateQueryExecutor;
import com.suncode.cuf.hibernate.SessionFactoryBuilder;
import com.suncode.cuf.plannedtask.administration.helper.ExportStructureHelper;
import com.suncode.cuf.plannedtask.administration.helper.StructureAdapter;
import com.suncode.cuf.plannedtask.administration.helper.StructureMappings;
import com.suncode.cuf.plannedtask.administration.helper.internal.DBMappings;
import com.suncode.cuf.plannedtask.administration.helper.internal.ExcelMappings;
import com.suncode.cuf.sql.query.DMLQuery;
import com.suncode.cuf.sql.query.ParamValue;
import com.suncode.cuf.sql.query.type.SqlTypes;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class ExportStructure
extends AbstractAdvancedTask {
    private static Logger log = Logger.getLogger(ExportStructure.class);
    private volatile double progress = 0.0;

    @AdvancedTask(name="exportStructure", description="exportStructure_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void exportStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path) throws Exception {
        List<Map<String, Object>> structure = this.getStructure();
        this.progress = 0.5;
        this.generateExcel(structure, path);
        this.progress = 1.0;
    }

    @AdvancedTask(name="exportStructureToDb", description="exportStructureToDb", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void exportStructureToDb(@TaskParam(name="dbtype", description="dbtype_desc") String dbType, @TaskParam(name="dburl", description="dburl") String url, @TaskParam(name="dbport", description="dbport") String port, @TaskParam(name="dbname", description="dbname") String dbName, @TaskParam(name="tablename", description="tablename") String tableName, @TaskParam(name="dbusername", description="dbusername") String userName, @TaskParam(name="dbpass", description="dbpass") String password) throws Exception {
        List<Map<String, Object>> data = this.getStructure();
        this.progress = 0.5;
        DatabaseConfig dbcfg = ExportStructure.buildDBConfig(dbType, url, port, dbName, userName, password);
        List<Map<String, String>> converted = this.convertData(data);
        this.exportToDB(converted, dbcfg, tableName);
        this.progress = 1.0;
    }

    private List<Map<String, String>> convertData(List<Map<String, Object>> data) {
        StructureAdapter adapter = (StructureAdapter)SpringContext.getBean(StructureAdapter.class);
        return adapter.convertExportingStructure(data, this.getDBMappings());
    }

    private void exportToDB(List<Map<String, String>> data, DatabaseConfig dbcfg, String tableName) {
        StructureMappings mappings = this.getDBMappings();
        String[] columnNames = mappings.getColumnNames();
        try (SessionFactory sf = null;){
            sf = SessionFactoryBuilder.buildSessionFactory(dbcfg);
            if (!this.tableExists(tableName, sf)) {
                this.createExportTable(tableName, columnNames, sf);
            }
            this.setDataInTable(sf, data, tableName, columnNames);
        }
    }

    private void createExportTable(String tableName, String[] columns, SessionFactory sf) {
        HibernateQueryExecutor executor = new HibernateQueryExecutor();
        executor.setSessionFactory(sf);
        String query = this.createExportTableQuery(tableName, columns);
        DMLQuery q = new DMLQuery();
        q.setQuery(query);
        executor.executeUpdate(q);
        log.debug((Object)("Tabela: " + tableName + " zosta\u0142a utworzona pomy\u015blnie"));
    }

    private boolean tableExists(String tableName, SessionFactory sf) {
        DBService dbs = new DBService();
        dbs.setSessionFactory(sf);
        return dbs.tableExists(tableName);
    }

    private void generateExcel(List<Map<String, Object>> structure, String path) throws IOException, ParseException {
        ExcelWriter ew = new ExcelWriter();
        FileOutputStream os = new FileOutputStream(new File(path));
        StructureMappings mappings = this.getExcelMappings();
        Map<String, String> columnMappings = mappings.getColumnMappings();
        String[] columnNames = mappings.getColumnNames();
        ew.setExtension("xlsx");
        ew.setHeaders(columnNames);
        ew.setHeadersMapping(columnMappings);
        ew.generateExcel(structure, os);
    }

    StructureMappings getExcelMappings() {
        return (StructureMappings)SpringContext.getBean(ExcelMappings.class);
    }

    StructureMappings getDBMappings() {
        return new DBMappings();
    }

    private List<Map<String, Object>> getStructure() {
        ExportStructureHelper sh = (ExportStructureHelper)SpringContext.getBean(ExportStructureHelper.class);
        return sh.buildStructureMap();
    }

    private void setDataInTable(SessionFactory sf, List<Map<String, String>> data, String tableName, String[] columns) {
        HibernateQueryExecutor executor = new HibernateQueryExecutor();
        List<DMLQuery> inserts = this.buildInserts(tableName, data, columns);
        Session hs = null;
        Transaction tx = null;
        try {
            hs = sf.getCurrentSession();
            tx = hs.beginTransaction();
            this.deleteAllRows(executor, tableName, hs);
            this.insertRows(executor, hs, inserts);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private void insertRows(HibernateQueryExecutor executor, Session hs, List<DMLQuery> inserts) {
        for (DMLQuery dmlQuery : inserts) {
            executor.executeUpdate(dmlQuery, hs);
        }
    }

    private void deleteAllRows(HibernateQueryExecutor executor, String tableName, Session hs) {
        DMLQuery deleteQuery = new DMLQuery();
        deleteQuery.setQuery("delete from " + tableName);
        executor.executeUpdate(deleteQuery, hs);
    }

    private List<DMLQuery> buildInserts(String tableName, List<Map<String, String>> data, String[] columns) {
        StringBuilder query = new StringBuilder("insert into ");
        query.append(tableName);
        query.append(" (");
        query.append(StringUtils.join((Object[])columns, (String)","));
        query.append(") values ( :");
        query.append(StringUtils.join((Object[])columns, (String)",:"));
        query.append(" ) ");
        String sQuery = query.toString();
        ArrayList<DMLQuery> inserts = new ArrayList<DMLQuery>();
        for (Map<String, String> row : data) {
            DMLQuery q = new DMLQuery();
            q.setQuery(sQuery);
            q.setParameters(this.buildParameters(row, columns));
            inserts.add(q);
        }
        return inserts;
    }

    private List<ParamValue> buildParameters(Map<String, String> row, String[] columns) {
        ArrayList<ParamValue> params = new ArrayList<ParamValue>();
        for (String col : columns) {
            String v = row.get(col);
            params.add(new ParamValue(col, v, SqlTypes.STRING));
        }
        return params;
    }

    static DatabaseConfig buildDBConfig(String dbType, String url, String port, String dbName, String userName, String password) {
        if (dbType.equalsIgnoreCase("PostgreSQL")) {
            String u = "jdbc:postgresql://" + url + ":" + port + "/" + dbName;
            return new PostgresConfig(u, userName, password);
        }
        if (dbType.equalsIgnoreCase("MSSQL")) {
            String u = "jdbc:sqlserver://" + url + ":" + port + ";useUnicode=true;characterEncoding=UTF-8";
            return new MSSqlConfig(u, userName, password);
        }
        if (dbType.equalsIgnoreCase("OracleDB")) {
            String u = "jdbc:oracle:thin:@" + url + ":" + port + ":" + dbName;
            return new OracleConfig(u, userName, password);
        }
        throw new IllegalArgumentException("Typ bazy danych nie jest wspierwany: " + dbType);
    }

    private String createExportTableQuery(String tableName, String[] cols) {
        StringBuilder query = new StringBuilder();
        query.append("create table ");
        query.append(tableName);
        query.append("( ");
        String c = QueryUtils.listToString(Arrays.asList(cols), " varchar(255),");
        query.append(c);
        query.append(" varchar(255),");
        query.append("primary key (" + cols[0] + "," + cols[8] + ") ");
        query.append(" ) ");
        return query.toString();
    }

    public Double getProgress() {
        return this.progress;
    }
}

