/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.email.AuditEmail;
import com.plusmpm.util.SharkFunctions;
import com.suncode.cuf.automatictask.mail.ReceiverJson;
import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.format.ValueFormatter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class SendMail {
    private static Logger log = Logger.getLogger(SendMail.class);

    public static void execute(AppParameter subject, AppParameter template, AppParameter json, AppParameter attachments, AppParameter processId) throws Exception {
        Date started = new Date();
        String sSubject = subject.the_value.toString();
        String sTemplate = template.the_value.toString();
        String sJson = json.the_value.toString();
        Boolean bAttachments = Boolean.valueOf(attachments.the_value.toString());
        ProcessService processService = ServiceFactory.getProcessService();
        Process process = processService.getProcess(processId.the_value.toString(), new String[]{"processDefinition"});
        Map processContext = processService.getProcessContext(process.getProcessId());
        ArrayList<WfDocument> listAttachments = new ArrayList();
        if (bAttachments.booleanValue()) {
            DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
            listAttachments = documentFinder.getDocumentsFromProcess(process.getProcessId(), new String[0]);
        }
        Collection collectionReceivers = null;
        try {
            collectionReceivers = (Collection)new ObjectMapper().readValue(sJson, (TypeReference)new TypeReference<Collection<ReceiverJson>>(){});
        }
        catch (IOException e) {
            log.error((Object)("Invalid list of receivers: " + sJson));
            throw new IllegalArgumentException("Invalid list of receivers: " + sJson, e);
        }
        String sParsedContent = SendMail.replaceExpressions(SendMail.getHtmlFromTemplate(sTemplate), processContext);
        String sParsedSubject = SendMail.replaceExpressions(sSubject, processContext);
        ArrayList<String> listMailsCompleted = new ArrayList<String>();
        AuditEmail auditEmail = new AuditEmail();
        auditEmail.setProcessId(process.getProcessDefinition().getProcessDefinitionId());
        ArrayList<ReceiverJson> notAuditedYet = new ArrayList<ReceiverJson>(collectionReceivers);
        for (ReceiverJson receiver : collectionReceivers) {
            Receiver rec = SendMail.getReceiver(receiver.getType());
            try {
                rec.send(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted, process.getProcessId());
                auditEmail.logAudit(started, true, receiver.getValue(), sSubject, "");
                notAuditedYet.remove(receiver);
            }
            catch (Exception e) {
                log.error((Object)("Error occured: " + e.getMessage()));
                auditEmail.logAudit(started, false, SendMail.convertToArray(notAuditedYet), sSubject, e.getMessage());
                throw e;
            }
        }
    }

    public static Receiver getReceiver(ReceiverTypes type) {
        Map receivers = SpringContext.getInstance().getBeansOfType(Receiver.class);
        for (Map.Entry entry : receivers.entrySet()) {
            if (!((Receiver)entry.getValue()).getType().equals((Object)type)) continue;
            return (Receiver)entry.getValue();
        }
        throw new NullPointerException(String.format("Not found receiver (type %s)", new Object[]{type}));
    }

    private static String getHtmlFromTemplate(String sTemplate) throws IOException {
        String htmlContent = null;
        try {
            htmlContent = new Scanner(new File(sTemplate), "UTF-8").useDelimiter("\\Z").next();
        }
        catch (IOException e) {
            throw new IOException("Niepoprawna \u015bcie\u017cka do szablonu: " + sTemplate, e);
        }
        return htmlContent;
    }

    private static String replaceExpressions(String sData, Map<String, Object> mapProcessContext) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        ActivityService activityService = ServiceFactory.getActivityService();
        ProcessService processService = ServiceFactory.getProcessService();
        Activity activity = activityService.getActivity(mapProcessContext.get("ProccessId").toString(), mapProcessContext.get("ActivityId").toString(), new String[0]);
        Process process = processService.getProcess(mapProcessContext.get("ProccessId").toString(), new String[]{"processDefinition"});
        List listActivities = activityFinder.findByProcessId(process.getProcessId(), new String[0]);
        Date processStartTime = null;
        for (Activity act : listActivities) {
            if (processStartTime != null && !act.getLastStateTime().after(processStartTime) || !act.getState().equals((Object)ActivityState.COMPLETED)) continue;
            processStartTime = act.getLastStateTime();
            activity = act;
        }
        HashMap<String, Object> mapExpressions = new HashMap<String, Object>();
        mapExpressions.put("processname", process.getDescription());
        mapExpressions.put("processdescription", process.getDescription());
        mapExpressions.put("processtype", process.getProcessDefinition().getProcessDefinitionId());
        mapExpressions.put("processstarttime", new SimpleDateFormat("HH:mm").format(processStartTime));
        mapExpressions.put("processstartday", new SimpleDateFormat("dd-MM-yyy").format(processStartTime));
        mapExpressions.put("activityname", activity.getName());
        mapExpressions.put("activitystarttime", new SimpleDateFormat("HH:mm").format(activity.getCreatedTime()));
        mapExpressions.put("activitystartday", new SimpleDateFormat("dd-MM-yyyy").format(activity.getCreatedTime()));
        mapExpressions.putAll(SendMail.getRealUsersName(sData, process.getProcessId()));
        mapExpressions.putAll(SendMail.getTaskUsers(sData, process.getProcessId()));
        mapExpressions.putAll(SendMail.getLinks(sData, process.getProcessId()));
        mapExpressions.putAll(mapProcessContext);
        WorkflowProcess workflowProcess = SharkFunctions.getWorkflowProcessById((String)((String)mapProcessContext.get("ProccessId")));
        for (String str : mapExpressions.keySet()) {
            String value = ValueFormatter.getFormattedValue(mapExpressions.get(str), (DataField)workflowProcess.getDataField(str));
            sData = sData.replace("@" + str + "@", value);
        }
        return sData;
    }

    private static Map<String, String> getRealUsersName(String sData, String sProcessId) {
        ProcessService processService = ServiceFactory.getProcessService();
        UserService userService = ServiceFactory.getUserService();
        Map mapProcessContext = processService.getProcessContext(sProcessId);
        HashMap<String, String> mapRealUsersName = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@realusername#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@realusername#", fromIndex) + "@realusername#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sProcessVariable = sData.substring(beginIndex, endIndex);
            try {
                String sUserName = mapProcessContext.get(sProcessVariable).toString();
                if (sUserName.length() <= 0) continue;
                try {
                    String sUserFullName = userService.getUser(sUserName, new String[0]).getFullName();
                    mapRealUsersName.put("realusername#" + sProcessVariable, sUserFullName);
                }
                catch (NullPointerException e) {
                    mapRealUsersName.put("realusername#" + sProcessVariable, "@u\u017cytkownik nie istnieje!@");
                }
            }
            catch (NullPointerException e) {
                mapRealUsersName.put("realusername#" + sProcessVariable, "@realusername#" + sProcessVariable + ": (brak zmiennej w procesie)@");
            }
        }
        return mapRealUsersName;
    }

    private static Map<String, String> getTaskUsers(String sData, String sProcessId) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        ActivityService activityService = (ActivityService)SpringContext.getBean(ActivityService.class);
        UserService userService = ServiceFactory.getUserService();
        List listActivity = activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapTaskUsers = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@taskuser#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@taskuser#", fromIndex) + "@taskuser#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            ActivityEntity activity = (ActivityEntity)activityService.getActivity(sProcessId, sActivityId, new String[0]);
            User user = userService.getUser(activity.getResourceId(), new String[0]);
            mapTaskUsers.put("taskuser#" + sActivityDefId, user.getFullName());
        }
        return mapTaskUsers;
    }

    private static Map<String, String> getLinks(String sData, String sProcessId) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        List listActivity = activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapLinks = new HashMap<String, String>();
        String sHttpLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        int fromIndex = 0;
        while (sData.indexOf("@link#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@link#", fromIndex) + "@link#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            mapLinks.put("link#" + sActivityDefId, sHttpLink + "/ShowDetailHistory.do?histActivityId=" + sActivityId + "&ProcessId=" + sProcessId);
        }
        String sHistoryLink = sHttpLink + "/ShowProcessHistory.do?ProcessId=" + sProcessId;
        mapLinks.put("historylink", sHistoryLink);
        return mapLinks;
    }

    private static String[] convertToArray(List<ReceiverJson> receivers) {
        String[] emails = new String[receivers.size()];
        for (int i = 0; i < emails.length; ++i) {
            ReceiverJson receiver = receivers.get(i);
            emails[i] = receiver.getValue();
            if (receiver.getType().equals((Object)ReceiverTypes.EMAIL)) continue;
            int n = i;
            emails[n] = emails[n] + "(" + receivers.get(i).getType().name() + ")";
        }
        return emails;
    }
}

