/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper.internal;

import com.google.common.collect.Lists;
import com.suncode.cuf.administartion.structure.RoleHelper;
import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.plannedtask.administration.helper.UnusedUserManagement;
import com.suncode.cuf.plannedtask.administration.structure.helper.ImportStructureMode;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component(value="importOrgStructureOverrideMode")
@Scope(value="prototype")
public class OverrideMode
implements ImportStructureMode {
    private static final Logger log = ContextLogger.getLogger(OverrideMode.class);
    @Autowired
    private StructureService structService;
    private List<User> cachedUnusedUsers;
    @Autowired
    private StructureService ss;
    @Autowired
    protected UserService userService;
    @Autowired
    private RoleService rs;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    protected OrganizationalUnitFinder ouFinder;
    @Autowired
    protected PositionFinder positionFinder;
    @Autowired
    private RoleHelper roleHelper;
    @Autowired
    private UserGroupFinder groupFinder;
    private Set<String> userNames = new HashSet<String>();
    private Set<String> positionSymbols = new HashSet<String>();
    private Set<String> ouSymbols = new HashSet<String>();
    private Set<String> groupNames = new HashSet<String>();

    @Override
    public void importGroup(String name, String desc) {
        if (this.groupExist(name)) {
            this.updateGroup(name, desc);
            log.debug("Zaktualizowano grup\u0119: " + name);
        } else {
            this.createGroup(name, desc);
            log.debug("Utworzono grup\u0119: " + name);
        }
        this.groupNames.add(name);
    }

    @Override
    public void importUser(String userName, String firstName, String lastName, String password, String email, String number, String groups, String positions, Boolean activate) {
        if (this.userExist(userName)) {
            this.updateUser(userName, firstName, lastName, password, email, number, groups, positions);
            this.activateUser(userName, activate);
            log.debug("Zaimportowano u\u017cytkownika: " + userName);
        } else {
            this.createUser(userName, firstName, lastName, password, email, number, groups, positions);
            log.debug("Utworzono u\u017cytkownika: " + userName);
        }
        this.userNames.add(userName);
    }

    @Override
    public void importOrgUnit(String name, String symbol, String higherOrgUnit, String directorPosition) {
        if (this.ouExist(symbol)) {
            this.updateOrgUnit(name, symbol, higherOrgUnit, directorPosition);
        } else {
            this.createOrgUnit(name, symbol, higherOrgUnit, directorPosition);
        }
        this.ouSymbols.add(symbol);
    }

    @Override
    public void importPosition(String name, String symbol, String higherPosition, String orgUnit, String roles) {
        if (this.positionExist(symbol)) {
            this.updatePosition(name, symbol, higherPosition, orgUnit, roles);
        } else {
            this.createPosition(name, symbol, higherPosition, orgUnit, roles);
        }
        this.positionSymbols.add(symbol);
    }

    @Override
    public void importPositionsAssotiations(String symbol, String higherPosition) {
        Position p = this.structService.getPosition(symbol, new String[0]);
        Position hp = this.structService.getPosition(higherPosition, new String[0]);
        p.setHigherPosition(hp);
        this.structService.updatePosition(p);
    }

    @Override
    public void importOrgUnitAssotiations(String symbol, String higherOrgUnit, String directorPosition) {
        OrganizationalUnit ou = this.structService.getOrganizationalUnit(symbol, new String[0]);
        OrganizationalUnit hou = this.structService.getOrganizationalUnit(higherOrgUnit, new String[0]);
        Position p = this.structService.getPosition(directorPosition, new String[0]);
        ou.setDirectorPosition(p);
        ou.setHigherOrganizationalUnit(hou);
        this.structService.updateOrganizationalUnit(ou);
    }

    protected void updatePosition(String name, String symbol, String higherPosition, String orgUnit, String roles) {
        Position p = this.structService.getPosition(symbol, new String[0]);
        Position hp = this.structService.getPosition(higherPosition, new String[0]);
        p.setName(name);
        p.setHigherPosition(hp);
        OrganizationalUnit hou = this.structService.getOrganizationalUnit(orgUnit, new String[0]);
        p.setOrganizationalUnit(hou);
        this.structService.updatePosition(p);
        List<Role> roleList = this.getRoles(roles);
        this.addRoles(p, roleList);
        this.removePositionFromOtherRoles(p.getSymbol(), roleList);
    }

    protected void updateUser(String userName, String firstName, String lastName, String password, String email, String number, String groups, String positions) {
        User user = this.userService.getUser(userName, new String[0]);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setNumber(number);
        this.userService.updateUser(user);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            this.userService.changeUserPassword(userName, password);
        }
        List<UserGroup> groupList = this.getGroups(groups);
        try {
            this.userService.addUserToGroups(userName, this.toNames(groupList));
            this.removeUserFromOtherGroups(userName, groupList);
            List<Position> pos = this.getPositions(positions);
            this.assignPositionToUser(user, pos);
            this.removeUserFromOtherPositions(userName, pos);
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    private void activateUser(String userName, Boolean activate) {
        try {
            if (activate.booleanValue() && !this.userService.isActive(userName)) {
                this.userService.activateUser(userName);
                log.debug("Aktywacja uzytkownika: " + userName);
            }
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    protected void updateGroup(String name, String desc) {
        UserGroup ug = new UserGroup(name);
        ug.setDescription(desc);
        try {
            this.userService.updateGroup(ug);
        }
        catch (GroupNotFoundException e) {
            throw new CUFServiceException(e);
        }
    }

    protected void updateOrgUnit(String name, String symbol, String higherOrgUnit, String directorPosition) {
        OrganizationalUnit ou = this.structService.getOrganizationalUnit(symbol, new String[0]);
        ou.setName(name);
        this.structService.updateOrganizationalUnit(ou);
    }

    protected OrganizationalUnit createOrgUnit(String name, String symbol, String higherOrgUnit, String directorPosition) {
        OrganizationalUnit ou = new OrganizationalUnit(name, symbol);
        this.structService.createOrganizationalUnit(ou);
        return ou;
    }

    protected Position createPosition(String name, String symbol, String higherPosition, String orgUnit, String roles) {
        Position p = new Position(name, symbol);
        Position hp = this.structService.getPosition(higherPosition, new String[0]);
        p.setHigherPosition(hp);
        OrganizationalUnit hou = this.structService.getOrganizationalUnit(orgUnit, new String[0]);
        p.setOrganizationalUnit(hou);
        this.structService.createPosition(p);
        List<Role> roleList = this.getRoles(roles);
        this.addRoles(p, roleList);
        return p;
    }

    protected void createUser(String userName, String firstName, String lastName, String password, String email, String number, String groups, String positions) {
        User user = new User(userName, this.getPassword(password));
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setNumber(number);
        List<UserGroup> groupList = this.getGroups(groups);
        try {
            this.userService.createUser(user, groupList.get(0).getName());
            this.userService.addUserToGroups(userName, this.toNames(groupList.subList(1, groupList.size())));
            this.assignPositionToUser(user, this.getPositions(positions));
            log.debug("Utworzono u\u017cytkownika: " + user.getUserName());
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    protected void createGroup(String name, String desc) {
        UserGroup ug = new UserGroup(name);
        ug.setDescription(desc);
        this.createGroup(ug);
    }

    private boolean groupExist(String name) {
        return this.userService.getGroup(name, new String[0]) != null;
    }

    private boolean userExist(String userName) {
        return this.userService.getUser(userName, new String[0]) != null;
    }

    private boolean positionExist(String symbol) {
        return this.structService.getPosition(symbol, new String[0]) != null;
    }

    private boolean ouExist(String symbol) {
        return this.structService.getOrganizationalUnit(symbol, new String[0]) != null;
    }

    private String getPassword(String pass) {
        if (StringUtils.isBlank((CharSequence)pass)) {
            return "";
        }
        return pass;
    }

    private void removeUnuserdOus() {
        DetachedCriteria dc = this.createNotInCriteria(this.ouSymbols, "symbol", OrganizationalUnit.class);
        List ous = this.ouFinder.findByCriteria(dc);
        for (OrganizationalUnit ou : ous) {
            this.ss.deleteOrganizationalUnit(ou.getSymbol());
            log.debug("Usuni\u0119to jednostk\u0119 organizacyjn\u0105: " + ou.getSymbol());
        }
        log.info("Usuni\u0119te jednostki organizacyjne: " + ous.size());
    }

    private void removeUnusedPositions() {
        DetachedCriteria dc = this.createNotInCriteria(this.positionSymbols, "symbol", Position.class);
        List pos = this.positionFinder.findByCriteria(dc);
        for (Position position : pos) {
            this.ss.deletePosition(position.getSymbol());
        }
        log.info("Usuni\u0119to stanowiska: " + pos.size());
    }

    private void removeUnusedGroups() {
        DetachedCriteria criteria = this.createNotInCriteria(this.groupNames, "name", UserGroup.class);
        criteria.add((Criterion)Restrictions.ne((String)"name", (Object)"SharkGroup"));
        criteria.add((Criterion)Restrictions.ne((String)"name", (Object)"Administrators"));
        List groups = this.groupFinder.findByCriteria(criteria);
        for (UserGroup userGroup : groups) {
            try {
                this.userService.deleteGroup(userGroup.getName());
                log.debug("Usuni\u0119to grup\u0119: " + userGroup.getName());
            }
            catch (GroupNotFoundException e) {
                throw new CUFServiceException(e);
            }
        }
        log.info("Usuni\u0119to grupy: " + groups.size());
    }

    private void removeUnusedUsers(String unusedUsersHandleType, String assignmentUsers) {
        ArrayList<User> unusedUsers = new ArrayList<User>(this.cachedUnusedUsers);
        UnusedUserManagement unusedUserManagement = new UnusedUserManagement(unusedUsers, this.userService);
        if ("DEACTIVATE".equalsIgnoreCase(unusedUsersHandleType)) {
            unusedUsers.forEach(user -> unusedUserManagement.deactivateUser((User)user, assignmentUsers));
        } else {
            unusedUsers.forEach(user -> unusedUserManagement.deleteUserIfPossible((User)user, assignmentUsers));
        }
        log.info("Usuni\u0119to u\u017cytkownik\u00f3w: " + unusedUsers.size());
    }

    protected void removeUserFromOtherPositions(String userName, List<Position> pos) {
        User user = this.userFinder.findByUserName(userName, new String[]{"positions"});
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Position actual : user.getPositions()) {
            boolean remove = true;
            for (Position ug : pos) {
                if (!actual.getSymbol().equals(ug.getSymbol())) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            toRemove.add(actual.getId());
        }
        for (Long id : toRemove) {
            this.structService.detachPositionFromUser(id);
        }
    }

    protected void removePositionFromOtherRoles(String symbol, List<Role> roleList) {
        Position p = this.structService.getPosition(symbol, new String[]{"roles"});
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Role actual : p.getRoles()) {
            boolean remove = true;
            for (Role ug : roleList) {
                if (!actual.getId().equals(ug.getId())) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            toRemove.add(actual.getId());
        }
        for (Long id : toRemove) {
            this.rs.detachRole(p.getId(), id);
        }
    }

    protected void removeUserFromOtherGroups(String userName, List<UserGroup> groups) {
        User user = this.userFinder.findByUserName(userName, new String[]{"groups"});
        ArrayList<String> toRemove = new ArrayList<String>();
        for (UserGroup actual : user.getGroups()) {
            boolean remove = true;
            for (UserGroup ug : groups) {
                if (!actual.getName().equals(ug.getName())) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            toRemove.add(actual.getName());
        }
        this.userService.removeUserFromGroups(userName, toRemove);
    }

    protected List<String> toNames(List<UserGroup> subList) {
        ArrayList<String> names = new ArrayList<String>();
        for (UserGroup ug : subList) {
            names.add(ug.getName());
        }
        return names;
    }

    @Transactional
    public void assignPositionToUser(User user, List<Position> positions) {
        for (Position position : positions) {
            this.ss.addPositionToUser(user.getUserName(), position.getId());
        }
    }

    public void changePassword(String userName, String pass) {
        if (StringUtils.isNotBlank((CharSequence)pass)) {
            this.userService.changeUserPassword(userName, pass);
        }
    }

    @Transactional
    public void addRoles(Position p, List<Role> roles) {
        this.rs.detachAllRoles(p.getId());
        for (Role role : roles) {
            this.rs.addRole(p.getId(), role.getId());
        }
    }

    private List<UserGroup> getGroups(String sGroups) {
        String[] groups;
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        if (StringUtils.isBlank((CharSequence)sGroups)) {
            return userGroups;
        }
        for (String groupName : groups = sGroups.split(";")) {
            UserGroup ug = this.userService.getGroup(groupName, new String[0]);
            userGroups.add(ug);
        }
        return userGroups;
    }

    private List<Position> getPositions(String symbols) {
        String[] positions;
        ArrayList<Position> positionList = new ArrayList<Position>();
        if (StringUtils.isBlank((CharSequence)symbols)) {
            return positionList;
        }
        for (String symbol : positions = symbols.split(";")) {
            Position p = this.structService.getPosition(symbol, new String[0]);
            positionList.add(p);
        }
        return positionList;
    }

    private List<Role> getRoles(String sRoles) {
        String[] roleIds;
        ArrayList<Role> roles = new ArrayList<Role>();
        if (StringUtils.isBlank((CharSequence)sRoles)) {
            return roles;
        }
        for (String roleId : roleIds = sRoles.split(";")) {
            Role r = this.roleHelper.getRole(roleId);
            Assert.notNull((Object)r, (String)"Rola nie mo\u017ce by\u0107 pusta");
            roles.add(r);
        }
        return roles;
    }

    private DetachedCriteria createNotInCriteria(Set<String> elements, String criteria, Class<?> clazz) {
        DetachedCriteria dc = DetachedCriteria.forClass(clazz);
        List parts = Lists.partition((List)Lists.newArrayList(elements), (int)500);
        for (List part : parts) {
            dc.add(Restrictions.not((Criterion)Restrictions.in((String)criteria, (Collection)part)));
        }
        return dc;
    }

    public void createGroup(UserGroup ug) {
        try {
            this.userService.createGroup(ug);
        }
        catch (GroupAlreadyExistException e) {
            throw new CUFServiceException(e);
        }
    }

    @Override
    public void clean(String unusedUsersHandleType, String assignmentUsers) {
        this.removeUnusedGroups();
        this.removeUnusedPositions();
        this.removeUnusedUsers(unusedUsersHandleType, assignmentUsers);
        this.removeUnuserdOus();
    }

    @Override
    public void cacheUnusedUsers(Set<String> structureUsers) {
        DetachedCriteria criteria = this.createNotInCriteria(structureUsers, "userName", User.class);
        criteria.add((Criterion)Restrictions.ne((String)"userName", (Object)"admin"));
        criteria.setFetchMode("positions", FetchMode.JOIN);
        criteria.setFetchMode("positions.higherPosition", FetchMode.JOIN);
        criteria.setFetchMode("positions.higherPosition.user", FetchMode.JOIN);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.cachedUnusedUsers = this.userFinder.findByCriteria(criteria);
    }
}

