/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.util.template;

import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.springframework.transaction.TransactionStatus;

public class WordTemplateUtil {
    private static DocumentService documentService = ServiceFactory.getDocumentService();
    private static DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
    private static DocumentClassActionService docClassActionService = ServiceFactory.getDocumentClassActionService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WfDocument archiveAndAttachToProcess(File document, String processId, String activityId, String documentClass, String template, WordTemplateService.OutputFormat format, boolean attachToProcess, boolean saveAsNewVersion) throws Exception {
        WfDocument doc;
        if (attachToProcess) {
            doc = WordTemplateUtil.attachToProcess(document, processId, activityId, template, documentClass, format, saveAsNewVersion);
        } else {
            FileInputStream input = new FileInputStream(document);
            try {
                DocumentDefinition definition = WordTemplateUtil.getDocDefiniton(processId, template, documentClass, format, input);
                doc = documentService.addDocument(definition);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        docClassActionService.executeProcessActions(doc, DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, processId, activityId);
        return doc;
    }

    public static WfDocument attachToProcess(File f, String process, String activity, String template, String docClass, WordTemplateService.OutputFormat format, boolean saveAsNewVersion) throws Exception {
        FileInputStream is = new FileInputStream(f);
        DocumentDefinition definition = WordTemplateUtil.getDocDefiniton(process, template, docClass, format, is);
        if (saveAsNewVersion) {
            DocumentFinder finder = FinderFactory.getDocumentFinder();
            List documents = finder.getDocumentsFromActivity(process, activity, new String[]{"documentClass"});
            FileService service = ServiceFactory.getFileService();
            WfDocument doc = WordTemplateUtil.getSingleDocument(documents, docClass);
            if (doc != null) {
                service.checkIn(definition, Long.valueOf(doc.getFile().getId()), null);
                return doc;
            }
        }
        WfDocument doc = documentService.addDocument(definition);
        documentService.attachDocumentToProcess(doc, "admin", process, activity);
        return doc;
    }

    private static DocumentDefinition getDocDefiniton(String process, String template, String docClass, WordTemplateService.OutputFormat format, InputStream is) {
        DocumentDefinition definition = new DocumentDefinition();
        String fileName = WordTemplateUtil.getFileName(process, template, format);
        definition.setDocumentClassId(docClassService.getDocumentClass(docClass, new String[0]).getId());
        definition.setFileName(fileName);
        definition.setUserName("admin");
        definition.setDescription(docClass);
        definition.setInputStream(is);
        return definition;
    }

    public static String getFileName(final String processId, final String template, final WordTemplateService.OutputFormat format) {
        SharkTransactionTemplate tx = new SharkTransactionTemplate();
        try {
            return (String)tx.execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

                public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                    String name = WordTemplateUtil.getFileName(transaction, processId, template) + "." + format.toString().toLowerCase();
                    return name.replaceAll("[^\\sa-zA-Z0-9.-]", "_");
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getFileName(SharkTransaction t, String processId, String template) throws Exception {
        WfProcess process = SharkFunctions.getWfProcess((SharkTransaction)t, (String)processId);
        String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)t, (String)processId);
        String processName = LanguageUtils.getProcessName((String)process.name(t), (String)processDefId);
        return template + " - " + processName;
    }

    private static WfDocument getSingleDocument(List<WfDocument> documents, String className) {
        WfDocument document = null;
        for (WfDocument doc : documents) {
            if (!doc.getFile().getDocumentClass().getName().equals(className)) continue;
            if (document == null) {
                document = doc;
                continue;
            }
            return null;
        }
        return document;
    }
}

