/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.FileSaver;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ImportDocumentsFromExcel {
    private Logger log = Logger.getLogger(ImportDocumentsFromExcel.class);

    @AdvancedTask(name="ImportDocumentFromExcel", description="ImportDocumentFromExcel_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importDocuments(@TaskParam(name="Nazwa klasy dokument\u00f3w", description="Nazwa klasy dokument\u00f3w") String docClassName, @TaskParam(name="\u015acie\u017cka do pliku excel'a", description="\u015acie\u017cka do pliku excel'a") String excelFilePath, @TaskParam(name="U\u017cytkownika", description="Login u\u017cytkownika dodaj\u0105cego dokumenty") String uploaderName, @TaskParam(name="Czy zapisa\u0107 jako nowa wersja", description="Okre\u015bla czy dokument ma by\u0107 zapisany jako nowa wersja") boolean saveAsNewVersion) throws Exception {
        DocClassTable dct = this.getDocClassByName(docClassName);
        List<IndexTable> indexList = this.readDocClassIndexesNames(dct.getId());
        ArrayList<String> fields = new ArrayList<String>();
        for (IndexTable it : indexList) {
            fields.add(it.getIndexName());
        }
        fields.add("\u015acie\u017cka");
        fields.add("Opis");
        List<Map<String, Object>> documentsData = this.readDocumentsData(excelFilePath, fields);
        for (Map<String, Object> doc : documentsData) {
            String path = (String)doc.get("\u015acie\u017cka");
            String desc = (String)doc.get("Opis");
            if (StringUtils.isEmpty((String)path)) {
                this.log.warn((Object)"\u015acie\u017cka jest pusta");
                continue;
            }
            File f = new File(path);
            InputStream is = this.readIs(f);
            Map<Long, Object> indexes = this.readIndexes(indexList, doc);
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            FileSaver saver = fs.getFileSaver();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(dct.getId());
            fd.setFileName(f.getName());
            fd.setDescription(desc);
            fd.setUserName(uploaderName);
            fd.setInputStream(is);
            fd.setIndexes(indexes);
            WfFile wfFile = saver.addFile(fd);
        }
    }

    private Map<Long, Object> readIndexes(List<IndexTable> indexList, Map<String, Object> doc) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        for (IndexTable it : indexList) {
            String idxName = it.getIndexName();
            if (!doc.containsKey(idxName) || doc.get(idxName) == null) continue;
            indexes.put(it.getId(), doc.get(idxName));
        }
        return indexes;
    }

    private DocClassTable getDocClassByName(String docClassName) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            DocClassTable dct;
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(DocClassTable.class);
            crit.add((Criterion)Restrictions.eq((String)"docClassName", (Object)docClassName));
            List list = crit.list();
            if (list.isEmpty()) {
                throw new CUFException("Nie znaleziono klasy dokument\u00f3w o nazwie: " + docClassName);
            }
            tx.commit();
            DocClassTable docClassTable = dct = (DocClassTable)list.get(0);
            return docClassTable;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private InputStream readIs(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException("Nie znaleziono pliku: " + f.getAbsolutePath());
        }
        FileInputStream fis = new FileInputStream(f);
        return fis;
    }

    private List<IndexTable> readDocClassIndexesNames(Long docClassId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(IndexTable.class);
            crit.add((Criterion)Restrictions.eq((String)"docclassId", (Object)docClassId));
            List idxList = crit.list();
            tx.commit();
            List list = idxList;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private List<Map<String, Object>> readDocumentsData(String excelFilePath, List<String> fields) throws Exception {
        ExcelReader er = new ExcelReader();
        return er.readExcel(excelFilePath, fields);
    }
}

