/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.HolidaysFunctions;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.email.MailClient;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.i18n.MessageHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CustomEmailSender
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(CustomEmailSender.class);
    private static String sHttpSystemLink;
    private static String sMailServer;
    private static String sSMTPMailServer;
    private static String sSMTPPortNo;
    private static String sSMTPUser;
    private static String sUser;
    private static String sUserPassword;
    private static String sSMTPAuth;
    private static String sEmail;
    private static String sUseSSL;
    private static String sUseSTARTTLS;

    @AdvancedTask(name="sendNewTaskEmail", description="sendNewTaskEmail_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void sendNewTaskEmail(@TaskParam(name="ProcessDefId", description="Id procesu dla ktorego wysylane beda powiadomienia, jesli * tzn ze wszystkie procesy") String sProcessDefId, @TaskParam(name="TaskDefName", description="Nazwa zadania dla ktorego wysylane beda powiadomienia, jesli * tzn ze wszystkie zadania") String sTaskDefName, @TaskParam(name="RecipentType", description="Typ odbiorcy (mozliwe typy to: GROUP, ROLE, POSITION, USER, PERFORMER, PROCESSVARIABLE)") String sRecipentType, @TaskParam(name="IsSuperior", description="Okresla czy powiadomienie wysylane jest do uzytkownika czy jego przelozonego, jesli do uzytkownika to wartosc rozna do TRUE") String sIsSuperior, @TaskParam(name="Recipent", description="Odbiorca powiadomienia zgodnie z wartoscia w zmiennej sRecipentType, jest PERFORMER to pusty") String sRecipentValue, @TaskParam(name="OnlyOwnTask", description="TRUE/FALSE okresla czy wysylac maile tylko dla wykonawcy zadania, nie mozna korzystac z typem odbiorcy PERFORMER bo zawsze wtedy idzie do wykonawcy") String sOnlyOwnTask, @TaskParam(name="GroupSending", description="Okresla czy wysylac pojedyncze maile czy zbiorcze") String sGroupSending, @TaskParam(name="Subject", description="Temat maila") String sSubject, @TaskParam(name="EmailTemplate", description="Sciezka na serwerze do szablonu powiadomienia") String sEmailTemplate) {
        log.info((Object)("sendNewTaskEmail(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ")"));
        this.sendNewTaskEmail(sProcessDefId, sTaskDefName, sRecipentType, sIsSuperior, sRecipentValue, sOnlyOwnTask, sGroupSending, sSubject, sEmailTemplate, "FALSE");
    }

    public void sendNewTaskEmail(String sProcessDefId, String sTaskDefName, String sRecipentType, String sIsSuperior, String sRecipentValue, String sOnlyOwnTask, String sGroupSending, String sSubject, String sEmailTemplate, String sSkipHolidays) {
        log.info((Object)("sendNewTaskEmail( sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ", sSkipHolidays=" + sSkipHolidays + ")"));
        long startTime = new Date().getTime();
        int iHolidaysCheck = -1;
        try {
            CustomEmailSender.readInitialEmailClientSettings();
            if (sSkipHolidays != null && sSkipHolidays.equalsIgnoreCase("TRUE")) {
                Calendar cal = Calendar.getInstance();
                iHolidaysCheck = HolidaysFunctions.checkHoliday(cal, null);
            }
            if (iHolidaysCheck == -1) {
                List<Map<String, String>> alResults;
                HashMap<String, Vector<Map<String, String>>> alRecipentsNotification;
                boolean bSuperior = false;
                boolean bOnlyOwnTask = false;
                if (sIsSuperior.compareTo("TRUE") == 0) {
                    bSuperior = true;
                }
                if (sOnlyOwnTask.compareTo("TRUE") == 0 || !Tools.isNullOrEmpty((String)sRecipentType) && sRecipentType.compareToIgnoreCase("PERFORMER") == 0) {
                    bOnlyOwnTask = true;
                }
                if ((alRecipentsNotification = CustomEmailSender.getAllRecipentsForEmailSending(sRecipentType, sRecipentValue, bSuperior, bOnlyOwnTask, alResults = CustomEmailSender.getProcessAndTaskInformations(sProcessDefId, sTaskDefName))).size() > 0) {
                    alRecipentsNotification.keySet();
                    for (String sRecipent : alRecipentsNotification.keySet()) {
                        Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sRecipent);
                        String sUserEmail = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(sRecipent);
                        if (!Tools.isNullOrEmpty((String)sUserEmail)) {
                            String sEmailToSend = this.PrapareEmailToSend(vRecipentNotification, sGroupSending, sEmailTemplate);
                            log.info((Object)("Wysylam email do uzytkownika < " + sRecipent + "> na adres:" + sUserEmail));
                            this.SendEmail(sUserEmail, sSubject, sEmailToSend);
                            continue;
                        }
                        log.warn((Object)("Nie mozna wysla\u0107 maila do uzytkownika < " + sRecipent + "> gdy\u017c nie ma on ustawionego adresu email"));
                    }
                }
            } else {
                log.info((Object)"Dzis jest swieto, zgodnie z ustawionym parametrem powiadomienia o nowym zadaniu nie beda wysylane");
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego sendNewTaskEmail: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="sendDeadlineTaskEmail", description="sendDeadlineTaskEmail", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void sendDeadlineTaskEmail(@TaskParam(name="ProcessDefId", description="Id procesu dla ktorego wysylane beda powiadomienia, jesli * tzn ze wszystkie procesy") String sProcessDefId, @TaskParam(name="TaskDefName", description="Nazwa zadania dla ktorego wysylane beda powiadomienia, jesli * tzn ze wszystkie zadania") String sTaskDefName, @TaskParam(name="RecipentType", description="Typ odbiorcy (mozliwe typy to: GROUP, ROLE, POSITION, USER, PERFORMER, PROCESSVARIABLE)") String sRecipentType, @TaskParam(name="IsSuperior", description="Okresla czy powiadomienie wysylane jest do uzytkownika czy jego przelozonego, jesli do uzytkownika to wartosc rozna do TRUE") String sIsSuperior, @TaskParam(name="Recipent", description="Odbiorca powiadomienia zgodnie z wartoscia w zmiennej sRecipentType, jest PERFORMER to pusty") String sRecipentValue, @TaskParam(name="OnlyOwnTask", description="TRUE/FALSE okresla czy wysylac maile tylko dla wykonawcy zadania, nie mozna korzystac z typem odbiorcy PERFORMER bo zawsze wtedy idzie do wykonawcy") String sOnlyOwnTask, @TaskParam(name="GroupSending", description="Okresla czy wysylac pojedyncze maile czy zbiorcze") String sGroupSending, @TaskParam(name="Subject", description="Temat maila") String sSubject, @TaskParam(name="EmailTemplate", description="Sciezka na serwerze do szablonu powiadomienia") String sEmailTemplate) {
        log.info((Object)("sendDeadlineTaskEmail(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ")"));
        this.sendDeadlineTaskEmail(sProcessDefId, sTaskDefName, sRecipentType, sIsSuperior, sRecipentValue, sOnlyOwnTask, sGroupSending, sSubject, sEmailTemplate, "FALSE");
    }

    public void sendDeadlineTaskEmail(String sProcessDefId, String sTaskDefName, String sRecipentType, String sIsSuperior, String sRecipentValue, String sOnlyOwnTask, String sGroupSending, String sSubject, String sEmailTemplate, String sSkipHolidays) {
        log.info((Object)("sendDeadlineTaskEmail(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ", sRecipentType=" + sRecipentType + ", sIsSuperior=" + sIsSuperior + ", sRecipentValue=" + sRecipentValue + ", sOnlyOwnTask=" + sOnlyOwnTask + ", sGroupSending=" + sGroupSending + ", sSubject=" + sSubject + ", sEmailTemplate=" + sEmailTemplate + ", sSkipHolidays=" + sSkipHolidays + ")"));
        long startTime = new Date().getTime();
        int iHolidaysCheck = -1;
        try {
            CustomEmailSender.readInitialEmailClientSettings();
            if (sSkipHolidays != null && sSkipHolidays.equalsIgnoreCase("TRUE")) {
                Calendar cal = Calendar.getInstance();
                iHolidaysCheck = HolidaysFunctions.checkHoliday(cal, null);
            }
            if (iHolidaysCheck == -1) {
                List<Map<String, String>> alResults;
                HashMap<String, Vector<Map<String, String>>> alRecipentsNotification;
                boolean bSuperior = false;
                boolean bOnlyOwnTask = false;
                if (sIsSuperior.compareTo("TRUE") == 0) {
                    bSuperior = true;
                }
                if (sOnlyOwnTask.compareTo("TRUE") == 0 || !Tools.isNullOrEmpty((String)sRecipentType) && sRecipentType.compareToIgnoreCase("PERFORMER") == 0) {
                    bOnlyOwnTask = true;
                }
                if ((alRecipentsNotification = CustomEmailSender.getAllRecipentsForEmailSending(sRecipentType, sRecipentValue, bSuperior, bOnlyOwnTask, alResults = CustomEmailSender.getDeadlineTasksInformations(sProcessDefId, sTaskDefName))).size() > 0) {
                    alRecipentsNotification.keySet();
                    for (String sRecipent : alRecipentsNotification.keySet()) {
                        Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sRecipent);
                        String sUserEmail = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(sRecipent);
                        if (!Tools.isNullOrEmpty((String)sUserEmail)) {
                            String sEmailToSend = this.PrapareEmailToSend(vRecipentNotification, sGroupSending, sEmailTemplate);
                            log.info((Object)("Wysylam email do uzytkownika < " + sRecipent + "> na adres:" + sUserEmail));
                            this.SendEmail(sUserEmail, sSubject, sEmailToSend);
                            continue;
                        }
                        log.warn((Object)("Nie mozna wysla\u0107 maila do uzytkownika < " + sRecipent + "> gdy\u017c nie ma on ustawionego adresu email"));
                    }
                }
            } else {
                log.info((Object)"Dzis jest swieto, zgodnie z ustawionym parametrem powiadomienia o przekroczeniu deadline'u nie beda wysylane");
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego sendDeadlineTaskEmail: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static void readInitialEmailClientSettings() {
        log.trace((Object)"************ readInitialEmailClientSettings() ************");
        sHttpSystemLink = Shark.getInstance().getProperties().getProperty("HTTPLink");
        sMailServer = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.MailServer");
        sSMTPMailServer = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.SMTPMailServer");
        sSMTPPortNo = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.SMTPPortNo");
        sSMTPUser = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.SMTPUser");
        sUser = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.User");
        sUserPassword = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.UserPassword");
        sSMTPAuth = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.SMTPAuth");
        sEmail = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.Email");
        sUseSSL = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.UseSSL");
        sUseSTARTTLS = Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler.UseSTARTTLS");
    }

    private static HashMap<String, Vector<Map<String, String>>> getAllRecipentsForEmailSending(String sRecipentType, String sRecipentValue, boolean bSuperior, boolean bOnlyOwnTask, List<Map<String, String>> alTaskResults) {
        log.trace((Object)("************ getAllRecipentsForEmailSending(sRecipentType=" + sRecipentType + ", sRecipentValue=" + sRecipentValue + ", bSuperior=" + String.valueOf(bSuperior) + ", bOnlyOwnTask=" + String.valueOf(bOnlyOwnTask) + ", List<Map<String, String>>) ************"));
        HashMap<String, Vector<Map<String, String>>> alRecipentsNotification = new HashMap<String, Vector<Map<String, String>>>();
        for (Map<String, String> mapResult : alTaskResults) {
            String sPerformer;
            if (bOnlyOwnTask) {
                sPerformer = mapResult.get("resourceid");
                if (bSuperior || !CustomEmailSender.checkPerformerAsRecipent(sPerformer, sRecipentType, sRecipentValue)) continue;
                Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sPerformer);
                if (vRecipentNotification == null) {
                    vRecipentNotification = new Vector();
                }
                vRecipentNotification.add(mapResult);
                alRecipentsNotification.put(sPerformer, vRecipentNotification);
                continue;
            }
            if (!bSuperior) continue;
            sPerformer = mapResult.get("resourceid");
            ArrayList alSuperiors = UsersManagement.getUserSuperior((String)sPerformer);
            for (String sSuperior : alSuperiors) {
                if (!CustomEmailSender.checkPerformerAsRecipent(sSuperior, sRecipentType, sRecipentValue)) continue;
                Vector<Map<String, String>> vRecipentNotification = alRecipentsNotification.get(sSuperior);
                if (vRecipentNotification == null) {
                    vRecipentNotification = new Vector();
                }
                vRecipentNotification.add(mapResult);
                alRecipentsNotification.put(sSuperior, vRecipentNotification);
            }
        }
        return alRecipentsNotification;
    }

    private static boolean checkPerformerAsRecipent(String sUserId, String sRecipentType, String sRecipentValue) {
        log.trace((Object)("************ checkPerformerAsRecipent(sUserId=" + sUserId + ", sRecipentType=" + sRecipentType + ", sRecipentValue=" + sRecipentValue + ") ************"));
        boolean bRet = true;
        return bRet;
    }

    public static List<Map<String, String>> getProcessAndTaskInformations(String sProcessDefId, String sTaskDefName) throws Exception {
        log.trace((Object)("************ getProcessAndTaskInformations(sProcessDefId=" + sProcessDefId + ", sTaskDefName=" + sTaskDefName + ") ************"));
        ArrayList<Map<String, String>> alResults = new ArrayList<Map<String, String>>();
        String sQuery = "SELECT processes.name processname, processes.started processstarttime, assignmentstable.activityid activityid,assignmentstable.activityprocessid processid, activities.activated activitystarttime, assignmentstable.resourceid resourceid,activities.name activityname, processdefinitions.processdefinitionid processdefid  FROM assignmentstable JOIN  activities ON assignmentstable.activityid = activities.id JOIN  processes ON assignmentstable.activityprocessid = processes.id JOIN  processdefinitions ON assignmentstable.activityprocessdefname = processdefinitions.name ";
        I18N oMessage = new I18N();
        LinkedHashMap<String, Type> hmQueryIds = new LinkedHashMap<String, Type>();
        HashMap<String, String> hmWhereCondition = new HashMap<String, String>();
        hmQueryIds.put("processname", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("processstarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("activityid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("activitystarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("processid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("resourceid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("activityname", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("processdefid", (Type)StandardBasicTypes.STRING);
        StringBuilder sbQuery = new StringBuilder(sQuery);
        boolean isWhereAdd = false;
        if (!Tools.isNullOrEmpty((String)sProcessDefId) && sProcessDefId.compareTo("*") != 0) {
            isWhereAdd = true;
            sbQuery.append("WHERE ");
            sbQuery.append("processdefinitions.processdefinitionid=(:processDefId) ");
            hmWhereCondition.put("processDefId", sProcessDefId);
        }
        if (!Tools.isNullOrEmpty((String)sTaskDefName)) {
            if (!isWhereAdd) {
                sbQuery.append("WHERE ");
            } else {
                sbQuery.append("AND ");
            }
            if (sTaskDefName.indexOf("*") != -1) {
                sbQuery.append("activities.name LIKE(:activityname)");
                sTaskDefName = sTaskDefName.replace("*", "%");
            } else {
                sbQuery.append("activities.name=(:activityname)");
            }
            hmWhereCondition.put("activityname", sTaskDefName);
        }
        sQuery = sbQuery.toString();
        log.debug((Object)("Query:" + sQuery));
        List<Object[]> result = CustomEmailSender.createHibrenateQuery(sQuery, hmQueryIds, hmWhereCondition);
        Set<String> setQueryIds = hmQueryIds.keySet();
        for (Object[] row : result) {
            int i = 0;
            HashMap<String, String> hmRow = new HashMap<String, String>();
            for (String sQueryIdsKeyIterator : setQueryIds) {
                Object column = row[i];
                ++i;
                if (column instanceof Long) {
                    hmRow.put(sQueryIdsKeyIterator, ((Long)column).toString());
                    continue;
                }
                hmRow.put(sQueryIdsKeyIterator, (String)column);
            }
            alResults.add(hmRow);
        }
        return alResults;
    }

    public static List<Map<String, String>> getDeadlineTasksInformations(String sProcessDefId, String sTaskDefName) throws Exception {
        log.trace((Object)("************ getDeadlineTasksInformations(sProcessDefId=, sTaskDefName=" + sTaskDefName + ") ************"));
        ArrayList<Map<String, String>> alResults = new ArrayList<Map<String, String>>();
        String dbName = HibernateUtil.getDatabaseVendor().name();
        String sQuery = "";
        if (dbName.equalsIgnoreCase("MicrosoftSQLServer")) {
            sQuery = sQuery + "SELECT Round(((((getdate() - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 60 * 60) - (TIMELIMIT/1000))/3600/24),2) deadlinetime, ";
        } else if (dbName.equalsIgnoreCase("PostgreSQL")) {
            sQuery = sQuery + "SELECT Round(((((current_date - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 60 * 60) - (TIMELIMIT/1000))/3600/24),2) deadlinetime, ";
        } else if (dbName.startsWith("Oracle")) {
            sQuery = sQuery + "SELECT Round(((((SYSDATE - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 60 * 60) - (TIMELIMIT/1000))/3600/24),2) deadlinetime, ";
        } else {
            throw new Exception("Database: " + dbName + " is not handled ");
        }
        sQuery = sQuery + "processes.name processname, processes.started processstarttime, assignmentstable.activityid activityid,assignmentstable.activityprocessid processid, activities.activated activitystarttime, assignmentstable.resourceid resourceid,activities.name activityname, processdefinitions.processdefinitionid processdefid  FROM assignmentstable JOIN  activities ON assignmentstable.activityid = activities.id JOIN processes ON assignmentstable.activityprocessid = processes.id JOIN processdefinitions ON assignmentstable.activityprocessdefname = processdefinitions.name JOIN deadlines ON assignmentstable.activity = deadlines.activity ";
        I18N oMessage = new I18N();
        LinkedHashMap<String, Type> hmQueryIds = new LinkedHashMap<String, Type>();
        HashMap<String, String> hmWhereCondition = new HashMap<String, String>();
        hmQueryIds.put("processname", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("processstarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("activityid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("activitystarttime", (Type)StandardBasicTypes.LONG);
        hmQueryIds.put("processid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("resourceid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("activityname", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("processdefid", (Type)StandardBasicTypes.STRING);
        hmQueryIds.put("deadlinetime", (Type)StandardBasicTypes.DOUBLE);
        StringBuilder sbQuery = new StringBuilder(sQuery);
        boolean isWhereAdd = false;
        if (!Tools.isNullOrEmpty((String)sProcessDefId) && sProcessDefId.compareTo("*") != 0) {
            isWhereAdd = true;
            sbQuery.append("WHERE ");
            sbQuery.append("processdefinitions.processdefinitionid=(:processDefId) ");
            hmWhereCondition.put("processDefId", sProcessDefId);
        }
        if (!Tools.isNullOrEmpty((String)sTaskDefName)) {
            if (!isWhereAdd) {
                sbQuery.append("WHERE ");
            } else {
                sbQuery.append("AND ");
            }
            if (sTaskDefName.indexOf("*") != -1) {
                sbQuery.append("activities.name LIKE(:activityname)");
                sTaskDefName = sTaskDefName.replace("*", "%");
            } else {
                sbQuery.append("activities.name=(:activityname)");
            }
            hmWhereCondition.put("activityname", sTaskDefName);
        }
        sQuery = sbQuery.toString();
        log.debug((Object)("Query:" + sQuery));
        List<Object[]> result = CustomEmailSender.createHibrenateQuery(sQuery, hmQueryIds, hmWhereCondition);
        Set<String> setQueryIds = hmQueryIds.keySet();
        for (Object[] row : result) {
            int i = 0;
            HashMap<String, String> hmRow = new HashMap<String, String>();
            for (String sQueryIdsKeyIterator : setQueryIds) {
                Object column = row[i];
                ++i;
                if (column instanceof Long) {
                    hmRow.put(sQueryIdsKeyIterator, ((Long)column).toString());
                    continue;
                }
                if (column instanceof Double) {
                    hmRow.put(sQueryIdsKeyIterator, ((Double)column).toString());
                    continue;
                }
                hmRow.put(sQueryIdsKeyIterator, (String)column);
            }
            alResults.add(hmRow);
        }
        return alResults;
    }

    private String PrapareEmailToSend(Vector<Map<String, String>> vRecipentNotification, String sGroupSending, String sEmailTemplate) {
        log.trace((Object)("************ PrapareEmailToSend(Vector<Map<String, String>>, sGroupSending=" + sGroupSending + ", sEmailTemplate=" + sEmailTemplate + ") ************"));
        String sNewEmailContent = null;
        boolean bGroupSending = false;
        if (!Tools.isNullOrEmpty((String)sGroupSending) && sGroupSending.compareToIgnoreCase("TRUE") == 0) {
            bGroupSending = true;
        }
        try {
            String sEmailContent = CustomEmailSender.getEmailContentFromFile(sEmailTemplate);
            if (bGroupSending) {
                int iStartPos = sEmailContent.indexOf("@@rows@@");
                int iEndPos = sEmailContent.indexOf("@@end_rows@@");
                String sRow = sEmailContent.substring(iStartPos + 8, iEndPos);
                StringBuilder sbNewRow = new StringBuilder();
                for (Map<String, String> mapTaskParams : vRecipentNotification) {
                    sbNewRow.append(CustomEmailSender.PrepareEmailContent(sRow, mapTaskParams));
                }
                String sStartPart = sEmailContent.substring(0, iStartPos);
                String sEndPart = sEmailContent.substring(iEndPos + 12);
                sStartPart = CustomEmailSender.PrepareEmailContent(sStartPart, null);
                sEndPart = CustomEmailSender.PrepareEmailContent(sEndPart, null);
                sNewEmailContent = sStartPart + sbNewRow.toString() + sEndPart;
            } else {
                for (Map<String, String> mapTaskParams : vRecipentNotification) {
                    sNewEmailContent = CustomEmailSender.PrepareEmailContent(sEmailContent, mapTaskParams);
                }
            }
            return sNewEmailContent;
        }
        catch (FileNotFoundException e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BaseException e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String PrepareEmailContent(String sRow, Map<String, String> mapTaskParams) throws BaseException {
        log.trace((Object)("************ PrepareEmailContent(sRow=" + sRow + ", Map<String, String>) ************"));
        if (mapTaskParams == null) {
            return sRow;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DBManagement.CONST_ONLYDATEFORMAT);
        SimpleDateFormat sdftime = new SimpleDateFormat(DBManagement.CONST_SHORTTIMEFORMAT);
        Date dateActivity = new Date(Long.valueOf(mapTaskParams.get("activitystarttime")));
        String sActivityDate = sdf.format(dateActivity);
        String sActivityTime = sdftime.format(dateActivity);
        Date dateProcess = new Date(Long.valueOf(mapTaskParams.get("processstarttime")));
        String sProcessDate = sdf.format(dateProcess);
        String sProcessTime = sdftime.format(dateProcess);
        sRow = sRow.replaceAll("(@processtype@)", mapTaskParams.get("processdefid"));
        sRow = sRow.replaceAll("(@processname@)", mapTaskParams.get("processname"));
        sRow = sRow.replaceAll("(@activitystarttime@)", sActivityTime);
        sRow = sRow.replaceAll("(@activitystartday@)", sActivityDate);
        sRow = sRow.replaceAll("(@processstartday@)", sProcessDate);
        sRow = sRow.replaceAll("(@processstarttime@)", sProcessTime);
        sRow = sRow.replaceAll("(@activityname@)", mapTaskParams.get("activityname"));
        sRow = sRow.replaceAll("(@deadlinetime@)", mapTaskParams.get("deadlinetime"));
        String sLink = sHttpSystemLink + "/ProcesActivity.do?processKey=" + mapTaskParams.get("processid") + "&activityId=" + mapTaskParams.get("activityid");
        sLink = "<A Href=" + sLink + ">" + MessageHelper.getMessage((String)"Przejdz_do_zadania") + "</A>";
        sRow = sRow.replaceAll("(@link@)", sLink);
        WfProcess wfProcess = SharkFunctions.getWfProcess((String)mapTaskParams.get("processid"));
        Map processContext = SharkFunctions.GetProcessContext((WfProcess)wfProcess);
        for (String sVariableName : processContext.keySet()) {
            Object objValue = processContext.get(sVariableName);
            if (objValue != null) {
                String sValue = objValue.toString();
                sRow = sRow.replaceAll("(@" + sVariableName + "@)", sValue);
                if (!Shark.getInstance().getAdminInterface().getUserGroupAdministration().doesUserExist(sValue)) continue;
                String sRealName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(sValue);
                sRow = sRow.replaceAll("(@realusername_" + sVariableName + "@)", sRealName);
                continue;
            }
            sRow = sRow.replaceAll("(@" + sVariableName + "@)", "");
        }
        return sRow;
    }

    private static String getEmailContentFromFile(String sEmailTemplate) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        log.trace((Object)("************ getEmailContentFromFile(sEmailTemplate=" + sEmailTemplate + ") ************"));
        StringBuilder sbEmailContent = new StringBuilder();
        FileInputStream fis = new FileInputStream(sEmailTemplate);
        BufferedInputStream bis = new BufferedInputStream(fis);
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)bis, "UTF8"));
        String sLine = null;
        while ((sLine = d.readLine()) != null) {
            sbEmailContent.append(sLine).append("\n");
        }
        fis.close();
        return sbEmailContent.toString();
    }

    private void SendEmail(String recepient, String sEmailSubcject, String sEmailContent) {
        log.trace((Object)("************ SendEmail(recepient=" + recepient + ", sEmailSubcject=" + sEmailSubcject + ", sEmailContent) ************"));
        Timer timer2 = new Timer();
        final String finalRecepient = recepient;
        final String emailSubcject = sEmailSubcject;
        final String emailContent = sEmailContent;
        timer2.schedule(new TimerTask(){

            @Override
            public void run() {
                block6: {
                    try {
                        log.debug((Object)"******************************SendEmail********************");
                        try {
                            double dRand = Math.random() * 10000.0;
                            MailClient oMailClient = new MailClient(sUser, sSMTPUser, sUserPassword, sMailServer, sSMTPMailServer, sSMTPPortNo, sSMTPAuth, false, sEmail, sUseSSL, sUseSTARTTLS);
                            log.info((Object)("Wysylanie maila z adresu " + sUser + " do uzytkownika:" + finalRecepient));
                            Thread.sleep((long)dRand);
                            if (finalRecepient != null && finalRecepient.compareToIgnoreCase("") != 0) {
                                oMailClient.sendMessage(finalRecepient, emailSubcject, emailContent, true);
                                log.info((Object)("Wyslanie maila z adresu " + sUser + " do uzytkownika:" + finalRecepient + " powiodlo sie."));
                                break block6;
                            }
                            log.warn((Object)"Empty finalRecepient.");
                        }
                        catch (MessagingException e) {
                            taskLog.debug((Object)e.getMessage());
                            log.error((Object)("Exception in SendEmail :" + e.getMessage()), (Throwable)e);
                        }
                        catch (Exception e) {
                            taskLog.debug((Object)e.getMessage());
                            log.error((Object)("Exception in SendEmail :" + e.getMessage()), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        taskLog.debug((Object)e.getMessage());
                        log.error((Object)("Exception in SendEmail :" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }, 5000L);
    }

    private static List<Object[]> createHibrenateQuery(String sQuery, LinkedHashMap<String, Type> hmQueryIds, HashMap<String, String> hmWhereCondition) throws Exception {
        Session session = HibernateUtil.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            SQLQuery sqlQuery = session.createSQLQuery(sQuery);
            Set<String> setWhereCondition = hmWhereCondition.keySet();
            for (String string : setWhereCondition) {
                String sValue = hmWhereCondition.get(string);
                log.debug((Object)("Condition:" + string + " value: " + sValue));
                sqlQuery.setString(string, sValue);
            }
            Set<String> setQueryIds = hmQueryIds.keySet();
            for (String sQueryIdsKey : setQueryIds) {
                sqlQuery.addScalar(sQueryIdsKey, hmQueryIds.get(sQueryIdsKey));
            }
            List list = sqlQuery.list();
            transaction.commit();
            return list;
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (HibernateException he1) {
                log.error((Object)"", (Throwable)he1);
            }
            throw e;
        }
    }
}

