/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ActivityAcceptor;
import com.plusmpm.CUF.util.extension.ActivityManager;
import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.ProcessManager;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcceptActivity {
    private Logger log = Logger.getLogger(AcceptActivity.class);
    private ActivityAcceptor acceptor = new ActivityAcceptor();

    public Map<String, Object> convertStrToMap(String str) {
        String[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Tools.isNullOrEmpty((String)str)) {
            return map;
        }
        str = str.trim();
        String markerTmp = "<sunCodeMarkerTmp>";
        String marker = "<sunCodeMarker>";
        str = str.replaceAll("\\\\;", markerTmp);
        str = str.replaceAll(";", marker);
        str = str.replaceAll(markerTmp, ";");
        for (String field : fields = str.split(marker)) {
            String[] f;
            if (field.isEmpty() || (f = field.split("=")).length != 2) continue;
            map.put(f[0], f[1]);
        }
        return map;
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivity(@TaskParam(name="Identyfikator zadania", description="Identyfikator zadania") String activityId, @TaskParam(name="Identyfikator procesu", description="Identyfikator procesu") String processId, @TaskParam(name="Nazwa akcji", description="Nazwa akcji") String actionName, @TaskParam(name="Login u\u017cytkownika", description="Login u\u017cytkownika") String userName, @TaskParam(name="Has\u0142o u\u017cytkownika", description="Has\u0142o u\u017cytkownika") String password, @TaskParam(name="Zmienne procesu", description="Zmienne procesu postaci: nazwa=warto\u015b\u0107;nazwa2=wartosc...") String variables) throws Throwable {
        activityId = this.readParam(activityId);
        processId = this.readParam(processId);
        actionName = this.readParam(actionName);
        userName = this.readParam(userName);
        password = this.readParam(password);
        variables = this.readParam(variables);
        Map<String, Object> contextMap = this.convertStrToMap(variables);
        this.acceptor.acceptActivity(activityId, processId, actionName, userName, password, contextMap);
    }

    private String readParam(String param) {
        if (param == null) {
            return null;
        }
        if (Tools.isNullOrEmpty((String)(param = param.trim())) || param.equals("null")) {
            param = null;
        }
        return param;
    }

    private Date readDate(String sDate) throws ParseException {
        Date date = null;
        if (!Tools.isNullOrEmpty((String)sDate)) {
            try {
                date = new SimpleDateFormat("yyyy/MM/DD HH:mm").parse(sDate);
            }
            catch (ParseException e) {
                this.log.error((Object)"Data ma nieodpowiedni format");
                throw e;
            }
        }
        return date;
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivityByName(@TaskParam(name="Nazwa procesu", description="Nazwa procesu") String processName, @TaskParam(name="Nazwa zadania", description="Nazwa zadania") String activityName, @TaskParam(name="Nazwa akcji", description="Nazwa akcji") String actionName, @TaskParam(name="Typ kolejnego parametru", description="role, group lub userName") String resourceType, @TaskParam(name="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru", description="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru") String resourceName, @TaskParam(name="Login u\u017cytkownika", description="Login u\u017cytkownika") String userName, @TaskParam(name="Has\u0142o u\u017cytkownika", description="Has\u0142o u\u017cytkownika") String password, @TaskParam(name="Zmienne procesu", description="Zmienne procesu postaci: nazwa=warto\u015b\u0107;nazwa2=wartosc...") String variables, @TaskParam(name="Data pocz\u0105tkowa", description="Data pocz\u0105tkowa") String sStartDateFrom, @TaskParam(name="Data ko\u0144cowa", description="Data ko\u0144cowa") String sStartDateTo, @TaskParam(name="Wersja pakietu", description="Wersja pakietu") int xpdlVersion) throws Throwable {
        processName = this.readParam(processName);
        activityName = this.readParam(activityName);
        activityName = this.readParam(activityName);
        resourceType = this.readParam(resourceType);
        resourceName = this.readParam(resourceName);
        resourceName = this.readParam(resourceName);
        password = this.readParam(password);
        variables = this.readParam(variables);
        sStartDateFrom = this.readParam(sStartDateFrom);
        sStartDateTo = this.readParam(sStartDateTo);
        Date startDateFrom = this.readDate(sStartDateFrom);
        Date startDateTo = this.readDate(sStartDateTo);
        Map<String, Object> contextMap = this.convertStrToMap(variables);
        this.acceptor.acceptActivityByName(processName, activityName, actionName, resourceType, resourceName, userName, password, contextMap, startDateFrom, startDateTo, xpdlVersion);
        this.log.debug((Object)"zadanie zako\u0144czone pomy\u015blnie");
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivities(@TaskParam(name="Identyfikator definicji procesu", description="Identyfikator definicji procesu") String processDefId, @TaskParam(name="Identyfikator definicji zadania", description="Identyfikator definicji zadania") String activityDefId, @TaskParam(name="Nazwa akcji", description="Nazwa akcji") String actionName, @TaskParam(name="Typ kolejnego parametru", description="role, group lub userName") String resourceType, @TaskParam(name="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru", description="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru") String resourceName, @TaskParam(name="Login u\u017cytkownika", description="Login u\u017cytkownika") String userName, @TaskParam(name="Has\u0142o u\u017cytkownika", description="Has\u0142o u\u017cytkownika") String password, @TaskParam(name="Zmienne procesu", description="Zmienne procesu postaci: nazwa=warto\u015b\u0107;nazwa2=wartosc...") String variables, @TaskParam(name="Data pocz\u0105tkowa", description="Data pocz\u0105tkowa") String sStartDateFrom, @TaskParam(name="Data ko\u0144cowa", description="Data ko\u0144cowa") String sStartDateTo, @TaskParam(name="Wersja pakietu", description="Wersja pakietu") int xpdlVersion) throws Throwable {
        processDefId = this.readParam(processDefId);
        activityDefId = this.readParam(activityDefId);
        actionName = this.readParam(actionName);
        resourceType = this.readParam(resourceType);
        resourceName = this.readParam(resourceName);
        userName = this.readParam(userName);
        password = this.readParam(password);
        variables = this.readParam(variables);
        sStartDateFrom = this.readParam(sStartDateFrom);
        sStartDateTo = this.readParam(sStartDateTo);
        Date startDateFrom = this.readDate(sStartDateFrom);
        Date startDateTo = this.readDate(sStartDateTo);
        Map<String, Object> contextMap = this.convertStrToMap(variables);
        this.acceptor.acceptActivities(processDefId, activityDefId, actionName, resourceType, resourceName, userName, password, contextMap, startDateFrom, startDateTo, xpdlVersion);
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivitiesWithoutActions(@TaskParam(name="Identyfikator definicji procesu", description="Identyfikator definicji procesu") String processDefId, @TaskParam(name="Identyfikator definicji zadania", description="Identyfikator definicji zadania") String activityDefId, @TaskParam(name="Nazwa akcji", description="Nazwa akcji") String actionName, @TaskParam(name="Typ kolejnego parametru", description="role, group lub userName") String resourceType, @TaskParam(name="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru", description="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru") String resourceName, @TaskParam(name="Login u\u017cytkownika", description="Login u\u017cytkownika") String userName, @TaskParam(name="Has\u0142o u\u017cytkownika", description="Has\u0142o u\u017cytkownika") String password, @TaskParam(name="Zmienne procesu", description="Zmienne procesu postaci: nazwa=warto\u015b\u0107;nazwa2=wartosc...") String variables, @TaskParam(name="Data pocz\u0105tkowa", description="Data pocz\u0105tkowa") String sStartDateFrom, @TaskParam(name="Data ko\u0144cowa", description="Data ko\u0144cowa") String sStartDateTo, @TaskParam(name="Wersja pakietu", description="Wersja pakietu") int xpdlVersion) throws Throwable {
        this.acceptor.setAcceptWithoutActions(true);
        this.acceptActivities(processDefId, activityDefId, actionName, resourceType, resourceName, userName, password, variables, sStartDateFrom, sStartDateTo, xpdlVersion);
        this.acceptor.setAcceptWithoutActions(false);
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivitiesFromFile(@TaskParam(name="\u015acie\u017cka do pliku", description="\u015acie\u017cka do pliku") String path) throws Throwable {
        if (Tools.isNullOrEmpty((String)(path = path.trim()))) {
            throw new IllegalArgumentException("Nie podano \u015bcie\u017cki do pliku");
        }
        ExcelReader er = new ExcelReader();
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        String[] cols = new String[]{"activityId", "actionName", "userName", "variables"};
        List<Map<String, Object>> data = er.readExcel(fis, Arrays.asList(cols));
        for (Map<String, Object> map : data) {
            String activityId = (String)map.get(cols[0]);
            String actionName = (String)map.get(cols[1]);
            String userName = (String)map.get(cols[2]);
            String variables = (String)map.get(cols[3]);
            this.acceptActivity(activityId, null, actionName, userName, null, variables);
        }
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivitiesByNames(@TaskParam(name="Nazwa definicji procesu", description="Nazwa definicji procesu") String processDefName, @TaskParam(name="Nazwa definicji zadania", description="Nazwa definicji zadania") String activityDefName, @TaskParam(name="Nazwa akcji", description="Nazwa akcji") String actionName, @TaskParam(name="Typ kolejnego parametru", description="role, group lub userName") String resourceType, @TaskParam(name="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru", description="Warto\u015b\u0107 zale\u017cna od poprzedniego parametru") String resourceName, @TaskParam(name="Login u\u017cytkownika", description="Login u\u017cytkownika") String userName, @TaskParam(name="Has\u0142o u\u017cytkownika", description="Has\u0142o u\u017cytkownika") String password, @TaskParam(name="Zmienne procesu", description="Zmienne procesu postaci: nazwa=warto\u015b\u0107;nazwa2=wartosc...") String variables, @TaskParam(name="Data pocz\u0105tkowa", description="Data pocz\u0105tkowa") String sStartDateFrom, @TaskParam(name="Data ko\u0144cowa", description="Data ko\u0144cowa") String sStartDateTo, @TaskParam(name="Wersja pakietu", description="Wersja pakietu") int xpdlVersion) throws Throwable {
        ProcessManager pm = new ProcessManager();
        ActivityManager am = new ActivityManager();
        String processDefId = pm.getProcessDefIdByProcessName(processDefName);
        if (processDefId == null) {
            throw new IllegalArgumentException("Nie znaleziono procesu o podanej nazwie");
        }
        String activityDefId = am.getActivityDefIdByName(processDefId, activityDefName);
        if (activityDefId == null) {
            throw new IllegalArgumentException("Nie znaleziono zadania o podanej nazwie");
        }
        this.acceptActivities(processDefId, activityDefId, actionName, resourceType, resourceName, userName, password, variables, sStartDateFrom, sStartDateTo, xpdlVersion);
    }
}

