/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WordTemplateService {
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private DocumentTemplateService templateService;

    private void generate(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format) {
        DocumentTemplateTable template = this.templateService.getByName(templateName, new String[0]);
        if (template == null) {
            throw new IllegalArgumentException("Document template with name [" + templateName + "] not found");
        }
        String templatePath = template.getTemplatePath();
        String outputPath = output.getAbsolutePath();
        Map context = null;
        context = activityId != null ? this.activityService.getActivityContext(processId, activityId) : this.processService.getProcessContext(processId);
        if (mappings != null && !mappings.isEmpty()) {
            context.putAll(mappings);
        }
        PrepeareDoc.prepareDocument(templatePath, outputPath, context, null, "@", processId, null, null, format == OutputFormat.PDF);
    }

    public void generateForProcess(File output, String templateName, String processId, OutputFormat format) {
        this.generate(output, templateName, processId, null, null, format);
    }

    public void generateForProcess(File output, String templateName, String processId, Map<String, Object> mappings, OutputFormat format) {
        this.generate(output, templateName, processId, null, mappings, format);
    }

    public void generateForActivity(File output, String templateName, String processId, String activityId, OutputFormat format) {
        this.generate(output, templateName, processId, activityId, null, format);
    }

    public void generateForActivity(File output, String templateName, String processId, String activityId, Map<String, Object> mappings, OutputFormat format) {
        this.generate(output, templateName, processId, activityId, mappings, format);
    }

    public static enum OutputFormat {
        PDF,
        DOCX;

    }
}

