/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.form.datachooser.definition;

import com.plusmpm.util.form.datachooser.CustomKeys;
import com.plusmpm.util.form.datachooser.Definition;
import com.plusmpm.util.form.datachooser.FormCriteria;
import com.plusmpm.util.form.datachooser.Mappings;
import com.plusmpm.util.form.datachooser.StandardDataChooserDef;
import com.suncode.cuf.form.datachooser.UserChooser;
import com.suncode.cuf.i18n.CufMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class UserChooserDef
implements StandardDataChooserDef {
    private Class<?> dcClass = UserChooser.class;

    public List<CustomKeys> getCustomKeys(String id, String lang) {
        String[][] fcs = new String[][]{{"excludedGroups", "excluded_group_names", null, null}, {"groups", "group_names", null, null}, {"excludedUsers", "excluded_users", null, null}, {"roles", "role_ids", null, null}, {"ouSymbols", "org_unit_symbols", null, null}, {"subOrgUnits", "take_sub_org_units", "false", null}, {"joinSuperiors", "join_superiors", "false", null}, {"joinOrgUnits", "join_org_units", "false", null}, {"filterBy", "filter_field_names", null, null}, {"sortBy", "sorty_definition", null, null}};
        List<CustomKeys> crit = this.buildCustomKeys(fcs);
        return crit;
    }

    private List<CustomKeys> buildCustomKeys(String[][] fcs) {
        ArrayList<CustomKeys> crit = new ArrayList<CustomKeys>();
        for (String[] f : fcs) {
            CustomKeys fc = new CustomKeys();
            fc.setId(f[0]);
            fc.setDescr(CufMessages.get(f[1], new Object[0]));
            fc.setValue(f[2]);
            if (StringUtils.isNotBlank((CharSequence)f[3])) {
                fc.setAvailableValues(f[3].split(";"));
            }
            crit.add(fc);
        }
        return crit;
    }

    public Definition getDef(String id, String lang) {
        Locale locale = new Locale(lang);
        Definition def = new Definition();
        def.setClasspath(this.dcClass.getName());
        def.setDescr(CufMessages.get("userchooser_desc", locale, new Object[0]));
        def.setName(CufMessages.get("userchooser", new Object[0]));
        return def;
    }

    public List<FormCriteria> getFormCriteria(String id, String lang) {
        String[][] fcs = new String[][]{{"userName", "login"}, {"firstName", "first_name"}, {"lastName", "last_name"}, {"fullName", "full_name"}, {"reverseName", "reverse_name"}, {"email", "email"}, {"orgUnit", "org_unit"}, {"superiorsNames", "superiors_names"}, {"superiors", "superiors"}};
        List<FormCriteria> crit = this.buildCriteria(fcs);
        return crit;
    }

    private List<FormCriteria> buildCriteria(String[][] fcs) {
        ArrayList<FormCriteria> crit = new ArrayList<FormCriteria>();
        for (String[] f : fcs) {
            FormCriteria fc = new FormCriteria();
            fc.setVarId(f[0]);
            fc.setDescr(CufMessages.get(f[1], new Object[0]));
            crit.add(fc);
        }
        return crit;
    }

    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.dcClass.getName());
        return ids;
    }

    public List<Mappings> getMappings(String id, String lang) {
        String[][] fcs = new String[][]{{"userName", "login"}, {"firstName", "first_name"}, {"lastName", "last_name"}, {"fullName", "full_name"}, {"reverseName", "reverse_name"}, {"email", "email"}, {"orgUnit", "org_unit"}, {"superiorsNames", "superiors_names"}, {"superiors", "superiors"}};
        List<Mappings> crit = this.buildMappings(fcs);
        return crit;
    }

    private List<Mappings> buildMappings(String[][] fcs) {
        ArrayList<Mappings> crit = new ArrayList<Mappings>();
        for (String[] f : fcs) {
            Mappings fc = new Mappings();
            fc.setVarId(f[0]);
            fc.setDescr(CufMessages.get(f[1], new Object[0]));
            fc.setDisplay(CufMessages.get(f[1], new Object[0]));
            fc.setId(f[0]);
            crit.add(fc);
        }
        return crit;
    }
}

