/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.administartion.structure.internal;

import com.suncode.cuf.administartion.structure.RoleHelper;
import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.util.exception.ServiceException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleHelperImpl
implements RoleHelper {
    private static final Logger log = ContextLogger.getLogger(RoleHelperImpl.class);
    @Autowired
    private RoleService roleService;

    @Override
    public Role getRole(String roleId) {
        return this.getRole(roleId, null);
    }

    @Override
    public Role getRole(String roleId, CellValue<String> cell) {
        String[] tab = roleId.split(":");
        if (tab.length != 3 && tab.length != 2) {
            String message = "Nieprawid\u0142owy format id roli: " + roleId + ". Format powinien mie\u0107 posta\u0107: packageId:processDefId:roleId";
            if (cell != null) {
                message = message + ". Prosz\u0119 sprawdzi\u0107 arkusz: " + cell.getSheetName() + " kom\u00f3rka: " + cell.getAlias();
            }
            log.error(message);
            throw new ServiceException("Nieprawid\u0142owy format id roli: " + roleId + ". Format powinien mie\u0107 posta\u0107: packageId:processDefId:roleId");
        }
        String packageId = null;
        String processDefId = null;
        String rId = null;
        if (tab.length == 2) {
            log.debug("Rola pakietowa");
            packageId = tab[0];
            rId = tab[1];
        } else {
            log.debug("Rola procesowa");
            packageId = tab[0];
            processDefId = tab[1];
            rId = tab[2];
        }
        log.debug("PackageId: " + packageId);
        log.debug("ProcessDefId: " + processDefId);
        log.debug("RoleId: " + rId);
        Role role = this.roleService.getRole(packageId, processDefId, rId);
        return role;
    }
}

