/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.LinkTable;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.operationPanel.OperationPanelMethods;
import com.plusmpm.database.operationPanel.OperationPanelParametersTable;
import com.plusmpm.database.operationPanel.OperationPanelTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ImportDefaultViews
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDefaultViews.class);

    @AdvancedTask(name="ImportDefaultViewsFromXLS", description="ImportDefaultViewsFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDefaultViewsFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************************ ImportDefaultViewsFromXLS(sXLSPath=" + sXLSPath + " ) *************************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        HashMap defaultViewsMap = new HashMap();
        String helpUserId = "";
        boolean bSecondPanel = false;
        try {
            String userId;
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Widoki domy\u015blne");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Widoki domy\u015blne w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 12; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z widokami domyslnymi");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    userId = sheet.getCell(((Integer)header.get("U\u017cytkownik")).intValue(), i).getContents();
                    String language = sheet.getCell(((Integer)header.get("Wersja j\u0119zykowa")).intValue(), i).getContents();
                    String template = sheet.getCell(((Integer)header.get("Szablon")).intValue(), i).getContents();
                    String pageSize = sheet.getCell(((Integer)header.get("Ilo\u015b\u0107 pozycji na stronie")).intValue(), i).getContents();
                    String defaultViewType = sheet.getCell(((Integer)header.get("Typ widoku domy\u015blnego")).intValue(), i).getContents();
                    String defaultViewSubtype = sheet.getCell(((Integer)header.get("Podtyp widoku domy\u015blnego")).intValue(), i).getContents();
                    String panelName = sheet.getCell(((Integer)header.get("Nazwa panelu")).intValue(), i).getContents();
                    String panelDescr = sheet.getCell(((Integer)header.get("Opis")).intValue(), i).getContents();
                    String panelParamType = sheet.getCell(((Integer)header.get("Typ parametru")).intValue(), i).getContents();
                    String panelParamName = sheet.getCell(((Integer)header.get("Nazwa parametru")).intValue(), i).getContents();
                    String panelParamPosition = sheet.getCell(((Integer)header.get("Pozycja")).intValue(), i).getContents();
                    String panelParamIsCount = sheet.getCell(((Integer)header.get("Czy liczy\u0107?")).intValue(), i).getContents();
                    if (!Tools.isNullOrEmpty((String)userId)) {
                        helpUserId = userId;
                        bSecondPanel = false;
                        HashMap<String, String> oneDefaultViewMap = new HashMap<String, String>();
                        oneDefaultViewMap.put("language", language);
                        oneDefaultViewMap.put("template", template);
                        oneDefaultViewMap.put("pageSize", pageSize);
                        oneDefaultViewMap.put("defaultViewType", defaultViewType);
                        oneDefaultViewMap.put("defaultViewSubtype", defaultViewSubtype);
                        defaultViewsMap.put(userId, oneDefaultViewMap);
                    }
                    if (!Tools.isNullOrEmpty((String)panelName)) {
                        OperationPanelTable OPT = OperationPanelMethods.getFirstOperationPanelForUser((String)helpUserId);
                        if (OPT != null) {
                            bSecondPanel = true;
                            throw new CUFException("Uzytkownik " + helpUserId + " posiada juz panel uzytkownika");
                        }
                        if (uga.doesUserExist(helpUserId)) {
                            OperationPanelMethods.addOperationPanel((String)panelName, (String)panelDescr, (String)helpUserId);
                            log.info((Object)("Dodano panel uzytkownika o nazwie " + panelName + " dla uzytkownika " + helpUserId));
                        } else {
                            throw new CUFException("Uzytkownik " + helpUserId + " nie istnieje w systemie");
                        }
                    }
                    if (Tools.isNullOrEmpty((String)panelParamType)) continue;
                    String sParam = "";
                    if (bSecondPanel) {
                        throw new CUFException("Uzytkownik " + helpUserId + " posiadal juz wczesniej panel uzytkownika, nie mozna dodac parametru panelu");
                    }
                    OperationPanelTable OPT = OperationPanelMethods.getFirstOperationPanelForUser((String)helpUserId);
                    if (OPT == null) {
                        throw new CUFException("Uzytkownik " + helpUserId + " nie posiada panelu uzytkownika, nie mozna dodawac parametrow panelu");
                    }
                    if (Tools.isNullOrEmpty((String)panelParamName)) {
                        throw new CUFException("Nie podano nazwy parametru dla panelu uzytkownika " + helpUserId);
                    }
                    long lParamPosition = new Long(0L);
                    try {
                        lParamPosition = Long.parseLong(panelParamPosition);
                    }
                    catch (NumberFormatException e) {
                        taskLog.error((Object)e.getMessage());
                        throw new CUFException("Pozycja parametru dla panelu uzytkownika " + helpUserId + " nie ma wartosci liczbowej");
                    }
                    Boolean bIsCount = false;
                    if (panelParamIsCount != null && panelParamIsCount.equalsIgnoreCase("tak")) {
                        bIsCount = true;
                    }
                    if ((panelParamType = ImportDefaultViews.getPanelParamId(panelParamType, helpUserId)).equalsIgnoreCase("docclass")) {
                        DocClassTable docClassTable = dbm.getDocClassByName(panelParamName);
                        if (docClassTable == null) {
                            throw new CUFException("Klasa dokumentow o nazwie " + panelParamName + " nie istnieje w systemie, nie mozna jej dodac jako parametr panelu uzytkownika " + helpUserId);
                        }
                        sParam = docClassTable.getId().toString();
                    } else if (panelParamType.equalsIgnoreCase("link")) {
                        LinkTable linkTable = dbm.getLinkByName(panelParamName);
                        if (linkTable == null) {
                            throw new CUFException("Zestaw dokumentow o nazwie " + panelParamName + " nie istnieje w systemie, nie mozna go dodac jako parametr panelu uzytkownika " + helpUserId);
                        }
                        sParam = linkTable.getId().toString();
                    } else if (panelParamType.equalsIgnoreCase("process")) {
                        sParam = CUFTools.getProcDefIdForProcessName(panelParamName);
                        if (Tools.isNullOrEmpty((String)sParam)) {
                            throw new CUFException("Proces o nazwie " + panelParamName + " nie istnieje w systemie, nie mozna go dodac jako parametr panelu uzytkownika " + helpUserId);
                        }
                    } else if (panelParamType.equalsIgnoreCase("myview")) {
                        ArrayList views = dbm.GetAllUserSearchViewsForUser(helpUserId);
                        if (views != null && views.size() > 0) {
                            for (UserSearchViewTable view : views) {
                                String thisViewName;
                                if (view == null || (thisViewName = view.getViewName()) == null || !thisViewName.equalsIgnoreCase(panelParamName)) continue;
                                sParam = view.getId().toString();
                                break;
                            }
                        }
                        if (Tools.isNullOrEmpty((String)sParam)) {
                            throw new CUFException("Widok o nazwie " + panelParamName + " nie istnieje w systemie, nie mozna go dodac jako parametr panelu uzytkownika " + helpUserId);
                        }
                    } else {
                        sParam = "";
                    }
                    List OPTParams = OperationPanelMethods.getAllOperationPanelParametersForOperationPanel((Long)OPT.getId());
                    if (OPTParams != null && OPTParams.size() > 0) {
                        for (OperationPanelParametersTable panelParam : OPTParams) {
                            if (panelParam == null) continue;
                            String thisParamName = panelParam.getName();
                            String thisParamType = panelParam.getType();
                            if (thisParamName == null || !thisParamName.equalsIgnoreCase(panelParamName) || thisParamType == null || !thisParamType.equalsIgnoreCase(panelParamType)) continue;
                            throw new CUFException("Parametr o nazwie " + panelParamName + " istnieje juz w panelu uzytkownika " + helpUserId);
                        }
                    }
                    OperationPanelMethods.addOperationPanelParameters((Long)OPT.getId(), (String)panelParamName, (String)panelParamType, (String)sParam, (Boolean)bIsCount, (Long)lParamPosition);
                    log.info((Object)("Do panelu uzytkownika " + helpUserId + " dodano parametr " + panelParamName + " typu " + panelParamType));
                    continue;
                }
                catch (CUFException e) {
                    taskLog.error((Object)e.getMessage());
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (defaultViewsMap != null && defaultViewsMap.size() > 0) {
                Iterator users = defaultViewsMap.keySet().iterator();
                while (users.hasNext()) {
                    try {
                        userId = (String)users.next();
                        if (!uga.doesUserExist(userId)) {
                            throw new CUFException("Uzytkownik " + userId + " nie istnieje w systemie, nie mozna dla niego ustawic widoku domyslnego");
                        }
                        log.info((Object)("Proba ustawienia widoku domyslnego dla uzytkownika " + userId));
                        Map oneDefaultViewMap = (Map)defaultViewsMap.get(userId);
                        if (oneDefaultViewMap == null || oneDefaultViewMap.size() == 0) {
                            throw new CUFException("Brak parametrow widoku domyslnego dla uzytkownika " + userId);
                        }
                        String language = (String)oneDefaultViewMap.get("language");
                        String template = (String)oneDefaultViewMap.get("template");
                        String pageSize = (String)oneDefaultViewMap.get("pageSize");
                        String defaultViewType = (String)oneDefaultViewMap.get("defaultViewType");
                        String defaultViewSubtype = (String)oneDefaultViewMap.get("defaultViewSubtype");
                        String defaultViewId = "";
                        if (Tools.isNullOrEmpty((String)language)) {
                            throw new CUFException("Nie okreslono jezyka dla uzytkownika " + userId);
                        }
                        if (Tools.isNullOrEmpty((String)template)) {
                            throw new CUFException("Nie okreslono szablonu dla uzytkownika " + userId);
                        }
                        if (Tools.isNullOrEmpty((String)pageSize)) {
                            throw new CUFException("Nie okreslono ilosci pozycji na stronie dla uzytkownika " + userId);
                        }
                        if (pageSize.equalsIgnoreCase("Domy\u015blna")) {
                            pageSize = "default";
                        } else if (!(pageSize.equalsIgnoreCase("10") || pageSize.equalsIgnoreCase("20") || pageSize.equalsIgnoreCase("30") || pageSize.equalsIgnoreCase("50"))) {
                            throw new CUFException("Niedozwolona ilosc pozycji na stronie dla uzytkownika " + userId);
                        }
                        defaultViewId = ImportDefaultViews.getDefaultViewId(defaultViewType, defaultViewSubtype, userId);
                        dbm.saveUserData(userId, "language", language);
                        dbm.saveUserData(userId, "pageSize", pageSize);
                        dbm.saveUserData(userId, "template", template);
                        dbm.saveUserData(userId, "defaultView", defaultViewId);
                        String helpSbutype = "brak";
                        if (!Tools.isNullOrEmpty((String)defaultViewSubtype)) {
                            helpSbutype = defaultViewSubtype;
                        }
                        log.info((Object)("Ustawiono widok domyslny (typ: " + defaultViewType + ", podtyp: " + helpSbutype + ") dla uzytkownika " + userId));
                    }
                    catch (CUFException e) {
                        taskLog.error((Object)e.getMessage());
                        log.warn((Object)e.getMessage());
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                log.info((Object)"Brak widokow domyslnych do ustawienia");
            }
            log.info((Object)"Zakonczono import widokow domyslnych dla uzytkownikow");
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDefaultViewsFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static String getDefaultViewId(String defaultViewType, String defaultViewSubtype, String userId) throws CUFException, Exception {
        log.trace((Object)("************************ getDefaultViewId(defaultViewType=" + defaultViewType + ", defaultViewSubtype=" + defaultViewSubtype + ", userId=" + userId + ") *************************"));
        String defaultViewId = "";
        DBManagement dbm = new DBManagement();
        if (Tools.isNullOrEmpty((String)defaultViewType)) {
            throw new CUFException("Nie okreslono typu widoku domyslnego dla uzytkownika " + userId);
        }
        if (defaultViewType.equalsIgnoreCase("Domy\u015blny")) {
            defaultViewId = "default";
        } else if (defaultViewType.equalsIgnoreCase("Administracja")) {
            defaultViewId = "admin";
        } else if (defaultViewType.equalsIgnoreCase("Skrzynka zada\u0144")) {
            defaultViewId = "task";
        } else if (defaultViewType.equalsIgnoreCase("Utw\u00f3rz proces")) {
            defaultViewId = "createprocess";
        } else if (defaultViewType.equalsIgnoreCase("Archiwum dokument\u00f3w")) {
            defaultViewId = "archive";
        } else if (defaultViewType.equalsIgnoreCase("M\u00f3j kalendarz")) {
            defaultViewId = "calendar";
        } else if (defaultViewType.equalsIgnoreCase("Znajd\u017a proces")) {
            defaultViewId = "searchprocess";
        } else if (defaultViewType.equalsIgnoreCase("Statystyki")) {
            defaultViewId = "stats";
        } else if (defaultViewType.equalsIgnoreCase("Klasy dokument\u00f3w")) {
            defaultViewId = "docclasses";
        } else if (defaultViewType.equalsIgnoreCase("Klasa dokument\u00f3w")) {
            if (Tools.isNullOrEmpty((String)defaultViewSubtype)) {
                throw new CUFException("Nie podano podtypu widoku domyslnego dla uzytkownika " + userId + ", ktory jest niezbedny w przypadku typu Klasa dokument\u00f3w");
            }
            DocClassTable docClassTable = dbm.getDocClassByName(defaultViewSubtype);
            if (docClassTable == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + defaultViewSubtype + " nie istnieje w systemie, nie mozna jej ustawic jako widok domyslny dla uzytkownika " + userId);
            }
            Long lDocClassId = docClassTable.getId();
            if (lDocClassId == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + defaultViewSubtype + " nie posiada identyfikatora, nie mozna jej ustawic jako widok domyslny dla uzytkownika " + userId);
            }
            defaultViewId = "docclass_" + lDocClassId.toString();
        } else if (defaultViewType.equalsIgnoreCase("Zestawy dokument\u00f3w")) {
            defaultViewId = "links";
        } else if (defaultViewType.equalsIgnoreCase("Zestaw dokument\u00f3w")) {
            if (Tools.isNullOrEmpty((String)defaultViewSubtype)) {
                throw new CUFException("Nie podano podtypu widoku domyslnego dla uzytkownika " + userId + ", ktory jest niezbedny w przypadku typu Zestaw dokument\u00f3w");
            }
            LinkTable linkTable = dbm.getLinkByName(defaultViewSubtype);
            if (linkTable == null) {
                throw new CUFException("Zestaw dokumentow o nazwie " + defaultViewSubtype + " nie istnieje w systemie, nie mozna go ustawic jako widok domyslny dla uzytkownika " + userId);
            }
            Long lLinkId = linkTable.getId();
            if (lLinkId == null) {
                throw new CUFException("Zestaw dokumentow o nazwie " + defaultViewSubtype + " nie posiada identyfikatora, nie mozna go ustawic jako widok domyslny dla uzytkownika " + userId);
            }
            defaultViewId = "link_" + lLinkId.toString();
        } else if (defaultViewType.equalsIgnoreCase("Moje widoki")) {
            ArrayList views = dbm.GetAllUserSearchViewsForUser(userId);
            if (views == null || views.size() == 0) {
                throw new CUFException("Uzytkownik " + userId + " nie posiada widokow, nie mozna ustawic dla niego widoku domyslnego typu Moje widoki");
            }
            defaultViewId = "myviews";
        } else if (defaultViewType.equalsIgnoreCase("Widok")) {
            if (Tools.isNullOrEmpty((String)defaultViewSubtype)) {
                throw new CUFException("Nie podano podtypu widoku domyslnego dla uzytkownika " + userId + ", ktory jest niezbedny w przypadku typu Widok");
            }
            ArrayList views = dbm.GetAllUserSearchViewsForUser(userId);
            if (views == null || views.size() == 0) {
                throw new CUFException("Uzytkownik " + userId + " nie posiada widokow, nie mozna ustawic dla niego widoku domyslnego w postaci widoku o nazwie " + defaultViewSubtype);
            }
            UserSearchViewTable foundView = null;
            for (UserSearchViewTable view : views) {
                String thisViewName;
                if (view == null || (thisViewName = view.getViewName()) == null || !thisViewName.equalsIgnoreCase(defaultViewSubtype)) continue;
                foundView = view;
                break;
            }
            if (foundView == null) {
                throw new CUFException("Uzytkownik " + userId + " nie posiada widoku o nazwie " + defaultViewSubtype + ", nie mozna ustawic dla niego widoku domyslnego w postaci tego widoku");
            }
            Long lViewId = foundView.getId();
            if (lViewId == null) {
                throw new CUFException("Widok o nazwie " + defaultViewSubtype + " nie posiada identyfikatora, nie mozna go ustawic jako widok domyslny dla uzytkownika " + userId);
            }
            defaultViewId = "myview_" + lViewId.toString();
        } else if (defaultViewType.equalsIgnoreCase("Panel u\u017cytkownika")) {
            OperationPanelTable OPT = OperationPanelMethods.getFirstOperationPanelForUser((String)userId);
            if (OPT == null) {
                throw new CUFException("Uzytkownik " + userId + " nie posiada panelu, nie mozna go ustawic jako widok domyslny");
            }
            defaultViewId = "operationPanel";
        } else {
            throw new CUFException("Nieznany typ widoku domyslnego dla uzytkownika " + userId);
        }
        return defaultViewId;
    }

    private static String getPanelParamId(String panelParamType, String userId) throws CUFException, Exception {
        log.trace((Object)("************************ getPanelParamId(panelParamType=" + panelParamType + ", userId=" + userId + ") *************************"));
        String panelParamId = "";
        if (panelParamType.equalsIgnoreCase("Moje widoki")) {
            panelParamId = "myviews";
        } else if (panelParamType.equalsIgnoreCase("Zestawy dokumnet\u00f3w")) {
            panelParamId = "links";
        } else if (panelParamType.equalsIgnoreCase("Utw\u00f3rz proces")) {
            panelParamId = "createprocess";
        } else if (panelParamType.equalsIgnoreCase("Archiwum dokument\u00f3w")) {
            panelParamId = "archive";
        } else if (panelParamType.equalsIgnoreCase("Widok")) {
            panelParamId = "myview";
        } else if (panelParamType.equalsIgnoreCase("Skrzynka zada\u0144")) {
            panelParamId = "task";
        } else if (panelParamType.equalsIgnoreCase("Klasy dokument\u00f3w")) {
            panelParamId = "docclasses";
        } else if (panelParamType.equalsIgnoreCase("Klasa dokument\u00f3w")) {
            panelParamId = "docclass";
        } else if (panelParamType.equalsIgnoreCase("Zestaw dokumnet\u00f3w")) {
            panelParamId = "link";
        } else if (panelParamType.equalsIgnoreCase("Proces")) {
            panelParamId = "process";
        } else {
            throw new CUFException("Nieznany typ parametru panelu uzytkownika " + userId);
        }
        return panelParamId;
    }
}

