/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.plusmpm.util.workflowData.ProcessData;
import java.io.File;
import java.util.Date;
import java.util.Map;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportProcessesSettings
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportProcessesSettings.class);

    @AdvancedTask(name="ExportProcessesSettingsToXLS", description="ExportProcessesSettingsToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportProcessesSettingsToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportProcessesSettingsToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        Map processDefIdsAndNamesMap = null;
        int colPos = 0;
        int rowPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet processesSettingsSheet = workbook.createSheet("Ustawienia proces\u00f3w", 0);
            log.info((Object)"Utworzono arkusz do eksportu ustawien procesow");
            String[] colIDs = new String[]{"Nazwa procesu", "Akceptacja zada\u0144 w procesie z has\u0142em", "Zak\u0142adka Dokumenty procesu", "Zak\u0142adka Informacje", "Zak\u0142adka Opis", "Zak\u0142adka Historia", "Zak\u0142adka Mapa procesu"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            ProcessData processData = new ProcessData();
            processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
            if (processDefIdsAndNamesMap != null && processDefIdsAndNamesMap.size() > 0) {
                for (String procDefId : processDefIdsAndNamesMap.keySet()) {
                    if (Tools.isNullOrEmpty((String)procDefId)) continue;
                    String processName = CUFTools.getProcessNameForProcDefId(procDefId);
                    String acceptTaskWithPassword = dbm.GetProcessData(procDefId, "", "acceptTaskWithPassword");
                    String showDocumentsPanel = dbm.GetProcessData(procDefId, "", "showDocumentsPanel");
                    String showInfoPanel = dbm.GetProcessData(procDefId, "", "showInfoPanel");
                    String showDescriptionPanel = dbm.GetProcessData(procDefId, "", "showDescriptionPanel");
                    String showHistoryPanel = dbm.GetProcessData(procDefId, "", "showHistoryPanel");
                    String showMapPanel = dbm.GetProcessData(procDefId, "", "showMapPanel");
                    log.info((Object)("Eksport ustawien procesu o nazwie " + processName));
                    colPos = 0;
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, ++rowPos, processName, null, cellView);
                    ++colPos;
                    if (acceptTaskWithPassword != null && acceptTaskWithPassword.equalsIgnoreCase("true")) {
                        acceptTaskWithPassword = "tak";
                    } else if (acceptTaskWithPassword != null && acceptTaskWithPassword.equalsIgnoreCase("false")) {
                        acceptTaskWithPassword = "nie";
                    }
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, rowPos, acceptTaskWithPassword, null, cellView);
                    ++colPos;
                    if (showDocumentsPanel != null && showDocumentsPanel.equalsIgnoreCase("true")) {
                        showDocumentsPanel = "tak";
                    } else if (showDocumentsPanel != null && showDocumentsPanel.equalsIgnoreCase("false")) {
                        showDocumentsPanel = "nie";
                    }
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, rowPos, showDocumentsPanel, null, cellView);
                    ++colPos;
                    if (showInfoPanel != null && showInfoPanel.equalsIgnoreCase("true")) {
                        showInfoPanel = "tak";
                    } else if (showInfoPanel != null && showInfoPanel.equalsIgnoreCase("false")) {
                        showInfoPanel = "nie";
                    }
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, rowPos, showInfoPanel, null, cellView);
                    ++colPos;
                    if (showDescriptionPanel != null && showDescriptionPanel.equalsIgnoreCase("true")) {
                        showDescriptionPanel = "tak";
                    } else if (showDescriptionPanel != null && showDescriptionPanel.equalsIgnoreCase("false")) {
                        showDescriptionPanel = "nie";
                    }
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, rowPos, showDescriptionPanel, null, cellView);
                    ++colPos;
                    if (showHistoryPanel != null && showHistoryPanel.equalsIgnoreCase("true")) {
                        showHistoryPanel = "tak";
                    } else if (showHistoryPanel != null && showHistoryPanel.equalsIgnoreCase("false")) {
                        showHistoryPanel = "nie";
                    }
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, rowPos, showHistoryPanel, null, cellView);
                    ++colPos;
                    if (showMapPanel != null && showMapPanel.equalsIgnoreCase("true")) {
                        showMapPanel = "tak";
                    } else if (showMapPanel != null && showMapPanel.equalsIgnoreCase("false")) {
                        showMapPanel = "nie";
                    }
                    CUFTools.addCellToXLSSheet(processesSettingsSheet, colPos, rowPos, showMapPanel, null, cellView);
                    ++colPos;
                }
            } else {
                log.warn((Object)"Brak procesow w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport ustawien procesow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania ustawien procesow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportProcessesSettingsToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

