/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail;

import com.suncode.pwfl.archive.WfDocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;

public class SendMailSender {
    private static Logger log = Logger.getLogger(SendMailSender.class);
    private Map<String, String> smtpConf = this.getSmtpConfiguration();
    private static SendMailSender instance;

    private SendMailSender() {
    }

    public static SendMailSender getInstance() {
        if (instance == null) {
            instance = new SendMailSender();
        }
        return instance;
    }

    public void send(String sReceiverAddress, String sSubject, String sContent, List<WfDocument> listAttachments) throws MessagingException {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.smtpConf.get("SMTPMailServer"));
        properties.setProperty("mail.smtp.port", this.smtpConf.get("SMTPPortNo"));
        properties.setProperty("mail.smtp.auth", this.smtpConf.get("SMTPAuth"));
        properties.setProperty("mail.smtp.starttls.enable", this.smtpConf.get("UseSTARTTLS"));
        properties.setProperty("mail.smtp.ssl.enable", this.smtpConf.get("UseSSL"));
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication((String)SendMailSender.this.smtpConf.get("SMTPUser"), (String)SendMailSender.this.smtpConf.get("UserPassword"));
            }
        });
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(this.smtpConf.get("Email")));
        message.addRecipients(Message.RecipientType.TO, sReceiverAddress);
        message.setSubject(sSubject);
        if (!listAttachments.isEmpty()) {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)sContent, "text/html; charset=utf-8");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (WfDocument attachment : listAttachments) {
                FileDataSource dataSource = new FileDataSource(attachment.getFile().getFullPath());
                messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                messageBodyPart.setFileName(attachment.getFile().getFileName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
        } else {
            message.setContent((Object)sContent, "text/html; charset=utf-8");
        }
        Transport.send((Message)message);
        log.debug((Object)("Wys\u0142ano wiadomo\u015b\u0107 email na adres " + sReceiverAddress));
    }

    private Map<String, String> getSmtpConfiguration() {
        String[] parameters;
        HashMap<String, String> smtpConf = new HashMap<String, String>();
        for (String param : parameters = new String[]{"SMTPMailServer", "SMTPPortNo", "SMTPAuth", "UseSTARTTLS", "UseSSL", "Email", "SMTPUser", "UserPassword"}) {
            smtpConf.put(param, Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler." + param));
        }
        return smtpConf;
    }
}

